#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;

@main::GM_keys = ('spid', 'sp', 'orgname', 'family', 'genus', 'species',
                  'strain', 'taxid', 'institution', 'wwwlink', 'medid',
                  'date_modify', 'date_release');

#
sub printGenomeTxt {
    my($spid) = shift;

    my($filename) = "$ENV{'MBGD_HOME'}/species/$spid/gm/genome.txt";
    my($fh) = new FileHandle("$filename");
    if (! $fh) {
        print STDERR "##### ERROR :: Can not open $filename($!)\n";
        return;
    }

    my($ref) = {};
    $ref->{'spid'} = $spid;
    while(my$line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;
        my($k, $v) = split(/\t/, $line);

        $ref->{"$k"} = $v;
    }
    $fh->close;

    my(@values);
    foreach my$k (@main::GM_keys) {
        push(@values, $ref->{"$k"});
    }
    print join("\t", @values), "\n";

    return;
}

if ($0 eq __FILE__) {
    my(@spidList) = @ARGV;
    if ($main::ALL) {
        my($dh) = new DirHandle("$ENV{'MBGD_HOME'}/species");
        if ($dh) {
            @spidList = ();
            foreach my$file ($dh->read()) {
                next if ($file !~ /^gm\d{5}$/);
                push(@spidList, $file);
            }
        }
    }

    print join("\t", @main::GM_keys), "\n";
    foreach my$spid (@spidList) {
        printGenomeTxt($spid);
    }
}
1;#
