#!/usr/bin/perl -s

use FindBin;
use lib "$FindBin::Bin/lib";
use GenBank;

require 'checkUserData.pl';

@infiles = @ARGV;
$outdir = '.' if (! $outdir);

$filenum = scalar(@infiles);

$gbk = GenBank->new(@infiles);

$spid = 'gu00000' if (! $spid);;

mkdir $outdir if (! -d $outdir);


if (! $gene_head) {
	if ($spname) {
		$gene_head = uc($spname);
	} else {
		$gene_head = "GENE";
	}
}

print OUT_GTAB "#locus_tag,name,from,to,dir,type,descr\n";

while ($e = $gbk->read_entry) {
	$chr->{definition} = $e->{definition};

	$chr->{name} = &define_name($chr->{definition});

	$chr->{shape} = $e->{shape} =~ /circular|linear/  ? $e->{shape} : 'linear';
	$chr->{length} = $e->{length};
	$chr->{seq} = $e->{seq};


	$chrnum++;

	$chrom_id = $chrid ? $chrid : $chrnum; 
	if (! $chrid) {
		$GeneHead = "${gene_head}_${chrom_id}";
	}

	if ($chrid) {
		$outdir_chr = $outdir;
	} else {
		$outdir_chr = sprintf "$outdir/chr%02d", $chrom_id;
	}
	
	$geneTabFile = "$outdir_chr/origGeneTab";
	$protSeqFile = "$outdir_chr/origProtein";
	$dnaSeqFile = "$outdir_chr/origDna";
	$chromFile = "$outdir_chr/chromosome.txt";

	open(OUT_GTAB, ">$geneTabFile");
	open(OUT_PSEQ, ">$protSeqFile");
	open(OUT_GSEQ, ">$dnaSeqFile");
	open(OUT_CHR, ">$chromFile");


	my($id, $rid);

	&output_chr($chr, $chrom_id);
	foreach $f (@{$e->{features}}) {
		$featkey = $f->{keyname};
		$loc = $f->{location};
		if ($featkey =~ /CDS|RNA/) {
			my($d) = {};
#			if ($loc->{locus_tag}) {
#				$d->{name} = $loc->{locus_tag};
#			} else {
#				$d->{name} = sprintf("%s_%04d", $GeneHead, $id);
#			}
			if ($featkey eq 'CDS') {
				$d->{protseq} = $f->{attr}->{translation};
				$d->{name} = sprintf("%s_%04d", $GeneHead, ++$id);
			} else {
				$d->{name} = sprintf("%s_R%03d", $GeneHead, ++$rid);
			}

			$d->{from} = $loc->{from};
			$d->{to} = $loc->{to};
			$d->{dir} = $loc->{complement} ? -1 : 1;
			if ($f->{attr}->{product}) {
				$d->{descr} = $f->{attr}->{product};
			} elsif ($f->{attr}->{function}) {
				$d->{descr} = ref($f->{attr}->{function}) ? $f->{attr}->{function}->[0] : $f->{attr}->{function};
			}
			$d->{geneseq} = $gbk->get_subseq($loc);
			$d->{type} = $featkey;
			$d->{gene} = $f->{attr}->{gene};
			&output_gene($d);
		}
	}
	&checkUploadDataFile($outdir_chr, $geneTabFile, $protSeqFile);
}

sub output_gene {
	my($d) = @_;
	print OUT_GTAB join("\t", $d->{name}, $d->{gene}, $d->{from}, $d->{to}, $d->{dir}, $d->{type}, $d->{descr}),"\n";
	print OUT_PSEQ ">$d->{name}\n$d->{protseq}\n";
#	$d->{geneseq}->print_fasta("$d->{name}");
}

sub output_chr {
	my($c, $chrom_id) = @_;
	print OUT_CHR "id_user_chromosme\t$chrom_id\n";
	print OUT_CHR "chromosome_name\t$c->{name}\n";
	print OUT_CHR "chromosome_shape\t$c->{shape}\n";
	print OUT_CHR "chromosome_length\t$c->{length}\n";
	print OUT_GSEQ ">$spname\n$c->{seq}\n";
}

sub define_name {
	my($name) = @_;
	my($type);
	if ($name =~ /chr/) {
		$type = 'chromosome';
	} elsif ($name =~ /pls/) {
		$type = 'plasmid';
	} else {
		$type = 'contig';
	}
	$Num{$type}++;
	"${type}-$Num{$type}";
}
