#!/usr/bin/perl -s

use MBGD;
require 'MBGD_commonPath.pl';

$db = MBGD::DB->new;
@data = MBGD::Gene->get($db, [$sp]);
if(!@ARGV) {
	$infile = "$DIR_database/class/$sp.class"
} else {
	$infile = $ARGV[0];
}
if ($replace) {
	$outfile = "$infile.out";
	open(OUT, ">$outfile");
} else{
	open(OUT, ">&STDOUT");
}
foreach $d (@data) {
	if ($d->{gene}) {
		$g = uc($d->{gene}); 
		$Gene{$g} = $d->{name};
	}
}
open(IN, $infile) || die;
while (<IN>) {
	($clid,$name,$dmy,$descr) = split(/\t/);
	if ($Gene{$name}) {
		print OUT join("\t", $clid, $Gene{$name}, $dmy, $descr);
	} else {
		if ($Gene{"${name}_1"}) {
			print OUT join("\t", $clid, $Gene{"${name}_1"}, $dmy, $descr);
		} else{
			print OUT $_;
		}
	}
}
close(IN);
if ($replace) {
	rename $infile, "$infile.BCK";
	rename $outfile, $infile;
}
