#!/usr/bin/perl -s
use strict;
use MBGD;
require "libMBGDFuncCat.pl";


###############################################################################
#
%main::printed;
sub printMbgdOrigFunction {
    my($sp) = shift;
    my($ref) = {};
    my($line);

    my($filename) = "$ENV{'MBGD_HOME'}/database/class/$sp.cl";
    my($fh) = new FileHandle("$filename") || return;
    while ($line = $fh->getline()) {
        next if ($line =~ /^\s*$/);

        $line =~ s#[\r\n]*$##;

        my($level, $name) = split(/\t/, $line);
        my(@lev) = split(/\./, $level);
        my(@nam) = split(/\/+/, $name);

        my($prev) = "$sp:";
        for(my$i = 0; $i < scalar(@lev); $i++) {
            my($l) = $lev[$i];
            my($n) = $nam[$i];
            $n =~ s#^\s*##;
            $n =~ s#\s*$##;

            my($lev) = "$prev$l";
            if (! $main::printed{"$lev,$n"}) {
                print join("\t", 'mbgd_orig', $lev, $n, '\N'), "\n";
                $main::printed{"$lev,$n"} = 1;
            }

            $prev = "$lev.";
        }
    }
}

###############################################################################
#
sub printMbgdFunction {
    my($refHashName2Color, $refArrayNames) = create_color_hash();

#    print join("\t", 'dbname', 'level', 'name'), "\n";
    foreach my$name (@{$refArrayNames}) {
        next if ($name =~ /^\s*#/);
        $name =~ s#^\s*##;
        $name =~ s#\s*$##;
        print join("\t", 'mbgd', '1', $name, '\N'), "\n";
    }
}

###############################################################################
#
sub printMbgdOrigGeneFunction {
    my($sp) = shift;
    my($line);

    #
    my($file) = "$ENV{'MBGD_HOME'}/database/class/colortab.category";
    my($ref) = parseColortabCategory($file);

    #
    my($refFunction) = getFunction('test_function', 'mbgd_orig');

    my($fileClass) = "$ENV{'MBGD_HOME'}/database/class/$sp.class";
    my($fh) = new FileHandle("$fileClass");
    if (! $fh) {
        print STDERR "WARNING :: Can not open $fileClass($!)\n";
        return;
    }

    while($line = $fh->getline()) {
        my($level, $orf) = split(/\t/, $line);

        my($funcEnt) = getColortabCategory($ref, $sp, $level);
        my($funcName) = $funcEnt->{'FUNC_NAME'};
        my($fid) = $refFunction->{'name2id'}->{"$funcName"};
        print join("\t", $sp, $orf, $funcName, $fid), "\n";
    }
}

###############################################################################
#
sub printMbgdGeneFunction {
    my($sp) = shift;

    #
    my($file) = "$ENV{'MBGD_HOME'}/database/class/colortab.category";
    my($ref) = parseColortabCategory($file);

    my($db) = MBGD::DB->new($ENV{'MYSQL_DB'});
    my(@listGeneInfo) = MBGD::Gene->get($db, [$sp]);
    foreach my$geneInfo (@listGeneInfo) {
        my($spOrf) = join(':', $geneInfo->{'sp'}, $geneInfo->{'name'});
        my($funcCat) = get_func_category($spOrf);

        next if (! $funcCat);

        my($funcEnt) = getColortabCategory($ref, $sp, $funcCat);
        my($funcName) = $funcEnt->{'FUNC_NAME'};
        print join("\t", $sp, $geneInfo->{'name'}, $funcName), "\n";
    }
}

###############################################################################
if ($0 eq __FILE__) {

    if ($main::FUNC) {
        printFunction();
        exit(0);
    }

    printMbgdFunction() if ($main::function && $main::majority);
    foreach my$sp (@ARGV) {
        printMbgdOrigFunction($sp)     if ($main::function && $main::original);
        printMbgdOrigGeneFunction($sp) if ($main::gene     && $main::original);
        printMbgdGeneFunction($sp)     if ($main::gene     && $main::majority);
    }
}

###############################################################################
1;#
###############################################################################
