#include <iostream>
#include "GeneData.h"
using namespace std;

//class GeneData
GeneData::GeneData(string& _spec, string& _name,
		int& _len, int& _pos, int& _dir) :
	spec(_spec), name(_name), len(_len), pos(_pos), dir(_dir) {
}
void GeneData::print() {
	cout << spec << " " << name << " " << len << " " << pos << " " << dir << endl;
}
ostream& operator<<(ostream& ost, const GeneData& gd) {
	return (ost << gd.spec << " " << gd.name << " " <<
		gd.len << " " << gd.pos << " " << gd.dir << endl);
}

//class GeneDataSet
GeneDataSet::GeneDataSet() {
	
}
void GeneDataSet::makeIndex() {
	for (int idx = 0; idx < geneSet.size(); idx++) {
		GeneData *gdata = &geneSet[ idx ];
		geneMap.insert(GeneMap_t::value_type(gdata->getName(), idx));
	}
}
void GeneDataSet::printAllGenes() {
	for (int i = 0; i < geneSet.size(); i++) {
		geneSet[i].print();
	}
}
GeneData* GeneDataSet::getGeneDataByName(string name) {
	GeneMap_t::iterator gdata_iter = geneMap.find(name);
	if (gdata_iter == geneMap.end()) {
		return NULL;
	} else {
		return &(geneSet[gdata_iter->second]);
	}
}
