#ifndef _PAIRDIST_H_
#define  _PAIRDIST_H_
#include <iostream>
#include "ClusterNode.h"
#include "HomData.h"
#include "Domain.h"
#include "MemAlloc.hpp"
#include "SimValue.h"

using namespace std;

class ClusterNode;

class PairDist {
	static MemAlloc<PairDist> objPool;
	ClusterNode *node1, *node2;
	SimValue simVal;
	int count;
	bool deleted;
	int id;
	short refcount;
	static int totalNum;
public:
	static PairDist *create(ClusterNode *node1, ClusterNode *node2, double dist=0, double score=0);
	static PairDist *create(HomData *hdata);
	static void freeAll();
	static void reset();
	PairDist() {}
/*
	PairDist(HomData *hdata);
	PairDist(ClusterNode *_node1, ClusterNode *_node2, double dist, double score);
*/
	ClusterNode *mergeNodes();
	void initialize(ClusterNode *_node1, ClusterNode *_node2, double dist, double score);
	ClusterNode *getNode(int num) {return (num == 0 ? node1: node2);}
	void setScores(const double& _dist, const double& _score) {
		simVal.setScores(_dist, _score);
	}
	SimValue& getSimValData() {
		return(simVal);
	}
	double getSimValue() const {
		return(simVal.getSimValue());
	}
	double getSimValueScore() const {
		return(simVal.getSimValueScore());
	}
	double getDist() const {
		return(simVal.getDist());
	}
	double getScore() const {
		return(simVal.getScore());
	}
	void setDist(double dist) {
		simVal.setDist(dist);
	}
	void setScore(double score) {
		simVal.setScore(score);
	}
	int getCount() const;
/*
	int getCount() const {
		return(count);
	}
*/
	void setCount(int _count) {
		count = _count;
	}
	int getID() const {
		return id;
	}
	struct cmpPairDist {
		bool operator()(PairDist * const &pd1, PairDist * const &pd2) const {
			return pd1->getSimValData() > pd2->getSimValData();
		}
	};
	void deleteThis() {
//cout << "DEL:" << *this << endl;
		deleted = true;
	}
	bool isDeleted() {
		return(deleted);
	}
	void declRef();
	short getRefcount() {return refcount; }
	bool checkName(string name) {
		return (node1->getName()==name || node2->getName()==name);
	}
	void print(ostream& ost=cout);
	friend ostream& operator<<(ostream&, const PairDist&);
};
#endif
