#include "SpecSet.h"
#include <iostream>

/*
vector<string> SpecSet::species;
vector<double> SpecSet::SPweight;
*/
string SpecSet::species[MAX_SPNUM];
double SpecSet::SPweight[MAX_SPNUM];
map<string, int> SpecSet::specIdx;
int SpecSet::spnum = 0;

int SpecSet::getSPid(string spec) {
	addNewSpecies(spec);
	return(specIdx[spec]);
}
void SpecSet::addNewSpecies(string& spec) {
	map<string, int>::iterator p = specIdx.find(spec);
	if (p == specIdx.end()) {
		species[spnum] = spec;
		specIdx[spec] = spnum;
		SPweight[spnum] = 1.0;
		spnum++;
	}
}
bool SpecSet::checkSpecies(const string& spec) {
	map<string, int>::iterator p = specIdx.find(spec);
	return (p != specIdx.end());
}
void SpecSet::setSPweight(int id, double weight) {
	SPweight[id] = weight;
}
void SpecSet::copySpecSet(SpecSet& _spSet) {
	specSet = _spSet.specSet;
}
/* add multiple species specified in a SpecSet object */
void SpecSet::setSpecSet(SpecSet* spSet) {
	specSet |= spSet->specSet;
}
/* add multiple species specified by a string set */
void SpecSet::setSpecSet(set<string>* spSet) {
	set<string>::iterator p;
	for (p = spSet->begin(); p != spSet->end(); p++) {
		setSpecSet(*p);
	}
}
/* add a species specified by a specid */
void SpecSet::setSpecSet(int spid) {
	specSet.set(spid);
}
/* add a species specified by a species name */
void SpecSet::setSpecSet(string spec) {
	int id = getSPid(spec);
	specSet.set(id);
}

bool SpecSet::getSpFlag(string spname) {
	int id;
	if (! checkSpecies(spname)) {
		return false;
	}
	id = getSPid(spname);
	return getSpFlag(id);
}
bool SpecSet::getSpFlag(int spid) {
	return(specSet[spid]);
}

string SpecSet::toString() {
	string s = specSet.to_string<char,char_traits<char>,allocator<char> > ();
	return s.substr(s.length() - spnum, spnum);
}
void SpecSet::printSpSet(ostream& ost) const {
	for (int i = 0; i < spnum; i++) {
		ost << specSet[i];
	}
}
ostream& operator<<(ostream& ost, const SpecSet& spset) {
	spset.printSpSet(ost);
	return ost;
}
void SpecSet::flip() {
	specSet.flip();
}
void specFlagCOMPL(const SpecSet& spset1, SpecSet& newSpSet) {
	newSpSet.specSet = spset1.specSet;
	newSpSet.flip();
}

void specFlagAND(const SpecSet& spset1, const SpecSet& spset2, SpecSet& newSpSet) {
	newSpSet.specSet = spset1.specSet;
	newSpSet.specSet &= spset2.specSet;
}
void specFlagOR(const SpecSet& spset1, const SpecSet& spset2, SpecSet& newSpSet) {
	newSpSet.specSet = spset1.specSet;
	newSpSet.specSet |= spset2.specSet;
}
void specFlagANDNOT(const SpecSet& spset1, const SpecSet& spset2, SpecSet& newSpSet) {
	SpecSet not_spset2;
	specFlagCOMPL(spset2, not_spset2);
	specFlagAND(spset1, not_spset2, newSpSet);
	
}
int specFlagANDcnt(const SpecSet& spset1, const SpecSet& spset2) {
	SpecSet tmp_spset;
	specFlagAND(spset1, spset2, tmp_spset);
	return tmp_spset.count();
}
int specFlagORcnt(const SpecSet& spset1, const SpecSet& spset2) {
	SpecSet tmp_spset;
	specFlagOR(spset1, spset2, tmp_spset);
	return tmp_spset.count();
}
/* spset1 includes spset2 */
bool specFlagInclude(const SpecSet& spset1, const SpecSet& spset2) {
//	cout << "include: " << spset2.count() << " " << specFlagANDcnt(spset1, spset2) << endl;
	return(spset2.count() == specFlagANDcnt(spset1, spset2));
}

/* 0: no match, 1: partially matched 2: all of spset1 are included in spset2 */
int specFlagMaskCheck(const SpecSet& spset1, const SpecSet& spset2) {
	SpecSet matched;
	int matched_spcnt, spcnt;
	specFlagAND(spset1, spset2, matched);
	matched_spcnt = matched.count();
	if (matched_spcnt) {
		spcnt = spset1.count();
		if (matched_spcnt == spcnt) {
		/* all organisms in the set are matched */
			return 2;
		} else {
		/* there exists at least one matched organism */
			return 1;
		}
	}
	return 0;
}


/***
main() {
	SpecSet spSet;
	cout << spSet.getSPid("eco") << endl;
	cout << spSet.getSPid("bsu") << endl;
	cout << spSet.getSPid("syn") << endl;
	cout << spSet.getSPid("eco") << endl;
	cout << spSet.toString() << endl;
	spSet.setSpecSet("mja");
	spSet.setSpecSet("bsu");
	spSet.setSpecSet("mth");
	cout << spSet.getSPid("mja") << endl;
	cout << spSet.toString() << endl;
}
**/
