#ifndef _SPECTREE_H_
#define _SPECTREE_H_
#include <bitset>
#include <vector>
#include <map>
#include <set>
#include "SpecSet.h"


struct TaxNode {
	int spid;
	int parent;
	int child, sibling;
	double weight;
	SpecSet spSet;
	char flag;
	char *name;
	TaxNode(int spid, int parent, double weight);
};

class SpecTree {
	vector<TaxNode> nodeList;
	bool replaceLeafName;
public:
	SpecTree();
	TaxNode *getNode(int idx) { return &nodeList[ idx ]; }
	void addTaxNode(TaxNode& node);
	void createNewNode(int spid, int parent, char flag);
	void addSpecies();
	void setSpflag();
	int matchFlags(SpecSet& spSet);
	string getTaxName(int taxid);
	void print();
	bool isLeaf(int nodeid);
	int countChild(int nodeid);
	void unset_replaceLeafName();
};
class SpecTreeRead {
	SpecSet *specSet;
public:
	SpecTreeRead() : specSet(NULL) { }
	SpecTreeRead(SpecSet* specSet) { setSpecSet(specSet); }
	void setSpecSet(SpecSet* _specSet) { specSet = _specSet; }
	SpecTree* readSPfile(char *filename);
	SpecTree* parse_tree(const char *str, SpecTree *spTree);
	void parse_spinfo_error();
};
#endif
