#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <cstring>
#include <stack>
#include <vector>

#include "Tree.h"
#include "Domain.h"
#include "DEBUG.h"

using namespace std;

#include "PairDist.h"
#include "ClusterNode.h"

/*
class ClusterNode;
extern ClusterNode *ClusterNode::createLeafNode(Domain*);
*/


// class Node 
TreeNode::TreeNode() {
	initialize();
}
TreeNode::TreeNode(TreeNode* _parent) {
	initialize();
	parent = _parent;
	if (parent != NULL) {
		if (parent->child[0] == NULL) {
			parent->child[0] = this;
		} else {
			parent->child[1] = this;
		}
	}
}
void TreeNode::initialize() {
	id = ++nodenum;
	id2 = 0;
	parent = child[0] = child[1] = NULL;
}
TreeNode::~TreeNode() {
}
TreeNode* TreeNode::getParent() {
	return parent;
}
TreeNode* TreeNode::getChild(int cidx) {
	return child[cidx];
}
void TreeNode::addChild(int cidx, TreeNode *node) {
	child[cidx] = node;
}
int TreeNode::getID() {
	return(id);
}
void TreeNode::setID2(int _id) {
	id2 = _id;
}
int TreeNode::getID2() {
	return(id2);
}
void TreeNode::setDomain(Domain *_dom) {
	dom = _dom;
}
void TreeNode::setDomain(string name, int from, int to, int num) {
	dom = DomainPool::create(name, from, to, num);
}
Domain* TreeNode::getDomain() {
	return dom;
}
string TreeNode::getName() {
	return dom->getName();
}
bool TreeNode::isLeaf() {
	return (child[0] == NULL && child[1] == NULL);
}
void TreeNode::print() {
	cout << id << endl;
}

ostream& operator<<(ostream& ostr, const TreeNode& node) {
	return ostr << node.id;
}

int TreeNode::nodenum = 0;

// class BaseTree 
BaseTree::BaseTree(BaseNode* _root, string _name) :
	name(_name), root(_root) {
}
string BaseTree::getName() {
	return name;
}
void BaseTree::printTree() {
	head = "";
	printTree_sub(root, 0, 1);
}
void BaseTree::printTree_sub(BaseNode* n, int lev, int dir) {
	char markChar = '+';

	if (n == 0) {
		return;
	}
/*
	ClusterNode *cn = dynamic_cast<ClusterNode *>(n);
*/

	if (n->isLeaf()) {
		Domain *dom = n->getDomain();
		Domain *orig_dom = dom->getOrigDomain();
		cout << head << markChar << "- ";
		cout << *orig_dom;
//		cout << *(n->getDomain()) << " [" << n->getID() << "]";
/*
		if (cn != NULL) {
			cout << " " << cn->getSpSetString();
		}
*/
		cout << endl;
	} else {
		head.resize(lev * 2);
		head.append( (lev > 0 && dir == -1) ? "| " : "  ");
		printTree_sub(n->getChild(0), lev+1, 1);
		head.resize(lev * 2);
		cout << head << markChar << "-| ";
//		cout << n->getSimValue() << endl;
//		cout << n->getSimValue() << " ["<<n->getID()<<"] "<<endl;
//		cout << n->getSimValue() << " ["<<n->getID()<<"]";
		cout << n->getSimValue();
/*
		if (cn != NULL) {
			cout << " " << cn->getSpSetString();
		}
*/
		cout << endl;
		head.append( (lev > 0 && dir == 1) ? "| " : "  ");
		printTree_sub(n->getChild(1), lev+1, -1);
	}
}
void BaseTree::printTreeDetail() {
	printTreeDetail_sub(root, NULL);
}
void BaseTree::printTreeDetail_sub(BaseNode* node, BaseNode *parent) {
	Edge *child;
	Domain *dom;
	char markchar;
	int pid = -1;

	if (parent != NULL) {
		pid = parent->getID();
	}
	dom = node->getDomain();

	if (node->isLeaf()) {
		printf("L %d %d %s ", node->getID(), pid, node->getName().c_str());
		printf("%d %d %d", dom->getFrom(), dom->getTo(), dom->getDomNum());
		putchar('\n');
	} else {
		printf("I %d %d %s ", node->getID(), pid, node->getName().c_str());
/*
		printf("%.1f %.1f\n", node->getScore(), node->getDist());
*/
		printTreeDetail_sub(node->getChild(0), node);
		printTreeDetail_sub(node->getChild(1), node);
	}
}


void BaseTree::printNewick(bool withdist)
{
	printNewick_sub(root, ((double) -1.0), withdist );
	printf(";\n");
}
void BaseTree::printNewick_sub(BaseNode *tnode, double prevdist, bool withdist)
{
	double dist = 0;
	double currdist = 0;
	char namebuf[80];

	if (tnode == NULL) {
	} else if (tnode->isLeaf()) {
		Domain *dom = tnode->getDomain();
		Domain *orig_dom = dom->getOrigDomain();
		int domnum = dom->getDomNum();

		if (domnum > 0) {
			sprintf(namebuf, "%s#%d", dom->getOrigName().c_str(), domnum);
		} else {
			strcpy(namebuf, tnode->getName().c_str());
		}
		BaseTree::convname(namebuf);
		if (withdist) {
			printf("%s", namebuf);
			if (prevdist >= 0) {
				dist = prevdist;
				printf(":%.1f ",  (float)dist);
			}
		} else {
			printf("%s", namebuf);
		}
	} else {
		currdist = tnode->getSimValue() / 2;
		printf("(");
		printNewick_sub(tnode->getChild(0), currdist, withdist);
		printf(", ");
		printNewick_sub(tnode->getChild(1), currdist, withdist);
		printf(")");
		if (withdist) {
			if (prevdist >= 0) {
				dist = prevdist - currdist;
				printf(":%.1f ",  (float)dist);
			}
		}
	}
}
void BaseTree::convname(char *name)
{
	register char *p;
	for (p = name; *p; p++) {
		if (*p == ':') {
			*p = '_';
		}
	}
}

/*
vector<BaseNode *>& BaseTree::getAllLeaves() {
	if (leaves.size() > 0) {
	} else {
		
		getAllLeaves_sub(root);
	}
	return leaves;
}
void BaseTree::getAllLeaves_sub(BaseNode *n) {
	if (n==0) {
		return;
	}
	if (n->isLeaf()) {
		leaves.push_back(n);
	} else {
		getAllLeaves_sub(n->getChild(0));
		getAllLeaves_sub(n->getChild(1));
	}
}
*/

//class Tree (subclass of BaseTree)
DistTree::DistTree(TreeNode* _root, string _name) :
	BaseTree(_root, _name), root(_root) {
}
DistTree::~DistTree() {
	delete_nodes(root);
}
void DistTree::delete_nodes(TreeNode *n) {
	if (! n->isLeaf()) {
		delete_nodes(n->getChild(0));
		delete_nodes(n->getChild(1));
	}
	delete n;
}

list<TreeNode *>& DistTree::getAllLeaves() {
	if (! leaves.empty()) {
	} else {
		getAllLeaves_sub(root);
	}
	return leaves;
}
void DistTree::getAllLeaves_sub(TreeNode *n) {
	if (n==0) {
		return;
	}
	if (n->isLeaf()) {
		leaves.push_back(n);
	} else {
		getAllLeaves_sub(n->getChild(0));
		getAllLeaves_sub(n->getChild(1));
	}
}
vector<PairDist *>* DistTree::convDistMat() {
	Tree2DistMat t2mat;
	return t2mat.convert(root);
}
Tree2DistMat::Tree2DistMat() {
	distMat = new vector<PairDist *>();
}
Tree2DistMat::~Tree2DistMat() {
}
vector<PairDist *>* Tree2DistMat::convert(TreeNode *root) {
	convertTree(root);
	deleteLeaves(root);
	return distMat;
}
void Tree2DistMat::convertTree(TreeNode *n) {
	if (n->isLeaf()) {
		n->leaves.push_back(n);
	} else {
		TreeNode *child1 = n->getChild(0);
		TreeNode *child2 = n->getChild(1);
		Tree2DistMat::convertTree(child1);
		Tree2DistMat::convertTree(child2);
		list<TreeNode*>::iterator p, q;
		string pairname;
		for (p = child1->leaves.begin(); p != child1->leaves.end(); p++) {
			TreeNode *n1 = *p;
			Domain *d1 = n1->getDomain();
			Domain *ali_d1 = DomainPool::create(d1);
			string domname1 = ali_d1->getDomName();
			for (q = child2->leaves.begin();
					q != child2->leaves.end(); q++) {
				TreeNode *n2 = *q;
				Domain *d2 = n2->getDomain();
				Domain *ali_d2 = DomainPool::create(d2);
				string domname2 = ali_d2->getDomName();

				if (domname1 <= domname2) {
					pairname = domname1+":"+domname2;
				} else {
					pairname = domname2+":"+domname1;
				}
				if (pairnameSet.find(pairname) != pairnameSet.end()) {
					/* skip duplication */
					continue;
				}
				pairnameSet.insert(pairname);

				ClusterNode *cnode1, *cnode2;
				cnode1 = ClusterNode::createLeafNode(ali_d1);
				cnode2 = ClusterNode::createLeafNode(ali_d2);
				PairDist *pdist = PairDist::create(
				   cnode1, cnode2, n->getDist(), n->getScore());
				distMat->push_back(pdist);

/*
				cout << "##"<<
					d1->getName() << " " <<
					d1->getFrom() << " " <<
					d1->getTo() << " " <<
					d2->getName() << " " <<
					d2->getFrom() << " " <<
					d2->getTo() << " " <<
					" " << n->getScore() << endl;
*/
			}
		}
		n->leaves.splice(n->leaves.begin(), n->getChild(0)->leaves);
		n->leaves.splice(n->leaves.begin(), n->getChild(1)->leaves);
	}
}
void Tree2DistMat::deleteLeaves(TreeNode *n) {
	if (! n->isLeaf()) {
		deleteLeaves(n->getChild(0));
		deleteLeaves(n->getChild(1));
	}
	n->leaves.clear();
}
// class DistTreeList
class CompareNodesByName {
public:
        bool operator()(TreeNode*& a, TreeNode*& b) {
		return ( ( a->getDomain()->getDomName() ) < ( b->getDomain()->getDomName() ) );
	}
};

DistTreeList::DistTreeList() : treeList(), leaves() {
}
 
void DistTreeList::add(DistTree *tree) {
	treeList.push_back(tree);
}
void DistTreeList::setData(list<DistTree*>* list) {
	treeList.splice(treeList.begin(), *(list));
	if (! treeList.empty()) {
		DistTree *tree = *(treeList.begin());
		name = tree->getName();
	}
//cout << "listlen: " << treeList.size() << endl;
}
vector<PairDist *>* DistTreeList::convDistMat() {
	Tree2DistMat t2mat;
	for (list<DistTree*>::iterator p = treeList.begin(); p != treeList.end(); p++) {
		t2mat.convert((*p)->getRoot());
	}
	return t2mat.getDistMat();
}
list<TreeNode *>& DistTreeList::getAllLeaves() {
	list<TreeNode*> lv;
	CompareNodesByName cmp_fn;

	if (! leaves.empty()) {
		return leaves;
	}

	for (list<DistTree*>::iterator p = treeList.begin(); p != treeList.end(); p++) {
		lv = (*p)->getAllLeaves();
		lv.sort(cmp_fn);
		leaves.merge(lv, cmp_fn);
	}
	return leaves;
}
void DistTreeList::clearTree() {
	for (list<DistTree*>::iterator p = treeList.begin(); p != treeList.end(); p++) {
		delete (*p);
	}
}


// class ReadTree
ReadTree::ReadTree() {
	is = &cin;
}
ReadTree::~ReadTree() {
}
int ReadTree::openFile(const char *filename) {
	if (strcmp(filename, "stdin") == 0) {
		is = &cin;
	} else {
		ifs.open(filename);
		if (ifs.fail()) {
			return(-1);
		}
		is = &ifs;
	}
	return(0);
}
void ReadTree::readOptions(Options *opt) {
	char buf[BUFSIZ+1];
	if (is == &ifs && ! ifs.is_open()) {
		return;
	}
	while ( !is->eof()) {
		char c;
		is->get(c);
		if (c != '#') {
			is->unget();
			break;
		}
		is->getline(buf, BUFSIZ);
		char *p;
		for (p = buf; *p == ' '; p++) {
		}
		if (strncmp(p, "simtype=", 8) == 0) { 
			int simtype;
			if (opt->simtype < 0) {
				istringstream is(p+8);
				is >> simtype;
				opt->simtype = simtype;
			}
		} else if (strncmp(p, "cutoff=", 7) == 0) { 
			if (! opt->cutoff) {
				istringstream is(p+7);
				is >> opt->cutoff;
			}
		} else if (strncmp(p, "missdist=", 9) == 0) { 
			if (! opt->missdist) {
				istringstream is(p+9);
				is >> opt->missdist;
			}
		} else if (strncmp(p, "phylocutratio=", 14) == 0) { 
			if (! opt->phylocutratio) {
				istringstream is(p+14);
				is >> opt->phylocutratio;
			}
		} else if (strncmp(p, "distscale=", 10) == 0) { 
			if (! opt->distscale) {
				istringstream is(p+10);
				is >> opt->distscale;
			}
		}
	}
}
DistTree *ReadTree::readTree(list<DistTree*>* treeList, bool addFlag) {
	char buf[BUFSIZ+1];
	char type;
	int nodeid, parent;
	string name;
	int from, to, num;
	double score, pam;
	double score_hom, dist_hom;
	string dmy, clname;
	static string homclname;
	TreeNode *node, *prevNode = NULL;
	stack<TreeNode*> nodeStack;
	DistTree *tree = NULL;
	DistTree *rettree = NULL;

	if (! addFlag) {
		treeList->clear();
	}

	if (is == &ifs && ! ifs.is_open()) {
		return NULL;
	}
	homclData.name = "";
	while ( !is->eof()) {
		is->getline(buf, BUFSIZ);
		if (buf[0] == '#') {
			continue;
		} else if (strncmp(buf, "HomCluster", 7) == 0) {
			istringstream is(buf);
			is >> dmy >> homclname >> dmy >> score_hom >> dist_hom;
			homclData.name = homclname;
			homclData.score = score_hom;
			homclData.dist = dist_hom;
		} else if (strncmp(buf, "Cluster", 7) == 0) {
			istringstream is(buf);
			is >> dmy >> clname;
/*
			if (tree) {
				tree->printTree();
			}
*/
			prevNode = NULL;
			while (! nodeStack.empty()) {
				nodeStack.pop();
			}
		} else if (strncmp(buf, "//", 2) == 0) {
			return rettree;
		} else if (strncmp(buf, "--", 2) == 0) {
			prevNode = NULL;
			while (! nodeStack.empty()) {
				nodeStack.pop();
			}
			continue;
		} else if (strlen(buf) == 0) {
			continue;
		} else {
			istringstream is(buf);
			is >> type >> nodeid >> parent >> name;
//			cout << nodeid <<" "<<parent << endl;
			while (! nodeStack.empty() && (prevNode = nodeStack.top())) {
				if (prevNode->getID2() == parent) {
					break;
				}
				nodeStack.pop();
			}
			node = new TreeNode(prevNode);
			if (prevNode == NULL) {
				if (! homclname.empty()) {
					tree = new DistTree(node, homclname + "//" + clname);
				} else {
					tree = new DistTree(node, clname);
				}
				treeList->push_back(tree);
				if (! rettree) {
					rettree = tree;
				}
			}
			node->setID2(nodeid);
			nodeStack.push(node);
			prevNode = node;
			if (type == 'L') {
				// leaf
				is >> from >> to >> num;
//				cout << "from="<< from << " " << to << endl;
				Domain *dom = DomainPool::create(name, from, to, num);
				node->setDomain(dom);
			} else if (type == 'I') {
				// internal
				is >> score >> pam;
//				cout << "SSS " << score << " " << pam << endl;
				node->setScores(pam, score);
			}
		}
	}
	return NULL;
}

// class Edge
ostream& operator<<(ostream& ostr, const Edge& edge) {
	return ostr << edge.id;
}
