#ifndef _TREE_H_
#define _TREE_H_
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <stack>
#include <list>
#include <vector>

#include "Domain.h"
#include "SimValue.h"
#include "Options.h"
//#include "PairDist.h"

using namespace std;

class PairDist;

// class BaseNode (base class)
class BaseNode {
public:
	virtual BaseNode *getChild(int cidx) = 0;
	virtual BaseNode *getParent() = 0;
	virtual string getName() = 0;
	virtual int getID() = 0;
	virtual double getSimValue() = 0;
/*
	virtual double getScore() = 0;
	virtual double getDist() = 0;
*/
	virtual Domain *getDomain() = 0;
	virtual bool isLeaf() = 0;
	virtual ~BaseNode() {};
};

// class TreeNode
class TreeNode : public BaseNode {
	int id, id2;
	TreeNode *parent, *child[2];
	static int nodenum;
	Domain *dom;
	SimValue simVal;
public:
	list<TreeNode*> leaves;
	TreeNode();
	TreeNode(TreeNode* _parent);
	void initialize();
	~TreeNode();
	TreeNode* getParent();
	TreeNode* getChild(int cidx);
	void addChild(int cidx, TreeNode *node);
	int getID();
	void setID2(int _id);
	int getID2();
	void setDomain(Domain *dom);
	void setDomain(string name, int from, int to, int num);
	Domain* getDomain();
	string getName();
	bool isLeaf();
	void outputNodeScore();
	// SimScore
	void setScores(const double& _pam, const double& _score) {
		simVal.setScores(_pam, _score);
	}
	SimValue& getSimValData() {
		return(simVal);
	}
	double getSimValue() {
		return(getSimValData().getSimValue());
	}
	double getScore() {
		return(simVal.getScore());
	}
	double getDist() {
		return(simVal.getDist());
	}
	bool betterSimValue(double sim) {
		return(simVal.betterSimValue(sim));
	}
	bool worseSimValue(double sim) {
		return(simVal.worseSimValue(sim));
	}

	void print();
	friend ostream& operator<<(ostream&, const TreeNode&);
};

class BaseTree {
protected:
	string name;
	string head;
	void printNewick_sub(BaseNode* n, double prevdist, bool withdist);
	void printTree_sub(BaseNode* n, int lev, int dir);
	void printTreeDetail_sub(BaseNode* n, BaseNode *parent);
	void convname(char *str);
	BaseNode* root;
public:
	BaseTree(BaseNode* _root, string _name="");
	string getName();
	void printNewick(bool withdist=false);
	void printTree();
	void printTreeDetail();
/*
	list<BaseNode *>& getAllLeaves();
*/
	BaseNode *getRoot() { return root; }
};

class DistTree : public BaseTree {
	TreeNode* root;
	void getAllLeaves_sub(TreeNode *);
	list<TreeNode*> leaves;
public:
	DistTree(TreeNode* _root, string _name="");
	~DistTree();
	void delete_nodes(TreeNode *node);
	vector<PairDist *>* convDistMat();
	list<TreeNode *>& getAllLeaves();
	TreeNode *getRoot() { return root; }
};

class Tree2DistMat {
	vector<PairDist*>* distMat;
	set<string> pairnameSet;
	void convertTree(TreeNode *);
	void deleteLeaves(TreeNode *);
public:
	Tree2DistMat();
	~Tree2DistMat();
	vector<PairDist *>* convert(TreeNode *);
	vector<PairDist *>* getDistMat() {return distMat;}
};
class DistTreeList {
	list<DistTree*> treeList;
	string name;
	list<TreeNode*> leaves;
public:
	DistTreeList();
	void add(DistTree *tree);
	void clear() {treeList.clear(); name="";}
	void setData(list<DistTree*>* _treeList);
	string getName() {return name;}
	DistTree*& getTree1() {return treeList.front();}
	list<DistTree*>* getTreeList() {return &treeList;}
	int getTreeNum() { return treeList.size(); }
	vector<PairDist*>* convDistMat();
	list<TreeNode *>& getAllLeaves();
	list<DistTree*>::iterator begin() {return treeList.begin();}
	list<DistTree*>::iterator end() {return treeList.end();}
	void clearTree();
};

struct HomClusterData {
	string name;
	double score, dist;
};

class ReadTree {
	ifstream ifs;
	istream* is;
public:
	ReadTree();
	~ReadTree();
	int openFile(const char *filename);
	void rewind() { ifs.seekg(0); }
	DistTree* readTree(list<DistTree*>* treeList, bool addFlag = false);
	void readOptions(Options *opt);
	struct HomClusterData homclData;
};

class Edge {
	int id;
	static int edgenum;
public:
	Edge();
	void print();
	friend ostream& operator<<(ostream&, const Edge&);
};

#endif
