#!/usr/bin/perl -s
use strict;
use IO::Dir;
use IO::File;
use MBGD::DB;

###############################################################################
#
sub load_motif {
    my($dbname) = shift;
    my($file) = shift;

    my($db) = MBGD::DB->new($dbname);
    my($sql) = qq{load data local infile '$file' }
             .  q{replace }
             .  q{into table motif }
             .  q{fields terminated by '\t' }
             .  q{(motlib, motid, motname, program, length, descr)};
    $db->execute($sql);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }

    load_motif($dbname, @ARGV);
}

###############################################################################
1;#
###############################################################################
