#!/usr/bin/perl -s

use File::Copy;
use File::Basename;
use File::Path;
use POSIX;

$UserName = getpwuid($<);
$HOME=($ENV{HOME} ? $ENV{HOME} : "/home/$UserName");
$MBGDHOME = ($ENV{MBGD_HOME} ? $ENV{MBGD_HOME} : "/db5/project/MBGD");
$EXECDIR="/scratch/$UserName/mdptmp.$$" if (! $EXECDIR);
$MDPPATH="$MBGDHOME/package/pdp/src/";
$PAMFILE="$MBGDHOME/etc/allpamout.jtt";
#$MPICMD="/appl/mpich/bin/mpirun";
$MPICMD="/usr/bin/mpirun";
$QSUB_CMD = "/usr/pbs/bin/qsub";
$QSTAT_CMD = "/usr/pbs/bin/qstat";
$DPOPT="-L -l -P0 -G -s";
$TMPCMD="execmdp_tmpcmd";
$JOBID_FILE="jobid.$$";
##$CURRDIR=`pwd`; chomp $CURRDIR;
$CURRDIR=$ENV{PWD};
$NCPUS=8 if (! $NCPUS);
$NNODES=POSIX::ceil($NCPUS/2) if (! $NNODES && $NCPUS);

$QUEUE = 'large_mpi';
$NODEGRP = 'largempi';
#if ($NCPUS > 8) {
#	$QUEUE = 'large_mpi';
#	$NODEGRP = 'largempi';
#} else {
#	$QUEUE = 'mpi';
#	$NODEGRP = 'mpi';
#}
$RESOURCE_LIST = "nodes=$NNODES:$NODEGRP,ncpus=$NCPUS";

#$INPUTLIST="newprotseq.list";
#$SEQFILE="alldb";

if (@ARGV < 2) {
	die "Usage: $0 inputlist seqfile\n";
}
$INPUTLIST=$ARGV[0];
$SEQFILE=$ARGV[1];
$OUTPUTFILE=$ARGV[2];
if (! $OUTPUTFILE) {
	$OUTPUTFILE="mdpall.out";
}

$INPUTLIST_BASE = basename($INPUTLIST);
$SEQFILE_BASE = basename($SEQFILE);
$OUTPUTFILE_BASE = basename($OUTPUTFILE);

system("mkdir -p $EXECDIR");
if ($CopyAll) {
	copy($INPUTLIST, "$EXECDIR/$INPUTLIST_BASE") || die("ERROR :: can not copy '$INPUTLIST' to '$EXECDIR/$INPUTLIST_BASE'");
	copy($SEQFILE, "$EXECDIR/$SEQFILE_BASE") || die("ERROR :: Can not copy '$SEQFILE' to '$EXECDIR/$SEQFILE_BASE'");
} else {
	if ($INPUTLIST =~ /^\//) {
		symlink($INPUTLIST, "$EXECDIR/$INPUTLIST_BASE") || die;
	} else {
		symlink("$CURRDIR/$INPUTLIST", "$EXECDIR/$INPUTLIST_BASE") || die;
	}
	if ($SEQFILE =~ /^\//) {
		symlink($SEQFILE, "$EXECDIR/$SEQFILE_BASE") || die;
	} else {
		symlink("$CURRDIR/$SEQFILE", "$EXECDIR/$SEQFILE_BASE") || die;
	}
}
$INPUTLIST = $INPUTLIST_BASE;
$SEQFILE = $SEQFILE_BASE;

chdir $EXECDIR;
print STDERR "$EXECDIR\n";

symlink($PAMFILE, "$EXECDIR/allpamout");
##symlink("$MDPPATH/mdp", "$EXECDIR/mdp");

open(O, ">$TMPCMD");
print STDERR "$MPICMD -np $NCPUS -machinefile \$PBS_NODEFILE $MDPPATH/mdp -N $INPUTLIST $SEQFILE $DPOPT > $OUTPUTFILE_BASE\n";

print O <<EOF;
#PBS -l $RESOURCE_LIST
#PBS -q $QUEUE

cd $EXECDIR
$MPICMD -np $NCPUS -machinefile \$PBS_NODEFILE $MDPPATH/mdp -N $INPUTLIST $SEQFILE $DPOPT > $OUTPUTFILE_BASE

EOF
chmod 0755, $TMPCMD;
system("$QSUB_CMD $TMPCMD > $JOBID_FILE");
sleep(1);
open(J, $JOBID_FILE) || die;
$jobid = <J>;
close(J);
($jobid) = ($jobid =~ /(\d+)/);
print STDERR "JobID=$jobid\n";

while (1) {
	system("$QSTAT_CMD $jobid >/dev/null 2>&1");
	if($?) {
		last;
		
	}
	sleep 1;
}

if (-f $OUTPUTFILE_BASE) {
	if ($OUTPUTFILE =~ /^\//) {
		# absolute path
		copy($OUTPUTFILE_BASE, "$OUTPUTFILE");
	} else {
		# relative path
		copy($OUTPUTFILE_BASE, "$CURRDIR/$OUTPUTFILE");
	}
}
if (! $retainTmp) {
	chdir "/";
	sleep(1);
	rmtree($EXECDIR);
#	system("/bin/rm -rf $EXECDIR");
}
