#!/usr/local/bin/perl -s

package CLUSTTREE;

###############################################################################
#
sub new
{
    my($type) = shift;
    return bless {}, $type;
}

###############################################################################
#
sub readClustTree
{
    my($self) = shift();
    my($filename, @clustids) = @_;
    my($clust);
    my($orf);
    my(%clustids);
    my($flag) = 1;
    local(*FH);
print STDERR join(' ', @clustids), "\n";

    $self->{'TREEINFO'} = {};
    foreach my $cl (@clustids) {
	$clustids{$cl} = 1;
    }

    open(FH, "$filename") || die "Can not open $filename($!)";
    while(<FH>) {
        next if (/^#/);

        if (/^Cluster\s*(\S+)/) {
            $clust = [];
	    if (! @clustids || $clustids{$1}) {
	    	$flag = 1;
	    } else {
	    	$flag = 0;
	    }
        }
        elsif (/^$/) {
        }
        elsif ($flag) {
            push(@{$clust}, $_);
            if (/\+\-\s+(\S+)$/) {
                $orf = $1;
                $orf =~ tr/a-z/A-Z/;
                $self->{'TREEINFO'}->{$orf} = $clust;
            }
        }
    }
    close(FH);

    return;
}

###############################################################################
#
sub getTree
{
    my($self) = shift();
    my($orf) = @_;

    $orf =~ tr/a-z/A-Z/;
    return(@{$self->{'TREEINFO'}->{$orf}});
}

###############################################################################
package main;
if ($0 eq __FILE__) {
    $obj = new CLUSTTREE;
    $obj->readClustTree($ARGV[0]);

    print "Start\n";
    while(<STDIN>) {
        if (/^$/) {
            last;
        }
        chomp();
        print $obj->getTree($_);
    }
}



###############################################################################
1;#
###############################################################################
