#!/usr/bin/perl

package DBXref::NCBI_Gene;
use MBGD;
sub gene2acc {
	my($geneid) = @_;

	my($tabname) = 'ncbi_gene.gene2acc';

	my $db = MBGD::DB->new;
	my $sta = $db->exist_table($tabname);
	if (!$sta) {
		return;
	}
	my $sth = $db->execute(
	    "select prot_acc from $tabname where geneid='$geneid'");
	my(@prot_acc);
	while (my @a = $sth->fetchrow_array) {
		my($acc) = @a;
		push(@prot_acc, $acc);
	}
	@prot_acc;
}
package DBXref::UniProt;
sub embl2uniprot {
	my($embl_protid) = @_;

	my($tabname) = 'uniprot.xref_embl';

	my $db = MBGD::DB->new;
	my $sta = $db->exist_table($tabname);
	if (!$sta) {
		return;
	}
#	$embl_protid =~ s/\.\d+$//;	#remove version no.
	my $sth = $db->execute(
	    "select uni_acc from $tabname where embl_protid='$embl_protid'");
	my(@prot_acc);
	while (my @a = $sth->fetchrow_array) {
		my($acc) = @a;
		push(@prot_acc, $acc);
	}
	@prot_acc;
}
1;
