#!/usr/local/bin/perl

#$t = new FlatTab;
#$w = new FlatTab;
#
#$t->setFields("from,to,name");
#$w->setFields("name,to,from");
#$w->writeHeader;
#while ($t->readData) {
#	($from, $to, $name) = $t->getData('from','to','name');
#	$w->setData("from=$from", "to=$to", "name=$name");
#	$w->writeData;
#}

package FlatTab;
use FileHandle;

$Options = {
	outsep => "separator for output",
	sep => "separator for input",
	infile => "file for output",
	outfile => "file for output",
};
sub new {
	my($class, $options) = @_;
	my($this) = {};
	bless $this, $class;

	$this->{outsep} = "\t";
	$this->{sep} = "\t";
	foreach $op (keys %{$options}) {
		if ($Options->{$op}) {
			$this->{$op} = $options->{$op};
		}
	}

	if ($this->{outfile}) {
		$this->{outfile} = ">$this->{outfile}";
	} else {
		$this->{outfile} = ">&STDOUT";
	}
	if (! $this->{infile}) {
		$this->{infile} = ["<&STDIN"];
	} elsif (! ref($this->{infile})) {
		$this->{infile} = [$this->{infile}];
	}
	$this->{fileno} = 0;

	$this;
}

sub openNext {
	my($this) = @_;
	my($fh);

	return 0 if ($this->{fileno} >= @{$this->{infile}});

	while ( ! ($fh = FileHandle->new(
		$this->{infile}->[$this->{fileno}])) ) {
		print STDERR "$this->{infile}->[$this->{fileno}] open error\n";
		return 0 if (++$this->{fileno} >= @{$this->{infile}});
	}
	$this->{fileno}++;
	$this->{newfile_flag} = 1;
	$this->{IN} = $fh;
}
sub close {
	my($this) = @_;
	$this->{IN}->close if ($this->{IN});
	$this->{OUT}->close if ($this->{OUT});
}
sub current_fname {
	my($this) = @_;
	return $this->{infile}->[$this->{fileno} - 1];
}
sub newfile {
	my($this) = @_;
	return $this->{newfile_flag};
}

sub readData {
	my($this, @fldname) = @_;
	if (! $this->{IN} || $this->{IN}->eof) {
		if (! $this->openNext) {
			return 0;
		}
	} else {
		$this->{newfile_flag} = 0;
	}
	my($flag);
	my($F) = $this->{IN};
	if ($F) {
		while (<$F>) {
			last if ($flag = $this->readLine($_));
		}
	} else {
		while (<>) {
			last if ($flag = $this->readLine($_));
		}
	}
	return $flag;
}
sub readLine {
	my($this, $line) = @_;
	my(@Fields);
	chop $line;
	if ($line =~ /^##/) {
	    ## Header
		if ($line =~ /^## Sep *=(.*)/) {
			$this->{sep} = $1;
		} elsif ($line =~ /^## Fields *= *(\S.*)/) {
			$this->setFields($1);
		}
		return 0;
	} elsif ($line =~ /^#/) {
	    ## Comment
		return 0;
	} else {
		if ($this->{sep}) {
			@Data = split($this->{sep}, $line);
		} else {
			@Data = split(/\s+/, $line);
		}
		$this->{Data} = \@Data;
	}
	return 1;
}
sub getData {
	my($this, @fldname) = @_;
	my(@ret);
	if (! @fldname) {
		return @{$this->{Data}};
	}
	foreach $n (@fldname) {
		push(@ret, $this->{Data}->[$this->{fldidx}->{$n}]);
	}
	@ret;
}
sub getHash {
	my($this) = @_;
	my(%ret);
	foreach $n (@{$this->{fields}}) {
		$ret{$n} =  $this->{Data}->[$this->{fldidx}->{$n}];
	}
	return \%ret;
}
sub setFields {
	my($this, $line) = @_;
	my(@fields) = split(/,/, $line);
	my($i) = 0;
	my($f);
	$this->{fields} = \@fields;
	foreach $f (@fields) {
		$this->{fldidx}->{$f} = $i++;
	}
}
sub setData {
	my($this, $values) = @_;
	my($val, $name, $value, $idx);
	foreach $name (keys %{$values}) {
		$value = $values->{$name};
		if (defined $this->{fldidx}->{$name}) {
			$this->{Data}->[$this->{fldidx}->{$name}] = $value;
		}
	}
}
sub writeData {
	my($this) = @_;
	if (! $this->{flag}) {
		$this->writeHeader;
		$this->{flag} = 1;
	}
	$this->writeLine;
}
sub writeHeader {
	my($this) = @_;
	my($fields);
	my $ofh = $this->{OUT} = FileHandle->new($this->{outfile});
	if ($this->{fields}) {
		foreach $f (@{$this->{fields}}) {
			$fields .= "," if ($fields);
			$fields .= $f;
		}
	}
	print $ofh "## Sep=$this->{outsep}\n" if ($this->{sep});
	print $ofh "## Fields=$fields\n" if ($fields);
}
sub writeLine {
	my($this) = @_;
	my $ofh = $this->{OUT};
	print $ofh join($this->{outsep}, @{$this->{Data}}), "\n";
}

1;
