#!/usr/bin/perl

###############################################################################
#
require 'libMBGDclusttab.pl';
package MBGD::ClustTab::ClustMap;

use MBGD::ClustTab;
use MBGD::ClustTab::DB;
use MBGD::FuncCat;
use Digest::MD5;
use ArgCheck;

sub new {
	my($class, $CountPat, $CountClass, $CountTotClass, $totcnt, $splist, $tabid) = @_;
	my($this) = {};
	$this->{CountPat} = $CountPat;
	$this->{CountClass} = $CountClass;
	$this->{CountTotClass} = $CountTotClass;
	$this->{totcnt} = $totcnt;
	$this->{species} = $splist;
	$this->{tabid} = $tabid;
	bless $this, $class;
}

#sub create_summary {
#	my($this) = @_;
#	$tabid = $this->{tabid}; $tabid =~ s/RDB://;
#
#
#	($CountPat, $CountClass, $CountTotClass, $totcnt)
#		= &main::summaryMap($tabid,$Q::summaryOutput, $selopt);
#
#	$this->{CountPat} = $CountPat;
#	$this->{CountClass} = $CountClass;
#	$this->{CountTotClass} = $CountTotClass;
#	$this->{totcnt} = $totcnt;
#}

$ArgList = [
	qstring, annotsp
];
sub displayName_InJavaScript {
	my($species) = @_;
	my @genomes = MBGD::Genome->get($species);
	my(%OrgName);

	foreach $g (@genomes) {
		$OrgName{$g->{sp}} = "$g->{orgname} $g->{strain} [$g->{sp}]";
	}
	my($idx) = 0;
	foreach $sp (@{$species}) {
		$SET_ARRAY .= qq{\tOrgName[ $idx ] = "$OrgName{$sp}";\n};
		$idx++;
	}

	print <<EOF;
<script language="javascript">
<!--
function displayName(idx) {
	var OrgName = new Array($numspec);
$SET_ARRAY
//	document.clustmapForm.orgNameWin.value= OrgName[idx];
	window.status = OrgName[idx];
//    self.style.color='red';
}
function clearName(idx) {
    window.status = '';
}
//-->
</script>
EOF
}
$DEFAULT_ORGNAME = "Mouse over the abbrev. name to show the full name";

sub show_summary {
	my($this, %origOpt) = @_; 
	my($i,$j);
	my($fndpat);
	my(%FndCnt);
	my($othernum, $totcnt, $outputNum);
	my(%ColorCnt);
#	my($annotspcol);
	my($table_color) = 'category';
	$ClusterFormCreated = 1;

	my(@species) = split(/,/,$this->{species});
    my(@species_orig) = @species;
    if ($origOpt{'tabid'} eq 'addspec') {
        @species = split(/,/, $origOpt{'species'});
    }

    # sp $B$H(B fndpat $B$NBP1~(B
    my(%fndpat_index);
    my($idx) = 0;
    foreach my$sp (@species_orig) {
        $fndpat_index{"$sp"} = $idx;
        $idx++;
    }

	my($MapWidth) = 400;

	my $argCheck = ArgCheck->new('',{DEBUG=>0});
	$argCheck->add($ArgList);
	my %opt = %{ $argCheck->check(\%origOpt) };
	my $numspec = @species;

##	$this->{tabid} = 'default';

##	if ($opt{annotsp}) {
##		my($i);
##		foreach $sp (@species) {
##			if ($sp eq $opt{annotsp}) {
##				$annotspcol = $i; last;
##			} 
##			$i++;
##		}
##	}
#
##	print "<H3> Gene Cluster Map </H3>\n";
#	if ($table_color) {
#		print "Each cluster was assigned colors according to ";
#		if ($table_color eq 'category') {
#			print "\n";
#			print "<A HREF=\"/htbin/show_functab?species=$species\">the function categories</A>.\n";
#		}
#		print " Click on the color bars to see detailed cluster table.\n";
#		print "Alternatively, click the abbreviated name to choose the reference organism.\n";
#	}
#
#	print "<FORM NAME=\"clustmapForm\" METHOD=\"post\" ACTION=\"/htbin/cluster\">\n";
#
#	&create_MapOptionForm();

###	$selopt = &set_SelectClusterTableOptions({'no_limit' => 1});

	%PatCnt = %{$this->{CountPat}};
	%ClustColorNum = %{$this->{CountClass}};
	%ColorCnt = %{$this->{CountTotClass}};
	$totcnt = $this->{totcnt};
	$outputNum = $this->{create_opt}->{summaryOutput};

	&displayName_InJavaScript(\@species);

    #
	print "Number of output patterns\n";
	print "<INPUT NAME=\"summaryOutput\" VALUE=\"$outputNum\" SIZE=\"3\">\n";

    #
    print "Color clusters by \n";
    my($funccat) = $origOpt{'funccat'};
    my(%staClstColMbgd) = ('mbgd' => 'selected');
    my(%staClstColCog)  = ('cog'  => 'selected');
    my(%staClstColKegg) = ('kegg' => 'selected');
    my(%staClstColTigr) = ('tigr' => 'selected');
    print "<select name=\"cluster_color\">\n";
    print "<option value=\"mbgd\" $staClstColMbgd{$funccat}>MBGD\n";
    print "<option value=\"cog\"  $staClstColCog{$funccat}>COG\n";
    print "<option value=\"kegg\" $staClstColKegg{$funccat}>KEGG\n";
    print "<option value=\"tigr\" $staClstColTigr{$funccat}>TIGR\n";
    print "</select>\n";

    #
	print "<INPUT TYPE=\"button\" NAME=\"show_summary2\" VALUE=\"Redraw the map\" onClick=\"show_summary.click()\">\n";

	print "<hr>\n";


	print "<TABLE CELLSPACING=\"0\">\n";
	print "<TR>\n";
	print "<TD COLSPAN=\"$numspec\" ALIGN=\"center\"><b>occurrence patterns</b></TD>\n";
	print "<TD ROWSPAN=\"2\">#clusters</TD>\n";
	print "</TR>\n";
	print "<TR>\n";

    #
	$rawinput0 = $opt{qstring};
	$rawinput0 .= '&show_summary=on' if ($rawinput0 !~ /show_summary/);

    # species=XXX; $B$,7+$jJV$7=PNO$5$l$k$3$H$,$"$k!#!J(BIE $B$G=hM}$G$-$J$$>l9g$"$j!K(B
    # species=XXX,XXX $B$N7A<0$KJQ49$7(B QUERY_STRING $B$rC;$/$9$k!#(B
    @rawinputSp;
    $rawinputNew = '';
    foreach my$wd (split(/;/, $rawinput0)) {
        if ($wd =~ /^species=(.+)/) {
            push(@rawinputSp, $1);
        }
        else {
            $rawinputNew .= ';' if ($rawinputNew ne '');
            $rawinputNew .= $wd;
        }
    }
    $rawinputNew .= ";species=" . join(',', @rawinputSp);
    $rawinput0 = $rawinputNew;

	my $idx = 0;
	foreach $sp (@species) {
		$rawinput0 =~ s/category_col=[^\&;]*/category_col=$category_col/;
		if ($rawinput0 =~ /annotsp/) {
			$rawinput0 =~ s/annotsp=[^\&;]*/annotsp=$sp/;
		}
		else {
			$rawinput0 .= "&annotsp=$sp";
		}
		if ($rawinput0 =~ /class/) {
			$rawinput0 =~ s/class=[^\&;]*/class=$sp/;
		}
		else {
			$rawinput0 .= "&class=$sp";
		}
		if ($rawinput0 =~ /description/) {
			$rawinput0 =~ s/description=[^\&;]*/description=$sp/;
		}
		else {
			$rawinput0 .= "&description=$sp";
		}
		print "<TD ALIGN=\"center\">";
		print "<A HREF=\"/htbin/cluster?$rawinput0\" " .
			"onMouseOver=\"displayName($idx);return true\" " .
			"onMouseOut='clearName($idx);' >";
		$sp0 = $sp; substr($sp0,0,1) =~ tr/a-z/A-Z/;
		$sp0 = "<pre>".join("\n",split(//, $sp0))."\n</pre>";

		if ($sp eq $opt{annotsp}) {
			print "<FONT color=\"#ff0000\" size=-1>$sp0</FONT>";
		} else {
			print "<FONT color=\"#008000\" size=-1>$sp0</FONT>";
		}
		print "</A></TD>\n";
		$idx++;
	}
	print "<TD></TD>\n";
	print "</TR>\n";


	$rowcnt = 0;
	@SortCnt = sort {$PatCnt{$b} <=> $PatCnt{$a}} (keys %PatCnt);
	$scale = 0;
	if ($PatCnt{$SortCnt[0]}) {
		$scale = sprintf("%.5f", $MapWidth/$PatCnt{$SortCnt[0]});
	}

    #
#    my($objFuncCat);
#    if ($table_color eq 'category') {
        $objFuncCat = new MBGD::FunctionCategory($origOpt{'funccat'});
#    }

	my($OtherCol, $othernum, $OtherPat);
	foreach $fndpat (@SortCnt) {
#		if (++$rowcnt > $this->{create_opt}->{summaryOutput}) {
		if (++$rowcnt > $outputNum) {
			foreach $col (sort {$a <=> $b} keys %{$ClustColorNum{$fndpat}}) {
				$OtherCol{$col} += $ClustColorNum{$fndpat}->{$col};
				$othernum+= $ClustColorNum{$fndpat}->{$col};
			}
			$OtherPat .= "," if ($OtherPat);
			$OtherPat .= $fndpat;
			next;
		}
		print "<TR>\n";

        #
#		$fndpat0 = $fndpat;
		$fndpat0 = '';
        foreach my$sp (@species) {
            my($i) = $fndpat_index{"$sp"};

			$p = substr($fndpat, $i, 1);
			if ($p eq 'o' || $p == 1) {
				print "<TD bgcolor=\"#00a000\" width=\"25\" align=\"center\">".
			"<FONT color=\"#ffffff\" size=\"-1\">" .
#			"$FndCnt{$fndpat,$species[$i]}" .
			"*" .
			"</FONT>" .	## "</A>".
			"</TD>\n";
			} else {
				print "<TD width=\"25\" align=\"center\"></TD>\n";
			}
            $fndpat0 .= $p;
		}
		print "<TD align=\"right\">$PatCnt{$fndpat}</TD>\n";
		my($colsiz) = 50;
		$xlen = int($PatCnt{$fndpat} * $scale), $ylen = 15;
		$xlen = 1 if ($xlen < 1);
		
		$coloropt = '';

		foreach $col (sort {$a <=> $b} keys %{$ClustColorNum{$fndpat}}) {
			$num = $ClustColorNum{$fndpat}->{$col};
			if ($table_color eq 'category') { # function category
#				$color = &MBGD::FuncCat::get_func_color_from_id($col);
                $color = $objFuncCat->getFunctionColorByLevel($col);
#			} elsif ($table_color eq 'motif') { # PROSITE category
#				$color = &get_prosite_color($col);
			} else {
				$color = 'ffffff';
			}
			$color =~ s/^#//;
			$coloropt .= "\&" if ($coloropt);
			$coloropt .= "colors=$color,$num";
		}
		print "<TD><INPUT TYPE=\"image\" SRC=\"/htbin/create_nullgif?xlen=$xlen&ylen=$ylen&$coloropt&scale=$scale\" width=\"$xlen\" height=\"$ylen\" NAME=\"pat_$fndpat0\" BORDER=\"0\"></TD>\n";

		print "</TR>\n";
	}
	
#	if ($rowcnt > $summaryOutput) {
#		print "<TR><TD align=\"center\" colspan=", 0+@species,
#			">Others</TD><TD align=\"right\">$othernum</TD>";
#	}

### TOTAL
	$coloropt = '';
	print "<TR><TD align=\"center\" colspan=", 0+@species,
		"><b>Total</b></TD><TD align=\"right\">$totcnt</TD>";
	foreach $col (sort {$a <=> $b} keys %ColorCnt) {
		if ($table_color eq 'category') {
#			$color = &MBGD::FuncCat::get_func_color_from_id($col);
            $color = $objFuncCat->getFunctionColorByLevel($col);
#		} elsif ($table_color eq 'motif') {
#			$color = &get_prosite_color($col);
		}
		$color =~ s/^#//;
		$coloropt .= "\&" if ($coloropt);
		$coloropt .= "colors=$color,$ColorCnt{$col}";
	}
	$totscale = 0;
	$totscale = sprintf("%.5f", $MapWidth / $totcnt) if ($totcnt);

	print "<TD><INPUT TYPE=\"image\" SRC=\"/htbin/create_nullgif?xlen=$MapWidth&ylen=$ylen&$coloropt&scale=$totscale\" width=\"$MapWidth\" height=\"$ylen\" NAME=\"pat_total\" BORDER=\"0\"></TD>\n";

	print "</TABLE>\n";
	print "</TD></TR></TABLE>\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"scale\"	VALUE=\"$scale\">\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"totscale\" VALUE=\"$totscale\">\n";

#	if ($COMPCMD) {
#		print "<INPUT TYPE=\"hidden\" NAME=\"COMPCMD\" VALUE=\"$COMPCMD\">";
#	}
}

sub show_genomemap {
	my($this,$RDB_tableid,$showchrom,$species,$opt) = @_;
	my(@species) = split(/,/, $species);

#	print "<H3> Genome Map </H3>\n";
#	print "<FORM NAME=\"clustmapForm\" METHOD=\"post\" ACTION=\"/htbin/cluster\">";
#	&create_MapOptionForm();

	print "<TABLE BORDER=\"1\" CELLPADDING=\"2\"><TR><TD bgcolor=\"#eeffee\">";
	my $maxcount, $Count;
	my %totcount;
	my $GenomeMapWidth=800;
	$Count = &MBGD::ClustTab::DB::countClustersBySP($RDB_tableid);

	my($selsp, $selseqno) = split(/:/, $showchrom);
	$selseqno = 1 if (! $selseqno);
	my $selchrname = "${selsp}_${selseqno}";
	$totcount{$selsp} += $Count->{$selsp};
	$maxcount = $totcount{$selsp} if ($maxcount < $totcount{$selsp});

	my $xlen, $ylen;
	my $color = 'ffffbb';
	my $scale = $GenomeMapWidth/$maxcount;

	print "<TR><TD><TD>\n";
	print "<SELECT NAME=\"showchrom\">";
	my $sel;
	foreach $sp (@species) {
		my $g = MBGD::Genome->get($sp);
		my @chrom = MBGD::Chromosome->find("sp='$sp'",
				{order=>"seqno"});
		foreach $ch (@chrom) {
			$sel = (($sp eq "$selsp") && ($ch->{seqno}==$selseqno))
				?  "SELECTED" : "";
		   
			$chrname = "$sp:$ch->{seqno}";
			print "<OPTION VALUE=\"$chrname\" $sel> ",
				"$g->{orgname} $g->{strain} [$g->{sp}] ",
				"$ch->{type} $ch->{name}\n";
		}
	}
	print "</SELECT>\n";
	print "<INPUT TYPE=\"button\" NAME=\"show_summary2\" VALUE=\"Redraw the map\" onClick=\"show_summary.click()\">";

	print "<TR><TD>$selsp</TD><TD>\n";
	my $coloropt;
	my $count = $Count->{$selsp};
	$coloropt .= "&" if ($coloropt);
	$coloropt .= "colors=$color,$count";
	$xlen = int($totcount{$selsp} * $scale); $ylen = 15;
##	print "<INPUT TYPE=\"image\" SRC=\"/htbin/create_genomegif?xlen=$xlen&ylen=$ylen&spec=$sp&clusttab=$RDB_tableid&seqno=1&scale=$scale\" width=\"$xlen\" height=\"$ylen\" NAME=\"genome_$sp\" BORDER=\"0\">\n";
#		print "<INPUT TYPE=\"image\" SRC=\"/htbin/create_nullgif?xlen=$xlen&ylen=$ylen&$coloropt&scale=$scale\" width=\"$xlen\" height=\"$ylen\" NAME=\"genome_$sp\" BORDER=\"0\">\n";

	my $SRCHOPT;
	$SRCHOPT = "&phylopat=$opt->{phylopat}" if ($opt->{phylopat});
	$SRCHOPT .= "&mismatch=$opt->{mismatch}" if ($opt->{mismatch});
	$SRCHOPT .= "&color=ff0000";

	print "<INPUT TYPE=\"image\" SRC=\"/htbin/MBGD_whole_image.pl?",
		"spec=$selsp&seqtype=chromosome&seqno=$selseqno&",
		"clusttab=$RDB_tableid$SRCHOPT\" NAME=\"genome_$selchrname\">\n";
	print "</TD>\n";
	print "</TR>\n";

	print "</TABLE>\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"scale\"	VALUE=\"$scale\">\n";

}
sub show_histogram {
	print "<FORM NAME=\"clustmapForm\" METHOD=\"post\" ACTION=\"/htbin/cluster\">";
	&create_MapOptionForm();
	print "<TABLE BORDER=\"1\" CELLPADDING=\"2\"><TR><TD bgcolor=\"#eeffee\">";
	my(%clsizCount, $maxcount);
#	my ($clustRes, $GeneInfo, $totalcount, $clres_start)
	my ($clustRes) = &readClusterTable($CLUST, {'no_limit'=>1});
	foreach $_ (@{$clustRes}) {
	chomp;
	my ($clid, $clsiz, @data) = split(/\t/);
	if ($clsiz >= 10) {
		$clsiz = 10 + int ($clsiz / 10);
	}
	$clsizCount{$clsiz}++;
	$maxcount++;
	}
	my $scale = $MapWidth/$maxcount;
	my $coloropt;
	my $xlen, $ylen;
	my ($i, $j) = (80, 100);
	foreach my $sz (sort {$a<=>$b} keys %clsizCount) {
	print "<TR><TD>$sz</TD><TD>\n";
	my $color = 'ffffff';
		$xlen = int($clsizCount{$sz} * $scale); $ylen = 15;
	$xlen = 1 if (! $xlen);
	$coloropt = "colors=$color,$clsizCount{$sz}";
		print "<INPUT TYPE=\"image\" SRC=\"/htbin/create_nullgif?xlen=$xlen&ylen=$ylen&$coloropt&scale=$scale\" width=\"$xlen\" height=\"$ylen\" NAME=\"hist\" BORDER=\"0\">\n";
		print "</TD></TR>\n";
	}
	print "</TABLE>\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"scale\"	VALUE=\"$scale\">\n";
}

sub pair_mat {
	my($this, $RDB_tableid, $origClustTab, $opt) = @_;

	my(@Val);
	my($refPairwiseSpec);
	my(@listPairwiseSpec) = split(',', $opt->{'pairwise_spec'});
#	my(@species) = @{ $clustTab->splist };
#	my(@species) = split(/,/, $opt->{species});
	my(@species) = split(/,/, $opt->{pairwise_spec});
	if (scalar(@listPairwiseSpec) != 0) {
		$refPairwiseSpec = {};
		foreach my $sp (@listPairwiseSpec) {
			$refPairwiseSpec->{"$sp"} = 1;
		}
	}
	$opt->{'type'} = 'co_occur' if (! $opt->{'type'});

## temporarily turn off the cache
$opt->{no_cache}=1;

	if (! $opt->{no_cache} &&
		($val = &pairmat_read_cache($RDB_tableid, $opt->{'type'},
				$opt->{'pairwise_spec'} )) ) {
		@Val = @{ $val };
	} else {
		my($clustTab) = MBGD::FilteredClustTab->new(
			$origClustTab,
			splist=>\@listPairwiseSpec);

		if ($opt->{'type'} =~ /^(identity|pam)$/) {
			@Val = &calc_ident($clustTab, $opt);
		} else {
			@Val = &calc_co_occur($clustTab);
		}
		if (! $opt->{no_cache}) {
		    &pairmat_write_cache($RDB_tableid, $opt->{'type'},
				$opt->{'pairwise_spec'}, \@Val);
		}
	}

    print <<EOB;
<script>
function openDotPlotWin(sp1, sp2, tabid) {
    var url = '/htbin/CGAT/dotplot.cgi' + '?'
            + 'sp1=' + sp1 + '&'
            + 'sp2=' + sp2 + '&'
            + 'tabid=' + tabid;
    var name = 'dotplot_';// + sp1 + '_' + sp2;
    var opt = 'width=200,height=100,resizable=yes';
    open(url, name, opt);
}
</script>
EOB

	&displayName_InJavaScript(\@species);

	print "<TABLE BORDER=1 CELLPADDING=2>\n";
	print "<TR><TD></TD>";
	for (my $i = 0; $i < @species; $i++) {
	        if ($refPairwiseSpec && ! $refPairwiseSpec->{"$species[$i]"}) {
       	     		next;
        	}
#		$sp = $species[$i];
#		print "<TH><A HREF=\"/htbin/MBGD_whole_html.pl?spec=$sp\" " .
#			"onMouseOver=\"displayName($i);return true\" >" .
#			"$sp</TH>";
		print "<TH> $species[$i]</TH>";
	}
	print "</TR>";
	for (my $i = 0; $i < @species; $i++) {
	        my($sp1) = $species[$i];
       		if ($refPairwiseSpec && ! $refPairwiseSpec->{"$species[$i]"}) {
           		next;
        	}

		print "<TR>";
		print "<TH><A HREF=\"/htbin/MBGD_whole_html.pl?spec=$species[$i]\" " .
			"onMouseOver=\"displayName($i);return true\" >" .
			"$species[$i]</TH>";

		for (my $j = 0; $j < @species; $j++) {

            		my($sp2) = $species[$j];
            		if ($refPairwiseSpec && ! $refPairwiseSpec->{"$species[$j]"}) {
                		next;
            		}

			if ($i==$j) {
			$value = "<A href='/' onclick=\"openDotPlotWin('$sp1', '$sp2', '$RDB_tableid'); return false;\">*</A>";
				print "<TD>$value</TD>\n"; next;
			}
#			my $value = $TotCount[$i] ? int(100 * $Co_occur[$i]->[$j] / $TotCount[$i]) : 0;
			$value = $Val[$i]->[$j];
			if ($opt->{'type'} eq 'identity' && $i > $j) {
				($bgcol,$fgcol) = get_color_pam($value);
			} else {
				($bgcol,$fgcol) = get_color_percent($value);
			}
			$value = "<FONT color=$fgcol>$value</FONT>" if ($value);
			$value = "<A href='/' onclick=\"openDotPlotWin('$sp1', '$sp2', '$RDB_tableid'); return false;\">$value</A>";
			print "<TD bgcolor=$bgcol>$value</TD>\n";
		}
		print "</TR>";
	}
	print "</TABLE>\n";

	my(%CHECKED);
	$CHECKED{$opt->{type}} = "CHECKED";
	print "<b>Type:</b>\n";
	print "<INPUT type=radio name=pairmat_type value=co_occur onClick=\"document.clustmapForm.show_summary.click()\" $CHECKED{co_occur}> shared orthologs\n";
	print "<INPUT type=radio name=pairmat_type value=identity onClick=\"document.clustmapForm.show_summary.click()\" $CHECKED{identity}> identity\n";
	print "<br>\n";

	if ($opt->{type} eq 'co_occur') {
		print "The number indicates the percentage of the shared orthologs in the genome in each row.<br>\n";
	} else {
		print "The number shows the average percentage identity of orthologous (upper right) or paralogous (lower left) gene pairs.<br>\n";
#		print "The number shows the average percentage identity (upper right) or PAM (lower left) of orthologous gene pairs.<br>\n";
	}
}
sub pairmat_check_cache {
	my($tabid, $type, $spec) = @_;
	my($spsum) = Digest::MD5::md5_hex($spec);
	my($cache_file) = "$::DIR_tmp/pairmat_cache.$type.$tabid.$spsum";
	if (-f $cache_file && ! -z $cache_file) {
		return 1;
	} else {
		return 0;
	}
}
sub pairmat_read_cache {
	my($tabid, $type, $spec) = @_;
	my($spsum) = Digest::MD5::md5_hex($spec);
#print STDERR "SPR>$spec,$spsum\n";
	my($cache_file) = "$::DIR_tmp/pairmat_cache.$type.$tabid.$spsum";
	my(@RetVal);
	if (-f $cache_file && ! -z $cache_file) {
		open(F, $cache_file);
		while(<F>){
			($i,$j,$value) = split(/\t/);
			$RetVal[$i]->[$j] = $value;
		}
		close(F);
		return \@RetVal;
	}
}
sub pairmat_write_cache {
	my($tabid, $type, $spec, $Mat) = @_;
	my($spsum) = Digest::MD5::md5_hex($spec);
#print STDERR "SPW>$spec,$spsum\n";
	my($cache_file) = "$::DIR_tmp/pairmat_cache.$type.$tabid.$spsum";
	my($cache_file_tmp) = "${cache_file}.tmp";
	my($i, $j);
	if (! open(O, ">$cache_file_tmp")) {
		print STDERR "Can't open file for write: $cache_file\n";
		return;
	}
	$i = 0;
	foreach $r (@{$Mat}) {
		$j = 0;
		foreach $value (@{$r}) {
			print O join("\t", $i, $j, $value), "\n";
			$j++;
		}
		$i++;
	}
	rename($cache_file_tmp, $cache_file);
}
sub calc_co_occur {
	my($clustTab) = @_;
	my(@TotCount, @Co_occur, @RetValue);
	my(@species) = @{ $clustTab->splist };
	foreach my $cluster ($clustTab->list_clusters) {
		chomp;
		my($i) = 0;
		my(%Found);
		foreach $i (0..$#species) {
			my $d = $clustTab->get_spdata($cluster, $i);
			if (@{$d}) {
				$Found{$i} = 1;
				$TotCount[$i]++;
			}
			$i++;
		}
		foreach my $i (keys %Found) {
			foreach my $j (keys %Found) {
				$Co_occur[$i]->[$j]++;
			}
		}
	}
	for (my $i = 0; $i < @species; $i++) {
		for (my $j = 0; $j < @species; $j++) {
			$RetValue[$i]->[$j] = $TotCount[$i] ?
			    int(100 * $Co_occur[$i]->[$j] / $TotCount[$i])
			    : 0;
		}
	}
	@RetValue;
}
sub calc_ident {
	my($clustTab, $opt) = @_;
	my(@splist) = @{ $clustTab->splist };
	my($splist) = join(',', @splist);
	my(%ClustID, %CountPara, %SumPara, %CountOrtho, %SumOrtho);
	my($var) = $opt->{'type'};
	$var = 'identity' if (! $var);
	foreach my $cl ($clustTab->list_clusters) {
		next if (! $cl->{clustid});
		foreach my $g ($clustTab->allgenes($cl)) {
			$ClustID{$g}->{$cl->{clustid}} = 1;
		}
	}
	open(S, "$main::CMD_select -SPEC=$splist -FULLOUT |");
	while (<S>) {
		($n1,$n2,$from1,$to1,$from2,$to2,$ident,$eval,$pam,$score)=split;
		my $ortho = 0;
		foreach my $cid (keys %{ $ClustID{$n1} }) {
			if ($ClustID{$n2}->{$cid}) {
				$ortho = $cid;
				last;
			}
		}
		($sp1) = split(/:/,$n1);
		($sp2) = split(/:/,$n2);
		if ($var eq 'pam') {
			$val = $pam;
		} elsif ($var eq 'identity') {
			$val = $ident;
		}
		if ($ortho) {
			$SumOrtho{$sp1,$sp2} += $val;
#print STDERR "$n1,$n2,$ortho,$val\n" if ($sp1 eq 'ban' && $sp2 eq 'btk');
			$CountOrtho{$sp1,$sp2}++;
		} else {
			$SumPara{$sp1,$sp2} += $val;
			$CountPara{$sp1,$sp2}++;
		}
	}
	close(S);
#print STDERR "Lines>>$kkk\n";
	my $i = 0;
	my($spec1, $spec2);
	my(@RetVal);
	foreach my $sp1 (@splist) {
		my $j = 0;
		foreach my $sp2 (@splist) {
#			if (defined $CountIdent{$sp1,$sp2} ||
#					defined $CountPAM{$sp1,$sp2}) {
			if (defined $CountOrtho{$sp1,$sp2} ||
					defined $CountPara{$sp1,$sp2}) {
				$spec1 = $sp1; $spec2 = $sp2;
			} else {
				$spec1 = $sp2; $spec2 = $sp1;
			}
			if ($i < $j) {
#				## identity
#				if ($CountIdent{$spec1,$spec2} == 0) {
#					$RetVal[$i]->[$j] = '-';
#				} else {
#					$RetVal[$i]->[$j] = sprintf("%d",
#						$SumIdent{$spec1,$spec2}
#						/ $CountIdent{$spec1,$spec2});
#				}
				## orthologs
				$RetVal[$i]->[$j] =
					($CountOrtho{$spec1,$spec2} == 0) ?
					0 : sprintf("%d",
						$SumOrtho{$spec1,$spec2}
						/ $CountOrtho{$spec1,$spec2});
			} else {
#				## pam
#				if ($CountPAM{$spec1,$spec2} == 0) {
#					$RetVal[$i]->[$j] = '-';
#				} else {
#					$RetVal[$i]->[$j] = sprintf("%d", 
#						$SumPAM{$spec1,$spec2}
#						/ $CountPAM{$spec1,$spec2});
#				}
				## paralogs
				$RetVal[$i]->[$j] =
					($CountPara{$spec1,$spec2} == 0) ?
					0 : sprintf("%d", 
						$SumPara{$spec1,$spec2}
						/ $CountPara{$spec1,$spec2});
			}
			$j++;
		}
		$i++;
	}
	@RetVal;
}


sub get_color_percent {
	my($value) = @_;
	return ("#ffffdd") if ($value eq '-');
	return ("#ffffaa") if ($value <= 20);
	return ("#ffcc88") if ($value <= 40);
	return ("#ff88dd") if ($value <= 60);
	return ("#cc77dd") if ($value <= 80);
	return ("#bb00bb","#ffffff") if ($value < 100);
	return ("#880000","#ffffff") if ($value == 100);
}
sub get_color_pam {
	return ("#ffffdd") if ($value eq '-');
	return ("#ffffaa") if ($value >= 200);
	return ("#ffcc88") if ($value >= 120);
	return ("#ff88dd") if ($value >= 80);
	return ("#cc77dd") if ($value >= 40);
	return ("#bb00bb","#ffffff") if ($value > 0);
	return ("#880000","#ffffff") if ($value == 0);
}

###############################################################################
#sub create_MapOptionForm {
#	my($opt) = @_;
###	print "<INPUT TYPE=\"hidden\" NAME=\"connect\" VALUE=\"$Q::connect\">\n";
#	print "Number of outputs\n";
#	print "<INPUT NAME=\"summaryOutput\" VALUE=\"$Q::summaryOutput\" SIZE=\"3\">\n";
#	print "Map Type:\n";
#	print "<SELECT NAME=\"map_type\">\n";
#	my (%Selected);
#	$SEL{$Q::map_type} = 'SELECTED';
#	print "<OPTION VALUE=\"occpat\" $SEL{occpat}>Occurrence pattern\n";
#	if ($Q::annotsp) {
#   	 print "<OPTION VALUE=\"genomemap\" $SEL{genomemap}>Genome map\n";
#	}
#	print "<OPTION VALUE=\"pairwise\" $SEL{pairwise}>Pairwise comparison\n";
#	print "</SELECT>\n";
#	print "<INPUT TYPE=\"submit\" NAME=\"show_summary\" VALUE=\"Redraw the map\">\n";
#	print "\n";
#}
#
###############################################################################
##
#sub check {
#	($a, $b, $ret) = @_;
#	return $ret if ($a eq $b);
#	return '';
#}
#
###############################################################################
##
#sub keyword_search {
#	my($keyword, $field, $searchspec) = @_;
#	my($orfname, @genes);
#	my($cmd);
#	local(*SRCH);
#
#	if ($field eq 'GeneName') {
##		$keyword = "GENE=$keyword";
##		$OPT = '-DEFAULTOP="OR"';
#		$keyword = "\\[$keyword\\]";
#	}
#	elsif ($field eq 'ProductName') {
#		$keyword = "PRODUCT=$keyword";
#	}
#	elsif ($field eq 'Category') {
#		$keyword = "CATEGORY=$keyword";
#	}
#	elsif ($field eq 'Prosite') {
#		$keyword = "PROSITE=$keyword";
#	}
#	$searchspec = $species if (! $searchspec);
#
#	#
#	$keyword =~ s#(\d)#\\$1#g;
#	$cmd = "$Search -SPEC=$searchspec $OPT '$keyword'";
#	open(SRCH, "$cmd |") || die "Open error $Search";
#
#	while (<SRCH>) {
#		($orfname) = split(/\s/);
#		push(@genes, $orfname);	 ## @genes is a global variable !
#	}
#	close(SRCH);
#	return @genes;
#}
package main;
if ($0 eq __FILE__) {
        my $read_format = "ID,DUMMY,DATA,FuncCat,Gene";
        my $write_format = "Gene,DATA,FuncCat,GeneName,Motifs,Score";
        $file = $ARGV[0];
        $file = "/dbb/project/MBGD/work/default.clusterTab" if (! $file);
        die "Usage: $0 filename\n" if (! $file);
        $clust = MBGD::ClustTab->new(file=>$file,
                        format => $MBGD::ClustTab::Fields::DefaultReadFormat,
                        limit=>"1,25");

	$clustMap = MBGD::ClustTab::ClustMap->new($clust);

	$clustMap->create_summary();
	$clustMap->show_summary();

	if ($Q::map_type eq 'genomemap') {
		&show_genomemap();
	} elsif ($Q::map_type eq 'pairwise') {
		&pair_mat();
	} else {
	}
}

###############################################################################
1;#
###############################################################################
