#!/usr/local/bin/perl

package MBGD::ClustTree;
sub new {
	my($class, $tree) = @_;
	my($this) = {};
	bless $this, $class;
	$this->{treedata} = $tree;
	$this;
}
sub getorfs {
	my($this) = @_;
	my($orf);
	if (ref $this->{treedata}) {
		foreach $t (@{ $this->{treedata} }) {
			$orfs = &getOrfsFromTree($t);
		}
	} else {
		$orfs = &getOrfsFromTree($this->{treedata});
	}
	keys %{$orfs};
}
sub getOrfsFromTree {
	my($tree) = @_;
	my(%orf);
	foreach my $line (split(/\n/, $tree)) {
		if ($line =~ /[\+\*]\-\s*(\w+:[^\s\(\)]+)/) {
			$orf{$1} = 1;
		}
	}
	\%orf;
}
package MBGD::ClustTree::DB;
use MBGD;
sub getTree {
	my($tabid, $clustid, $dbname) = @_;
	$dbname = $main::MYSQL_DBTMP if (! $dbname);
	$clustid =~ s/[A-Z]//;
	my $db = MBGD::DB->new($dbname);
	my($sth) = $db->execute("select tree from clusttree_$tabid where clustid='$clustid'");
	my ($tree) = $sth->fetchrow_array;
	return $tree;
}
1;
