#!/usr/local/bin/perl

require "MBGD_Conf.pl";

package MBGD::FuncCat;
use MBGD;
$UNKNOWN = 100;

$DIR_funccat = "$main::DIR_database/class/";

###############################################################################
#
sub get_func_category_color {
	my($ent, $opt) = @_;
	if ($opt eq 'fromdb') {
		return &get_func_category_from_db($ent);
	} else {
		my($sp) = split(/:/,$ent);
		my($cl) = &get_func_category_from_file($ent);
		return &get_func_color_id($sp, $cl);
	}
}
sub get_func_category {
	&get_func_category_from_file;
}
sub get_func_category_from_db {
	my($ent) = @_;
	my($sp, $name) = split(/:/, $ent);
	my $db = MBGD::DB->new;
	if (! $FuncCategory{$sp}) {
		foreach $g (MBGD::Gene->get($db, $sp)) {
			$FuncCategory{$sp}->{$g->{name}} = $g->{funccat};
		}
	}
	return $FuncCategory{$sp}->{$name};
}
sub get_func_category_from_file {
	my($ent) = @_;
	my($filename);
	my($sp, $orf) = split(/:/, $ent);
	my($orfname);

    #
	$filename = "$DIR_funccat/$sp.class";
	if (! $FuncCategory{$sp}) {
		if (! open(FuncCategory, "$filename")) {
			$FuncCategory{$sp} = {};
		} else {
			while (<FuncCategory>) {
				($cl, $orfname) = split;
				$FuncCategory{$sp}->{$orfname} = $cl;
			}
			close(FuncCategory);
		}
	}
	return $FuncCategory{$sp}->{$orf};
}

###############################################################################
#
sub get_func_color {
	my($sp, $class) = @_;
	my($cid) = &get_func_color_id($sp,$class);
	&get_func_color_from_id($cid);
}

###############################################################################
#
sub get_func_color_from_id {
	my($cid) = @_;
	&create_color if (! @COLOR);
	return ("ffffcf") if ($cid == $UNKNOWN);	## function unassigned;
	return ($COLOR[$cid-1]);
}

###############################################################################
#
sub get_func_color_id {
	my($sp, $class) = @_;
	my(@class) = split(/\./,$class);
	my($colnum);
	my($cl, $cl2, $cl3);

	$cl = "$class[0]";
	$cl2 = "$class[0].$class[1]" if ($class[1]);
	$cl3 = "$class[0].$class[1].$class[2]" if ($class[1] && $class[2]);

	if (! %ColorTab) {
		%ColorTab = &create_colortab;
	}
	if ($cl3 && $ColorTab{$sp,$cl3}) {
		$colnum = $ColorTab{$sp,$cl3};
	} elsif ($cl2 && $ColorTab{$sp,$cl2}) {
		$colnum = $ColorTab{$sp,$cl2};
	} elsif ($cl && $ColorTab{$sp,$cl}) {
		$colnum = $ColorTab{$sp,$cl};
	} else {
		$colnum = $UNKNOWN;
	}
	return $colnum;
}

###############################################################################
#
sub get_class_info {
    my($org, $num) = @_;
    my($classInfo);
    my $fname;
    local(*FILE, $_);

    #
    $fname = "$DIR_funccat/$org.cl";
    open(FILE, "< $fname") || return('');
    while(<FILE>) {
	if(/^\s*$num[\s\t]+(\S.+)$/) {
	    $classInfo = $1;
	    $classInfo =~ s|//|;|g;
	    last;
	}
    }
    close(FILE);

    return($classInfo);
}

###############################################################################

$FILE_colortab = "$DIR_funccat/colortab.category";

###############################################################################
#
sub create_colortab {
	my(%ColorTab);
	my($i, $name, $category, $s, $c, $c0, $cat);
        local(*COLORTAB);

	open(COLORTAB, "$FILE_colortab") || die "Can't open $FILE_colortab\n";
	while (<COLORTAB>) {
		chop;
		($name, $color, $category) = split(/\t/);
		push(@COLOR, $color);
		++$i;
		foreach $cat (split(/ /, $category)) {
			($s,$c0) = split(/:/, $cat);
			foreach $c (split(/,/, $c0)) {
				$ColorTab{$s,$c} = $i;
			}
		}
	}
	close(COLORTAB);
	return %ColorTab;
}

###############################################################################
#
sub create_color {
        local(*COLORTAB);

	open(COLORTAB, "$FILE_colortab") || die "Can't open $FILE_colortab\n";
	while (<COLORTAB>) {
		($name, $color, $category) = split(/\t/);
		push(@COLOR, $color);
	}
	close(COLORTAB);
}
sub create_color_hash {
        local(*COLORTAB);

	open(COLORTAB, "$FILE_colortab") || die "Can't open $FILE_colortab\n";
	while (<COLORTAB>) {
		my($name, $color, $category) = split(/\t/);
		$Colors{$name} = $color;
		push(@Names, $name);
	}
	close(COLORTAB);
	(\%Colors, \@Names);
}

###############################################################################
#
###sub create_color {
###	my($r,$g,$b,$R,$G,$B);
###	push(@COLOR, '');
###	foreach $r (3,4,2) {
###		foreach $g (2..4) {
###			foreach $b (2..4) {
###				$R = sprintf("%02x", int(255 * $r/4));
###				$G = sprintf("%02x", int(255 * $g/4));
###				$B = sprintf("%02x", int(255 * $b/4));
###				push(@COLOR, "#$R$G$B");
###			}
###		}
###	}
###}

###############################################################################
#
#sub print_rev_colortab {
#        local(*COLORTAB);
#
#	open(COLORTAB, "$FILE_colortab") || die "Can't open $FILE_colortab\n";
#	while (<COLORTAB>) {
#		($name, $color, $category) = split(/\t/);
#		push(@COLOR, $color);
#		++$i;
#		foreach $cat (split(/ /, $category)) {
#			($s,$c0) = split(/:/, $cat);
#			foreach $c (split(/,/, $c0)) {
#				$ColorTab{$s,$i} = $c;
#			}
#		}
#	}
#}

###############################################################################
# $BL>>N(B
#     getFunctionCategory()
# $B35MW(B
#     $B%U%!%s%/%7%g%s<oJL!"@8J*<o%3!<%I!"(Borf$BL>$+$i3:Ev$9$k%U%!%s%/%7%g%s%+%F%4%j!<$r(B
#     $BJV$9!#(B
# $B0z?t(B
#     @args     :$B!!%U%!%s%/%7%g%s<oJL!&@8J*<o%3!<%I!&%U%!%s%/%7%g%sHV9f$+$i$J$k%j%9%H(B
# $BLaCM(B
#     $funccat  :$B!!%U%!%s%/%7%g%s%+%F%4%j!<(B
# $B@bL@(B
#
# $BHw9M(B
#
sub getFunctionCategory {
        my(@args) = @_;
        my($func, $sp, $orf);
    my($funccat);

        if (@args == 2) { # $B0z?t$,(B2$B$D$N>l9g$O!"@8J*<o%3!<%I(B:orf$BL>$N%U%)!<%^%C%H$G$J$$$+$r3NG'(B
                $func = $args[0];
        ($sp,$orf) = split(/:/, $args[1]);
        if(! $orf) {
            # $B0z?t$,==J,$G$J$$(B
                        return undef;
                }
        } elsif (@args == 3) {
                ($func, $sp, $orf) = @args;
        } else {
                return undef;   # $B0z?t$,==J,$G$J$$(B
        }

    # $func$B$NL>A0$K$h$C$F(BFunction category$B<oJL<hF@%k!<%A%s$r8F$S=P$9!#(B
    if($func eq 'MBGD') {
                # MBGD$B%G!<%?%Y!<%9$G$N(BFunction category
                my %FuncCat = &createFunctab();
                $funccat = &searchFunction($sp,$orf,%FuncCat);
    } else {
      # $B3:Ev$J$7(B
                return undef;
    }

    return $funccat;
}

###############################################################################
# $BL>>N(B
#     searchFunction()
# $B35MW(B
#     $B@8J*<o%3!<%I!"(Borf$BL>$+$i3:Ev$9$k%U%!%s%/%7%g%s%+%F%4%j!<$r(B
#     $BJV$9!#(B
# $B0z?t(B
#     $sp       : $B@8J*<o%3!<%I(B
#     $funcno   : $B%U%!%s%/%7%g%sHV9f(B
#     %funcTab  : $B@8J*<o%3!<%I!\%U%!%s%/%7%g%sHV9f$r%-!<$H$7!"%U%!%s%/%7%g%s(B
#                 $B%+%F%4%j!<$rCM$r$7$?%O%C%7%e(B
# $BLaCM(B
#     $funccat : $B%U%!%s%/%7%g%s%+%F%4%j!<(B
# $B@bL@(B
#     $B@8J*<o%3!<%I!\%U%!%s%/%7%g%sHV9f$G3:Ev$9$k%U%!%s%/%7%g%s%+%F%4%j!<$r8!:w$9$k!#(B
#     $B3:Ev$,L5$$>l9g!">e0L$N%U%!%s%/%7%g%sHV9f$G8!:w$9$k!#3:Ev$,8+$D$+$k$^$G8!:w$9$k!#(B
# $BHw9M(B
#
sub searchFunction {
        my($sp, $funcno, %funcTab) = @_;
    my(@funcs);
    my ($funccat);

        # $B%U%!%s%/%7%g%sHV9f$rJ,2r$9$k!#(B
    my @num = split(/\./, $funcno);
    my $parN="";
    foreach my $k (@num) {
                $parN .= $k;
        push(@funcs, $parN);
        $parN .= ".";
        }

    # $BJ,2r$7$?%U%!%s%/%7%g%sHV9f$rMQ$$$F3:Ev$9$k%U%!%s%/%7%g%s%+%F%4%j!<$r<hF@$9$k!#(B
    for(my $i = length(@num); $i>=0; $i--) {
                my $n = $funcs[$i];
        $funccat = $funcTab{$sp,$n};
                if($funccat) {
                        last;
                }
    }
        return $funccat;
}


###############################################################################
# $BL>>N(B
#     createFunctab()
# $B35MW(B
#     category$B%U%!%$%k$rFI$_9~$_!"@8J*<o%3!<%I$H%U%!%s%/%7%g%sHV9f$r%-!<$H$7!"(B
#     $B3:Ev$9$k%U%!%s%/%7%g%s%+%F%4%j!<$rCM$H$7$?%O%C%7%e$rJV$9!#(B
#
# $B0z?t(B
#     $B$J$7(B
# $BLaCM(B
#     %funcTab : $B%U%!%s%/%7%g%s%+%F%4%j$N%O%C%7%e(B
# $B@bL@(B
#
# $BHw9M(B
#
sub createFunctab {
    my(%FuncTab);
    my($color, $function, $category, $s, $c, $c0, $cat);
        local(*FTAB);

    open(FTAB, "$DIR_funccat/colortab.category") || die "Can't open $DIR_funccat/colortab.category\n";
    while (<FTAB>) {
        chop;
        ($function, $color, $category) = split(/\t/);
        foreach $cat (split(/ /, $category)) {
            ($s,$c0) = split(/:/, $cat);
            foreach $c (split(/,/, $c0)) {
                $FuncTab{$s,$c} = $function;
            }
        }
    }
    close(FTAB);
    return %FuncTab;
}

###############################################################################
# $BL>>N(B
#     get_func_category_from_global_file()
# $B35MW(B
#     category$B%U%!%$%k$rFI$_9~$_!"@8J*<o%3!<%I$H%U%!%s%/%7%g%sHV9f$r%-!<$H$7!"(B
#     $B3:Ev$9$k%U%!%s%/%7%g%s%+%F%4%j!<$rCM$H$7$?%O%C%7%e$rJV$9!#(B
#
# $B0z?t(B
#     $B$J$7(B
# $BLaCM(B
#     %globalFunc : $B%U%!%s%/%7%g%s%+%F%4%j$N%O%C%7%e(B
# $B@bL@(B
#
# $BHw9M(B
#
sub get_func_category_from_global_file {
	my($filename);
	my(%globalFunc);

	$filename = "$DIR_funccat/univ/univ.cl";

	open(FUNC, "$filename") or die($!);
        while(<FUNC>) {
                chomp;
                my $id;         # $B%+%F%4%j!<HV9f(B
                my $category;   # $B%+%F%4%j!<L>(B
                my @hi_cat;     # $B3,AXKh$N%+%F%4%j!<L>(B
                my @hi_num;     # $B3,AXKh$N%+%F%4%j!<HV9f(B

                ($id, $category) = split/\t/;
        	if($category =~ /^\s*(.*)/) {
                	$category = $1;
        	}
        	if($category =~ /(.*\S)\s*$/) {
                	$category = $1;
        	}
		$category =~ /^\s*/;
		$category =~ /\s*$/;

                # $B%+%F%4%j!<L>$N3,AXKh$NJ,3d(B
                @hi_cat = split/\s*\/\/\s*/, $category;

                # $B%+%F%4%j!<HV9f$N3,AXKh$NJ,3d(B
                @hi_num = split/\./, $id;

                if(@hi_num != @hi_cat) {
                        warn "Invalid file format : $_";
                }

                # $B3,AXKh$K%O%C%7%e$K3JG<$9$k!#(B(2$B3,AXBP1~(B)
                $globalFunc{'FIRST'}->{$hi_cat[0]} = $hi_num[0];
                if(@hi_num == 2) {
                        $globalFunc{'SECOND'}->{$hi_cat[0]}->{$hi_cat[1]} = "$hi_num[0].$hi_num[1]";
                }

        }
        close(FUNC);

        return %globalFunc;
}

###############################################################################
# $BL>>N(B
#     get_global_func_category()
# $B35MW(B
#    $B%U%!%s%/%7%g%sL>$+$i3:Ev$9$k%U%!%s%/%7%g%sHV9f$rJV$9!#(B
#
# $B0z?t(B
#     $B$J$7(B
# $BLaCM(B
#     $B%U%!%s%/%7%g%s%+%F%4%j(B
# $B@bL@(B
#
# $BHw9M(B
#
sub get_global_func_category {
	my(@funcName) = shift(@_);
        my %globalFunc = &get_func_category_from_global_file;

        # 2$B3,AXBP1~(B
	if($funcName[0] =~ /^\s*(.*)/) {
		$funcName[0] = $1;
	}
	if($funcName[0] =~ /(.*\S)\s*$/) {
		$funcName[0] = $1;
	}

        if(@funcName > 1) {
        	if($funcName[1] =~ /^\s*(.*)/) {
                	$funcName[1] = $1;
        	}
        	if($funcName[1] =~ /(.*\S)\s*$/) {
                	$funcName[1] = $1;
        	}
                my $name =  $globalFunc{'SECOND'}->{$funcName[0]}->{$funcName[1]};
                if(!$name) {
                        $name = $globalFunc{'FIRST'}->{$funcName[0]};
                }
                return $name;
        } elsif(@funcName == 1) {
                return $globalFunc{'FIRST'}->{$funcName[0]};
        } else {
                return ;
        }
}

###############################################################################
package main;

if ($0 eq __FILE__) {
	MBGD::FuncCat::ColorTab->new;
}

###############################################################################
1;
###############################################################################
