#!/usr/local/bin/perl

=head1 NAME

MBGD::Genome - MBGD genome database

=head1 SYNOPSIS

  use MBGD::Genome;

  $g = MBGD::Genome->new;
  $g->setValues({
	name => $name,
	fullname => $fullname,
	strain => $strain,
	sequences => \@Sequences
  });
  $g->store;			# store into the database
  $g->load($orgname, $version);	# load from the database

=back

=cut

package MBGD::Genome;

use MBGD;
use MBGD::Object;
use MBGD::Versionable;
use MBGD::Sequence;

@ISA = qw{ MBGD::Versionable };

#sub new {
#	inherited from Object.pm
#}

sub setValues {
	my($this, $values) = @_;
	foreach my $attr (keys %{$values}) {
		if ($attr eq 'ntseq') {
			$this->{ntseq} = Sequence->new($values->{ntseq});
		} else {
			$this->{$attr} = $values->{$attr};
		}
	}
}
sub getChromosomes {
	my($this, $opt) = @_;
	my($db) = ($opt->{db} ? $opt->{db} : $this->{db});
	my(@args) = ("genome=" . $this->get_identifier, $opt);
	if ($db) {
		@args = ($db, @args);
	}
	my @chr = MBGD::Chromosome->find(@args);
	return @chr;
}

sub print_ntseq {
	my($this) = @_;
	$this->{ntseq}->print_fasta(
		"$this->{orgname} $this->{seqname}");
}

sub get_fromto {
	my($Pos, $mode) = @_;
	if ($mode eq 'rev') {
		if ($Pos[0]->{dir} > 0) {
			return ($Pos->[0]->{from}, $Pos->[$#{$Pos}]->{to});
		} else {
			return ($Pos->[0]->{to}, $Pos->[$#{$Pos}]->{from});
		}
	} else {
		return ($Pos->[0]->{from}, $Pos->[$#{$Pos}]->{to}, $Pos->[0]->{dir});
	}
}

1;
