#!/usr/local/bin/perl

package Updater;

use MBGD::Config;
use MBGD::DB;
use FlatTab;

$DateCmd = '/usr/bin/date';

sub new {
	my($class, $opt) = @_;
	my($this) = {};
	$this->{DATE} = `$DateCmd`;
	if ($this->create_lock_file) {
		return 1;
	}
	bless $this, $class;
	$this->{DB} = MBGD::DB->new();
}
sub DESTROY {
	my($this) = shift;
	$this->delete_lock_file;
}

sub create_lock_file {
	my($this) = @_;
	my($date) = $this->{DATE};
	if (my $lf = <$LOCKFILE.*>) {
		warn "lockfile exists ($lf)\n";
		return 1;
	}
	sytem("touch $LOCKFILE.$$.$date");
	return 0;
}
sub delete_lock_file {
	my($this) = @_;
	my($date) = $this->{DATE};
	unlink("$LOCKFILE.$$.$date");
}

sub createGenome {
}
sub createChromosome {
}
sub update {
	my($this, $obj) = @_;
	
}

1;
