#!/usr/local/bin/perl

package MBGD::Versionable;
use MBGD::Object;

@ISA = qw{ MBGD::Object };

sub get_latest {
	my($this, $db, $status) = @_;
	$db = $this->{db} if (! $db && $this->{db});
	if (! $db) {
		warn "No database is set\n";
		return -1;
	}
	my @obj = $db->fetch_object($this);
	my ($latest, $latest_ver);
	$latest_ver = 0;
	foreach $obj (@obj) {
		if ($obj->{ver} > $latest_ver) {
			next if ($status ne '' && $obj->{status} != $status);
			$latest = $obj;
			$latest_ver = $obj->{ver};
		}
	}
	return $latest;
}
sub get_default_version {
	my($this) = @_;
}
sub set_default_version {
	my($this, $ver) = @_;
}
sub set_latest_version {
	my($this, $db) = @_;
	if (my $latest = $this->get_latest($db)) {
		$this->{ver} = $latest->{ver};
	} else {
		$this->{ver} = 1;
	}
	$this->{status} = '0';
}
sub create_new_version {
	my($this, $db) = @_;
	if (my $latest = $this->get_latest($db)) {
print STDERR ">$latest, $latest->{ver}\n" if ($main::DEBUG);
		if ($latest->{status} == 1) {
			$this->{ver} = $latest->{ver} + 1;
		}
	} else {
		$this->{ver} = 1;
	}
	$this->{status} = '0';
}
sub store {
	my($this, @args) = @_;
	my($DB);
	if (UNIVERSAL::isa($args[0], 'MBGD::DB')) {
		$DB = shift @args;
	} elsif ($this->{db}) {
		$DB = $this->{$db};
	}
#	$DB->set_mode('mvcc', {new_version => 1});

	my $opt = $args[0];

	if ($opt->{new_version}) {
		$this->create_new_version($DB);
		$opt->{force_to_insert} = 1;
print STDERR "new, $this->{ver}\n" if ($main::DEBUG);
	} else {
		$this->set_latest_version($DB);
	}
	$this->SUPER::store($DB, $opt);
}

if ($0 eq __FILE__) {
use MBGD;
use MBGD::Genome;
use MBGD::DB;

$db = MBGD::DB->new;
$g = MBGD::Genome->new($db, { sp => 'bsu' });
$g->set_new_version;
$g->print_tab;
}

1;
