#!/usr/local/bin/perl

use MBGD::DB;

$db = MBGD::DB->new("dbi:mysql:database=mbgd");

$fields="spname1,spname2,from1,to1,from2,to2,score,pam";
@hom = MBGD::Homology->find("spname1='eco:b0002'", {fields=>$fields});
foreach $h (@hom) {
	$h->print_tab({sep=>' ', fields=>$fields});
}
exit;


#@out = MBGD::Gene->fetch($db, ["eco:b0002", "mge:MG022",
#		"sau:SA0002", "hpy:HP0003"], {depth=>1});

#$a = MBGD::DBTable->new($db, 'Genome');
#$s = $a->get_composite_object('gene', "genome.sp='mge'");
#print "$s\n";
#$db->execute("$s");
#exit;
#

@out = MBGD::Chromosome->get($db, ['dra'], {depth=>1});
foreach $o (@out) {
	print join(' ', $o->{sp}, $o->{name}, $o->{seq}->{length}),"\n";
}

@out = MBGD::ProtMotif->get($db, [
	"pfam:Pfam00003", "pfam:pfam00005"
], {keys=>"motlib:motid", depth=>1});


foreach $o (@out) {
	print join(" ", $o->{sp}, $o->{name}, $o->{motlib},$o->{motid},$o->{descr},$o->{aaseq}->{length}), "\n";
}

exit;

$out = $db->select_fetch("gene", {columns=>"sp,name,descr", where=>"sp='eco' and from1 < 5000", order=>"from1", limit=>5});

foreach $o (@{$out->{INFO}}) {
	foreach $k (keys %{$o}) {
		print "$k $o->{$k}\n";
	}
}
