package MBGD_ACCUM::Schema::Geneset;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("geneset");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => undef,
    is_nullable => 1,
    size => 14,
  },
  "project_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "ver",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "selected",
  {
    data_type => "SMALLINT",
    default_value => undef,
    is_nullable => 1,
    size => 5,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint("geneset_unique_project_ver", ["project_id", "ver"]);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-19 15:12:50
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:238sBhDg1YqT3X8kpiYi2g

__PACKAGE__->belongs_to (
    project => 'MBGD_ACCUM::Schema::Project', {
        'foreign.id' => 'self.project_id'
    }
);
__PACKAGE__->has_many (
    chromosomemodels => 'MBGD_ACCUM::Schema::Chromosomemodel', {
        'foreign.geneset_id' => 'self.id'
    }
);
__PACKAGE__->has_many (
    genemodels => 'MBGD_ACCUM::Schema::Genemodel', {
        'foreign.geneset_id' => 'self.id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
