package MBGD_ACCUM::Schema::Transcript;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("transcript");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => undef,
    is_nullable => 1,
    size => 14,
  },
  "gene_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "seqreg_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "proteinseq_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "type",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 10,
  },
  "seqno",
  {
    data_type => "SMALLINT",
    default_value => undef,
    is_nullable => 0,
    size => 5,
  },
  "protid",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 20,
  },
  "gi",
  { data_type => "INT", default_value => undef, is_nullable => 1, size => 10 },
  "transl_table",
  { data_type => "TINYINT", default_value => undef, is_nullable => 1, size => 3 },
  "codon_start",
  { data_type => "TINYINT", default_value => undef, is_nullable => 1, size => 3 },
  "product",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 250,
  },
  "user_def",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 250,
  },
);
__PACKAGE__->set_primary_key("id");


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-19 15:12:50
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:vXshMlXu0m9d+a7Y34HZSA

__PACKAGE__->belongs_to (
    gene => 'MBGD_ACCUM::Schema::Gene', {
        'foreign.id' => 'self.gene_id'
    }
);
__PACKAGE__->belongs_to (
    seqreg => 'MBGD_ACCUM::Schema::Seqreg', {
        'foreign.id' => 'self.seqreg_id'
    }
);
__PACKAGE__->belongs_to (
    proteinseq => 'MBGD_ACCUM::Schema::Proteinseq', {
        'foreign.id' => 'self.proteinseq_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
