#!/usr/local/bin/perl

use MBGD::Taxonomy;
use File::Basename;
use File::Path;
package Property::Base;

sub new {
	my($class, %option) = @_;
	## Singleton
	if (! $option{reset} && $__Param{$class}) {
		return $__Param{$class};
	}
	my($this) = $__Param{$class} = {};
	bless $this, $class;
	## initialize
	$this->initialize(%option);
	$this;
}

sub initialize {
	my($this, %option) = @_;
	my($tmpData) = {};
	my($Param) = {};
	# Read from the __DATA__ section written in the module file
	my $handle = (ref $this) . "::DATA";
	while(<$handle>){
		next if (/^#/); ## comment
		if (/^SECTIONS:\s*(\S+)/) {
			@{$this->{sections}} = split(/,/, $1);
		} elsif (/^([a-z0-9_]+):\s*(\S.*)$/) {
			## field name
			$name = $1;
			$value = $2;
			while ($value =~ /(\$[\w:]+)/g) {
				$var = "\\" . $1; $val = eval $1;
				$value =~ s/$var/$val/;
			}
			$tmpData->{$name} = $value;
		} elsif (/^\/\//) {
			## record delimiter
			if (! $tmpData->{varname}) {
				$tmpData->{varname} = $tmpData->{name};
			}
			if ($option{reset} ne 'clear') {
				$tmpData->{value} = $tmpData->{default};
			}
			$Param->{$tmpData->{name}} = $tmpData;
			push(@{$List}, $tmpData->{name});
			$tmpData = {};
		} elsif (/^\s+\S/) {
			## continuing line
			s/^\s+/ /;
			$value = $_;
			while ($value =~ /(\$[\w:]+)/g) {
				$var = "\\" . $1; $val = eval $1;
				$value =~ s/$var/$val/;
			}
			$tmpData->{$name} .= $value;
		}
	}
###	my @allspec = MBGD::Taxonomy->new->get_default_spec;
###
###	$Param->{species}->{value} = $Param->{species}->{default}
###		= join("|", @allspec);
	$this->{Param} = $Param;
	$this->{List} = $List;

	if ($option{datafile}) {
		$this->readdata($option{datafile});
	}
}

## Create and return a reference of a tie-hash object HomolParamHash
sub asHashRef {
	my($this) = @_;
	my(%homHash);
	tie %homHash, "Property::ParamHash", $this;
	return \%homHash;
}

# a copied hash table is returned (unoverwritable)
sub asHash {
	my($this) = @_;
	return %{ $this->asHashRef };
}

sub printHelpSummary {
};
sub printHelpParam {
	my($this) = @_;
	print $this->printHelpSummary;
	foreach $n (@{$this->{List}}) {
		$this->__printParamHelp($this->{Param}->{$n});
	}
}
sub __printParamHelp {
	my($this, $data) = @_;
	if ($data->{fullname} && $data->{description}) {
		print "<H4>$data->{fullname}  [$data->{step}]</H4>\n";
		print "$data->{description}\n";
	}
}
sub printParamSetSection {
	my($this, $currsec) = @_;
	if (ref $this->{sections} eq 'ARRAY') {
		foreach $sec (@{$this->{sections}}) {
			if ($sec eq $currsec) {
				print "<b>[$sec]</b>";
			} else {
				print qq{<INPUT TYPE="submit" NAME="section" VALUE="$sec">\n};
			}
		}
	}
}
sub printParamSetTab {
	my($this, %opt) = @_;
	my($class) = ref($this);
	$class =~ s/Property:://;
	print "<table BORDER>\n";
	print qq{<tr><th> Parameters
	<A href="/htbin/SetParamScreen.pl?mode=help&class=$class">[Help]</A><th>Value};
	if (! $opt{section} && $this->{sections}) {
		$opt{section} = $this->{sections}->[0];
	}
	foreach $n (@{$this->{List}}) {
		next if ($opt{section} && $n !~ /^$opt{section}\./);
		next if (defined $this->{Param}->{$n}->{no_set});
		if ($opt{mode} eq 'edit') {
			__printParamSetTabEdit($this->{Param}->{$n});
		} else {
			__printParamSetTab($this->{Param}->{$n});
		}
	}
	print "</table>\n";
}
sub __printParamSetTab {
	my($data) = @_;
	print "<tr><td>$data->{fullname}";
	print "<td>$data->{value}\n";
}
sub __printParamSetTabEdit {
	my($data) = @_;
	print "<tr><td>$data->{fullname}";

	my($value) = $data->{value};
	## we do not fill a default value in an empty value
###	$value = $data->{default} if (!defined $value);

	if ($data->{type} eq 'radio') {
		my @opt = split(/\s*,\s*/, $data->{options});
		print "<td>";
		foreach $o (@opt) {
			$showname = $o;
			if ($o =~ /\[(.*)\]/) {
				$showname = $1;
				$o =~ s/\s*\[.*\]\s*//;
			}
			$checked = ($o eq $value ? "CHECKED" : "");
		 	print qq{<input TYPE="radio" } .
			  qq{NAME="$data->{varname}" VALUE="$o" $checked>$showname\n};
		}
	} elsif ($data->{type} eq 'select') {
		my @opt = split(/\s*,\s*/, $data->{options});
		print qq{<td><select NAME="$data->{varname}">\n};
		foreach $o (@opt) {
			$selected = ($o eq $value ? "SELECTED" : "");
		 	print qq{<option VALUE="$o" $selected>$o\n};
		}
	} elsif ($data->{type} eq 'check') {
		print qq{<td><input TYPE="checkbox" NAME="$data->{varname}" };
		print "CHECKED" if ($value);
		print ">";
	} else {
		print qq{<td><input NAME="$data->{varname}" };
		print qq{VALUE="$value">\n};
	}
}
sub getValue {
	my($this, $name) = @_;

if (! defined $this->{Param}->{$name}) {
	warn "accessing undefined parameter [$name]\n";
	return '';
}

	return $this->{Param}->{$name}->{value};
}
sub setValue {
	my($this, $name, $val) = @_;
	if (defined $this->{Param}->{$name}) {
		$this->{Param}->{$name}->{value} = $val;
	} else {
		warn "accessing undefined parameter [$name]\n";
	}
}
sub getParams {
	my($this) = @_;
	my($data) = {};
	foreach $key (keys %{$this->{Param}}) {
		$data->{$key} = $this->getValue($key);
	}
	return $data;
}
sub setParamAll {
	my($this, $data) = @_;
	foreach $key (keys %{$this->{Param}}) {
		next if ($this->{Param}->{$key}->{no_set});
		next if ($data->{section} && $key !~ /^$data->{section}\./);
		if ($this->{Param}->{$key}->{type} eq 'check') {
			if ($data->{$key}) {
				$this->setValue($key, 1);
			} else {
				$this->setValue($key, 0);
			}
		} elsif (! $this->{Param}->{$key}->{no_set}) {
			$this->setValue($key, $data->{$key});
		}
	}
}
sub setParams {
	my($this, $data) = @_;
	foreach $key (keys %{$data}) {
		$this->setValue($key, $data->{$key});
	}
}
## for compatibility
sub readdata {
	my($this, $file) = @_;
	$this->load($file);
}
sub load {
	my($this, $paramfile) = @_;
	open(F, $paramfile) || die "Can't open $paramfile\n";
	while(<F>) {
		($name, $value) = split;
		$this->setValue($name, $value);
	}
	close(F);
}
sub save {
	my($this, $paramfile) = @_;

    my($dir) = File::Basename::dirname($paramfile);
    File::Path::mkpath("$dir", 0, 0750) if (! -e "$dir");
	open(O, ">$paramfile") || die("Can not open $paramfile($!)");
	foreach $key (keys %{$this->{Param}}) {
		my $val = $this->getValue($key);
		print O "$key\t$val\n";
	}
	close(O);
}

######################################
# Tie-hash interface for accessing the values directly
#	%h = $homolParam->asHash;
#	print $h{'eval'};
#	$h{'score'} = 100;
######################################
package Property::ParamHash;
use Tie::Hash;

@ISA = qw(Tie::Hash);

sub TIEHASH {
	my($class, $par) = @_;
	bless {Par => $par}, $class;
}
sub FETCH {
	my($this, $key) = @_;
	return $this->{Par}->getValue($key);
}
sub STORE {
	my($this, $key, $value) = @_;
	$this->{Par}->setValue($key, $value);
}
sub FIRSTKEY {
	my($this) = @_;
	scalar keys %{$this->{Par}->{Param}};
	return scalar each %{$this->{Par}->{Param}};
}
sub NEXTKEY {
	my($this) = @_;
	return scalar each %{$this->{Par}->{Param}};
}
sub EXISTS {
	my($this) = @_;
	return exists $this->{Par}->{Param};
}
######################################
1;

