#!/usr/bin/perl -s
use strict;
use FileHandle;

package RECOG::DomClustTree;
###############################################################################
#
# $self->{'DOMCLUST_TREE'}
# $self->{'DOMCLUST_HAND'}
#
#
#
#
#
#
#
#
#
#
#
#
###############################################################################

###############################################################################
# $BL>>N(B
#     new()
# $B35MW(B
#     $B%3%s%9%H%i%/%?(B
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub new {
    my($class) = shift;
    my(@args) = @_;
    my($self) = {};

    bless($self, $class);
    $self->_init(@args);

    return $self;
}

###############################################################################
# $BL>>N(B
#     _init()
# $B35MW(B
#     $B=i4|=hM}(B
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#     $B?F$N=i4|=hM}$r<B9T$7$F$+$i!"<+J,$N=i4|=hM}$r<B9T$9$k!#(B
# $BHw9M(B
#
sub _init {
    my($self) = shift;
    my(@args) = @_;

    # $B?F$N(B _init() $B$r8F=P(B
#    $self->SUPER::_init(@args);

    # $B0J2<$K=i4|=hM}(B

    return;
}

###############################################################################
# $BL>>N(B
#     get_node()
# $B35MW(B
#
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub get_node {
    my($self) = shift;
    my($pos) = shift;

    #
    my($tree_ref) = $self->{'DOMCLUST_TREE'};
    my($hand_ref) = $self->{'DOMCLUST_HAND'};

    #
    my($curr_ref) = $tree_ref;
    for(my$i = 0; $i < $pos; $i++) {
        my($hand) = $hand_ref->[$i];
        if ($hand =~ /L/i) {
            if (!exists($curr_ref->{'L'})) {
                $curr_ref->{'L'} = {};
            }
            $curr_ref = $curr_ref->{'L'};
        }
        else {
            if (!exists($curr_ref->{'R'})) {
                $curr_ref->{'R'} = {};
            }
            $curr_ref = $curr_ref->{'R'};
        }
    }

    return $curr_ref;
}

###############################################################################
# $BL>>N(B
#
# $B35MW(B
#
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub get_all_sporf {
    my($self) = shift;
    my($node_ref) = shift;
    my($sporf_hash_ref) = shift || {};

    foreach my$rl ('R', 'L') {
        if (ref($node_ref->{"$rl"})) {
            $self->get_all_sporf($node_ref->{"$rl"}, $sporf_hash_ref);
        }
        else {
            my($sporf) = $node_ref->{"$rl"};
            $sporf_hash_ref->{"$sporf"} = 1;
        }
    }

    return $sporf_hash_ref;
}

###############################################################################
# $BL>>N(B
#     parase()
# $B35MW(B
#     domclust $B$N(B tree $B=PNO$r(B parse $B$9$k(B
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub parse {
    my($self) = shift;
    my($fh) = shift;

    #
    my($tree_ref) = $self->{'DOMCLUST_TREE'} = {};
    my($hand_ref) = $self->{'DOMCLUST_HAND'} = [];

    #
    while (my$line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        if ($line =~ /([\+\*])\-/) {
            my($pat) = $1;
            my($sporf, $descr) = ($line =~ /[\+\*]\-\s+(\S+)\s*(.*)/);
            my($dist) = ($line =~ /[\+\*]\-\|\s+(\S+)/);
            my($pos) = index($line, $pat) / 2 - 1;
            if ($hand_ref->[$pos] eq '') {
                $hand_ref->[$pos] = 'R';
            }

            my($n) = scalar(@{$hand_ref});
            for(my$i = $pos + 1; $i < $n; $i++) {
                my($c) = substr($line, 2 + $i * 2, 1);
                $hand_ref->[$i] = 'R';
                if ($c eq '|') {
                    $hand_ref->[$i] = 'L';
                }
            }

            if (defined($sporf)) {
                my($node_ref) = $self->get_node($pos);
                my($rl) = $hand_ref->[$pos];
                $node_ref->{$rl. '_pat'} = $pat;
                $node_ref->{"$rl"} = $sporf;
                $node_ref->{$rl. '_descr'} = $descr;
            }
            if (defined($dist)) {
                my($node_ref) = $self->get_node($pos + 1);
                $node_ref->{'_pat'} = $pat;
                $node_ref->{'DIST'} = $dist;
            }
        }
    }

    return;
}

###############################################################################
# $BL>>N(B
#     parase()
# $B35MW(B
#     domclust $B$N(B tree $B=PNO$r(B parse $B$9$k(B
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub parse_file {
    my($self) = shift;
    my($fileTree) = shift;

    my($fh) = FileHandle->new("$fileTree") || die("Can not open $fileTree($!)");
    $self->parse($fh);
    $fh->close();

    return;
}

###############################################################################
# $BL>>N(B
#     print_node_text()
# $B35MW(B
#
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub print_node_text {
    my($self) = shift;
    my($fh) = shift;
    my($node_ref) = shift;
    my($head) = shift;
    my($phand) = shift;

    #
    if (ref($node_ref->{'R'})) {
        my($head_new) = $head;
        if ($phand =~ /R/i) {
            $head_new .= '  ';
        }
        else {
            $head_new .= '| ';
        }
        $self->print_node_text($fh, $node_ref->{'R'}, $head_new, 'R');
    }
    else {
        $fh->print($head);
        if ($phand =~ /R/i) {
            $fh->print('  ');
        }
        else {
            $fh->print('| ');
        }
        $fh->print( $node_ref->{'R_pat'},
                    '-',
                    $node_ref->{'R'},
                    ' ',
                    $node_ref->{'R_descr'},
                    "\n");
    }

    #
    $fh->print($head, $node_ref->{'_pat'}, '-| ', $node_ref->{'DIST'}, "\n");

    #
    if (ref($node_ref->{'L'})) {
        my($head_new) = $head;
        if ($phand =~ /L/i) {
            $head_new .= '  ';
        }
        else {
            $head_new .= '| ';
        }
        $self->print_node_text($fh, $node_ref->{'L'}, $head_new, 'L');
    }
    else {
        $fh->print($head);
        if ($phand =~ /L/i) {
            $fh->print('  ');
        }
        else {
            $fh->print('| ');
        }
        $fh->print( $node_ref->{'L_pat'},
                    '-',
                    $node_ref->{'L'},
                    ' ',
                    $node_ref->{'L_descr'},
                    "\n");
    }

    return;
}

###############################################################################
# $BL>>N(B
#     print_node_html()
# $B35MW(B
#
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub print_node_html {
    my($self) = shift;
    my($fh) = shift;
    my($node_ref) = shift;
    my($head) = shift;
    my($phand) = shift;

    #
    if (ref($node_ref->{'R'})) {
        my($head_new) = $head;
        if ($phand =~ /R/i) {
            $head_new .= '  ';
        }
        else {
            $head_new .= '| ';
        }
        $self->print_node_html($fh, $node_ref->{'R'}, $head_new, 'R');
    }
    else {
        $fh->print($head);
        if ($phand =~ /R/i) {
            $fh->print('  ');
        }
        else {
            $fh->print('| ');
        }
        $fh->print( $node_ref->{'R_pat'},
                    '-',
                    $node_ref->{'R'},
                    ' ',
                    $node_ref->{'R_descr'},
                    "\n");
    }

    #
    my($all_sporf_ref) = $self->get_all_sporf($node_ref);
    my(@sporf_list);
    foreach my$sporf(keys(%{$all_sporf_ref})) {
        push(@sporf_list, "'$sporf'");
    }
    $fh->print($head);
    $fh->print('<span onclick="selectSporf(');
    $fh->print(join(',', @sporf_list));
    $fh->print(')">');
    $fh->print($node_ref->{'_pat'});
    $fh->print('</span>');
    $fh->print('-| ', $node_ref->{'DIST'}, "\n");

    #
    if (ref($node_ref->{'L'})) {
        my($head_new) = $head;
        if ($phand =~ /L/i) {
            $head_new .= '  ';
        }
        else {
            $head_new .= '| ';
        }
        $self->print_node_html($fh, $node_ref->{'L'}, $head_new, 'L');
    }
    else {
        $fh->print($head);
        if ($phand =~ /L/i) {
            $fh->print('  ');
        }
        else {
            $fh->print('| ');
        }
        $fh->print( $node_ref->{'L_pat'},
                    '-',
                    $node_ref->{'L'},
                    ' ',
                    $node_ref->{'L_descr'},
                    "\n");
    }

    return;
}

###############################################################################
# $BL>>N(B
#     print_node()
# $B35MW(B
#
# $B0z?t(B
#
# $BLaCM(B
#
# $B@bL@(B
#
# $BHw9M(B
#
sub print_node {
    my($self) = shift;
    my($fh) = shift;
    my($node_ref) = shift;
    my($head) = shift;
    my($phand) = shift;

    if (!defined($fh)) {
        $fh = FileHandle->new(">&STDOUT");
    }
    if (!defined($node_ref)) {
        $node_ref = $self->{'DOMCLUST_TREE'};
    }
    if (!defined($head)) {
        $head = '';
    }
    if (!defined($phand)) {
        $phand = 'RL';
    }

    $self->print_node_html($fh, $node_ref, $head, $phand);
}

###############################################################################
package main;
if ($0 eq __FILE__) {
    my($obj) = RECOG::DomClustTree->new();
    $obj->parse_file($ARGV[0]);
    $obj->print_node();
}

###############################################################################
1;#
###############################################################################
