#!/usr/bin/perl -s
package RECOG::MBGD::ClusterTable::Writer::text;
###############################################################################
# .ANLN>N>NN
#     RECOG::MBGD::ClusterTable::Writer::text.pm
# .AN3N5NMNW
#     MBGD::ClusterTable.AN$N,NJN]N;N}N$N9N$NkN%NGN!N<N%N?N$NrN!N"N%N?N%NVN6NhN@NZN$NjN$NNN%NFN%N-N%N9N%NHN$NGN=NPNNNON$N9N$NkN!N#
# .AN@NbNLN@
#     .ANKN\N%NbN%N8N%NeN!N<N%NkN$NO MBGD::ClusterTable::Writer N$NNN%N5N%NVN%N/N%NiN%N9N$NHN$N7N$NFN<NBNANuN$N5N$NlN$NF
#     .AN$N$N$NkN$N,NKN\N%NbN%N8N%NeN!N<N%NkN$NrN%N@N%N$N%NlN%N/N%NHN$NKNMNQN$N$N$NkN$N3N$NHN$NONAN[NDNjN$N7N$NFN$N$N$NJN$N$N!N#
#     .AN>NeN0NLN%N/N%NiN%N9N$NG{ format => "text" } N$NHN;NXNDNjN$N7N$NFN%N$N%NsN%N9N%N?N%NsN%N9N$NrN@N8N@N.N$N9N$NkN$N3N$NHN$N,
#     .ANAN0NDNsN$NGN$N"N$NkN!N#
#     
# .AN%NaN%NsN%NPNJNQN?Nt
#     'FileHandle'
# .AN%NaN%N=N%NCN%NIN0NlNMNw
#     new()
#     write()
# .ANHNwN9NM
#
###############################################################################
use FileHandle;
use CGI qw/ :standard start_table end_table /;
use RECOG::MBGD::ClusterTable::Writer;

use MBGD;
use RECOG;
@ISA = ( 'RECOG::MBGD::ClusterTable::Writer' );

###############################################################################
# .ANLN>N>NN
#     new()
# .AN3N5NMNW
#     .AN%N3N%NsN%N9N%NHN%NiN%N/N%N?
# .AN0NzN?Nt
#     $that  : .AN%N/N%NiN%N9NLN>(N$NbN$N7N$N/N$NON%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9)
# .ANLNaNCNM
#     .AN?N7N5N,N%N$N%NsN%N9N%N?N%NsN%N9N$NXN$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .AN@NbNLN@
#
# .ANHNwN9NM
#
sub new {
    my $that = shift;
##    my %args  = @_;

    # $that .AN$N,N%NjN%NUN%N!N%NlN%NsN%N9N$NJN$NiN!N"N%NQN%NCN%N1N!N<N%N8NLN>N$NrN<NhNFN@N$N9N$NkN!N#
    my $class = ref($that) || $that;

    my $self = {};
    bless $self, $class;

    return $self;
}

###############################################################################
# .ANLN>N>NN
#     write_tmp()
# .AN3N5NMNW
#     .AN%N/N%NiN%N9N%N?N%NFN!N<N%NVN%NkN$NrN%N?N%NVN6NhN@NZN$NjN$NNN%NFN%N-N%N9N%NHN7NAN<N0N$NGN=NPNNNON$N9N$NkN!N#
# .AN0NzN?Nt
#     $self   : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $tabl   : DomClust.AN<NBN9NTN7NkN2NLN$NNN%NON%NCN%N7N%Ne(N%NjN%NUN%N!N%NlN%NsN%N9)
#     $igrp   : ingroup .AN$NKN3N:NENvN$N9N$NkN@N8NJN*N<NoNLN>N$NNN%NjN%N9N%NH
#     $ogrp   : outgroup .AN$NKN3N:NENvN$N9N$NkN@N8NJN*N<NoNLN>N$NNN%NjN%N9N%NH
#     $format : .AN=NPNNNON%NUN%N)N!N<N%N^N%NCN%NH complete, boolean, count N$NNN$N$N$N:N$NlN$N+N$NrN;NXNDNj
# .ANLNaNCNM
#     .AN?N7N5N,N%N$N%NsN%N9N%N?N%NsN%N9N$NXN$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .AN@NbNLN@
#     DomClust::WithCache .AN%N/N%NiN%N9N$NNN%NaN%N=N%NCN%NIgetClusters()N$NNN=NPNNNON%NjN%N9N%NHN$NrNAN[NDNjN$N7
#     $ingrp .AN$NNNMNWNANGN=NgN$NKN@N8NJN*N<NoN$NrNJNBN$NYN$NFNIN=N=NPNNNON$N9N$NkN!N#
# .ANHNwN9NM
#
sub write {
    my $self = shift;
	my $db = shift;
    my $tabl = shift;
    my $igrp = shift;
    my $ogrp = shift;
    my $format = shift;
    my $clusterID = shift;

#    my $sporf  = ",";  # ORF.AN%N;N%NQN%NlN!N<N%N?: NFN1N0NlN@N8NJN*N<NoNFNbN$NNORFN$NNN6NhN@NZN$NjNJN8N;Nz
    my $sporf  = " ";  # ORF.AN%N;N%NQN%NlN!N<N%N?: NFN1N0NlN@N8NJN*N<NoNFNbN$NNORFN$NNN6NhN@NZN$NjNJN8N;Nz

    # outgroup .AN$NKN%NLN%NkNJN8N;NzNNNsN$NNN$N_N$N,NFN~N$NCN$NFN$N$N$NkN>NlN9NgN$NrN9NMNNN8N$N9N$Nk
#    my @outg = grep length($_), @$ogrp;
#    $ogrp = \@outg;

    my $fh = $self->{'FileHandle'};

    # .AN%NFN!N<N%NVN%NkN%NXN%NCN%N@N$NrN=NPNNNON$N9N$NkN!
    my $header_1 = join("\t", '#group',
                               '',      '',      '',           '',          '',           '',
                                '',     '',      '',           '',          '',           '',
                                split(//, 'i' x scalar(@$igrp)));
    my $header_2 = join("\t", '#' . 'HCID',
                                'CID',
                                'CGene',  'CFuncMbgd',  'CFuncCog',  'CFuncKegg',  'CFuncTigr',
                                'SCID',
                                'SCGene', 'SCFuncMbgd', 'SCFuncCog', 'SCFuncKegg', 'SCFuncTigr');
    # .AN!N&outgroup N$N,NBN8N:N_N$N9N$NkN>NlN9Ng
    if(scalar @$ogrp) {
        $header_1 .= "\t" . join("\t", split(//, 'io' x scalar(@$ogrp)));
        $header_2 .= "\t" . join("\t", @$igrp);
        foreach my$sp (@$ogrp) {
            $header_2 .= "\t" . $sp;  # Ingroup
            $header_2 .= "\t" . $sp;  # Outgroup
        }
    }
    # .AN!N&outgroup N$N,NBN8N:N_N$N7N$NJN$N$N>NlN9Ng
    else {
        $header_2 .= "\t" . join("\t", @$igrp);
    }
    print $fh "#clusterID = $clusterID" . "\n";
    print $fh $header_1 . "\n";
    print $fh $header_2 . "\n";

    # .AN%N/N%NiN%N9N%N?N!N"N%N5N%NVN%N/N%NiN%N9N%N?NKNhN$NKN%NjN%N9N%NHN$NrN=NPNNNON$N9N$NkN!N#
    foreach my $cid (sort {$a <=> $b} keys %$tabl) {
        my $c    = $tabl->{$cid};
        my $homc = $c->{'homcluster'};
        my $subc = $c->{'subcluster'};

        my $cinfo = [$cid,
                     $c->{'genename'},          # .AN0NdNENAN;NRNLN>
                     $c->{'func_mbgd'},         # .AN5N!NGN=NLN>
                     $c->{'func_cog'},          #
                     $c->{'func_kegg'},         #
                     $c->{'func_tigr'},         #
                     $c->{'descr'},             #
                     ];
        my @outgrp;
        for(my $k = 0; $k < scalar(@$ogrp); $k++) {
            my $org   = $ogrp->[$k];
            my @glist = keys %{$c->{'outgroup'}{$org}}
                if(exists $c->{'outgroup'}{$org});
            push(@outgrp, join($sporf, $self->transform($format, @glist)));
        }

        # .AN%N5N%NVN%N/N%NiN%N9N%N?NCN1N0NLN$NNN=NhNMN}
        my $i = 0;
        my $subno = scalar(keys %$subc);
        foreach my $sid (sort {$a <=> $b} keys %$subc) {
            my(@ingroup) = ();
            my(@iogroup) = ();
            my $scinfo = [$sid,
                          ($subno > 1 ? $subc->{$sid}{'genename'}  : $c->{'genename'}),   # .AN0NdNENAN;NRNLN>
                          ($subno > 1 ? $subc->{$sid}{'func_mbgd'} : $c->{'func_mbgd'}),  # .AN5N!NGN=NLN>
                          ($subno > 1 ? $subc->{$sid}{'func_cog'}  : $c->{'func_cog'}),   #
                          ($subno > 1 ? $subc->{$sid}{'func_kegg'} : $c->{'func_kegg'}),  #
                          ($subno > 1 ? $subc->{$sid}{'func_tigr'} : $c->{'func_tigr'}),  #
                          ($subno > 1 ? $subc->{$sid}{'descr'}     : $c->{'descr'}),      #
                          ];                         #

            # .ANFNbN7N2N$NNN>NpNJNsN$NrN@N8NJN*N<NoNKNhN$NKN<NhN$NCN$NFN%NjN%N9N%NHN$NKNDNIN2NCN$N9N$NkN!N#
            for(my $j = 0; $j < scalar(@$igrp); $j++) {
                my $org   = $igrp->[$j];
                my @glist = keys %{$c->{'subcluster'}{$sid}{'ingroup'}{$org}}
                    if(exists $c->{'subcluster'}{$sid}{'ingroup'}{$org});
                push(@ingroup, join($sporf, $self->transform($format, @glist)));
            }
            for(my $j = 0; $j < scalar(@$ogrp); $j++) {
                my $org   = $ogrp->[$j];
                my @glist = keys %{$c->{'subcluster'}{$sid}{'ingroup'}{$org}}
                    if(exists $c->{'subcluster'}{$sid}{'ingroup'}{$org});
                push(@iogroup, join($sporf, $self->transform($format, @glist)));
            }

            # .AN%N/N%NiN%N9N%N?N>NpNJNsN!N"N%N5N%NVN%N/N%NiN%N9N%N?N>NpNJNsN!N"NFNbN7N2N!N"N3N0N7N2N$NNN=NgN$NGN=NPNNNO
            print $fh join("\t", $homc, @$cinfo, @$scinfo);
            print $fh "\t";
            print $fh join("\t", @ingroup);
            for(my $j = 0; $j < scalar(@$ogrp); $j++) {
                print $fh "\t";
                print $fh join("\t", $iogroup[$j], $outgrp[$j]);
            }
            print $fh "\n";

            # .AN%N*N%NWN%N7N%NgN%NsN$N,N$N"N$NCN$N?N>NlN9NgN!N"NFN1N$N8NHNVN9NfN$NNN;N~N$NON!N"N%N/N%NiN%N9N%N?N$NNN0NdNENAN;NRNLN>N!N"N5N!NGN=NLN>N!N"OutGroupN$NN
            # .AN=NPNNNON$NrN!N"N#N2N9NTNLN\N0NJN9N_N$NGNMN^N@N)N$N9N$NkN!N#

            if($i == 0 && $option=~ /vis T/) {
                # - .AN%N/N%NiN%N9N%N?N$NNN0NdNENAN;NRNLN>N!N"N5N!NGN=NLN>N$NrN6NuNMNsN$NKN$N9N$Nk
                ($cinfo->[1], $cinfo->[2]) = ('', '');

                # - OutGroup .AN$NNN>NpNJNsN$NrN6NuNMNsN$NKN$N9N$Nk
                for(my $j = 0; $j < scalar(@outgrp); $j++) {
                    $outgrp[$j] = '';
                }
            }

            $i++;
        }

    }

#    print $fh "\n";
}

sub  write_new {
    my $self = shift;
	my $db = shift;
    my $igrp = shift;
    my $ogrp = shift;
    my $format = shift;
    my $clusterID = shift;

    my $fh = $self->{'FileHandle'};

    my $header_1 = join("\t", '#group', '', '', '', '', '', '', split(//, 'i' x scalar(@$igrp)));
    my $header_2 = join("\t", '#'.'HCID', 'SCID', 'SCGene', 'SCFunc', 'CID', 'CGene', 'CFunc');

    if(scalar @$ogrp) {
        $header_1 .= "\t" . join("\t", split(//, 'o' x scalar(@$ogrp)));
        $header_2 .= "\t" . join("\t", @$igrp);
        $header_2 .= "\t" . join("\t", @$ogrp);
    }
	else {
		$header_2 .= "\t" . join("\t", @$igrp);
	}
	print $fh "#clusterID = $clusterID" . "\n";
    print $fh $header_1 . "\n";
    print $fh $header_2 . "\n";

	#---------------------------------------$B%X%C%@=*N;(B

	    # $B%/%i%9%?!"%5%V%/%i%9%?Kh$K%j%9%H$r=PNO$9$k!#(B
    my $tablegene = $main::TBL_DOMRESULT . "_" . $clusterID;
    my $tablefunc = $main::TBL_DOMFUNC . "_" . $clusterID;

#t1.$B%/%i%9%?!<$r%+%&%s%H$7!"BP1~$9$k%/%i%9%?$N(Bgroup$B%G!<%?$rJ];}(B
#t2.$B%5%V%/%i%9%?$N0dEA;R(B
#t3.$B%5%V%/%i%9%?$N(Bfunc
#t4.$B%/%i%9%?$N0dEA;R(B
    my $sql = "select t1.homclustid, t1.clustid, t4.name, t5.name, t1.subclustid, t2.name, t3.name, t1.name "
            . "from $tablegene t1 inner join ( $tablefunc t2 inner join ( $tablefunc t3 inner join ( $tablefunc t4 inner join $tablefunc t5 on t4.clustid=t5.clustid and t4.subclustid=0 and t5.subclustid=0 and t4.dbname=\'gene\' and t5.dbname=\'mbgd\') on t3.clustid=t5.clustid and t3.dbname=\'mbgd\') on t2.clustid=t3.clustid and t2.subclustid=t3.subclustid and t2.dbname=\'gene\') on t1.clustid=t2.clustid and t1.subclustid=t2.subclustid";

	my $dbh = $db->execute($sql);

    my $name_gene;
    my $name_func;

    while(my $line = $dbh->fetch()) {
        my($hcid, $cid, $cgene, $cfunc, $sid, $sgene, $sfunc, $name) = @$line;

        print $fh join("\t", $hcid, $cid, $cgene, $cfunc, $sid, $sgene, $sfunc);

        # ORF$BL>$N<hF@(B
        my(@sub, @out);
        my(@outgrp, @trlist);
        my $trlist={};
        my $sublist={};
        if($name=~/(.*)\sOutgroup\s(.*)/) {
            @sub = split/ /, $1;
            @out = split/ /, $2;
            $sublist = $self->transform_sort(\@sub);
            $trlist = $self->transform_sort(\@out);
        }
        else {
            @sub = split/ /, $name;
            $sublist = $self->transform_sort(\@sub);
        }

        # $B;XDj$7$?@8J*<o=g$KJB$YBX$((B
        # ingroup
        for(my $k = 0; $k < scalar(@$igrp); $k++) {
            my $org   = $igrp->[$k];
            my @glist = keys %{$sublist->{$org}} if(exists $sublist->{$org});
			my $sps="";
			foreach my $sp ($self->transform($format, @glist)) {
				if(length($sps) > 1) {
					$sps = $sps . " " . $sp;
				} else {
					$sps = $sp;
				}
			}
			print $fh "\t$sps";
        }
		
		# outgroup
        for(my $k = 0; $k < scalar(@$ogrp); $k++) {
            my $org   = $ogrp->[$k];
            my @glist = keys %{$trlist->{$org}} if(exists $trlist->{$org});
			my $sps="";
            foreach my $sp ($self->transform($format, @glist)) {
				if(length($sps) > 1) {
					$sps = $sps . " " . $sp;
				} else {
					$sps = $sp;
				}
			}
			print $fh "\t$sps";
        }
		
		print $fh "\n";
		
    }
}

##############################################################################
1; #
##############################################################################
