#!/usr/bin/perl -s
package RECOG::MBGD::OutputDomClust;
use CGI qw/ :standard start_table end_table /;

use MBGD;
use RECOG;
use RECOG::RecogCommon;
use RECOG::DomClustCommon;

$main::CODE = 'euc'; # jis/sjis/euc/utf8

sub new {
	my $that = shift;

	# $that $B$,%j%U%!%l%s%9$J$i!"%Q%C%1!<%8L>$r<hF@$9$k!#(B
    my $class = ref $that || $that;
	my $self  = {};

    bless($self, $class);
	$self->{'CODE'} = 'euc'; # jis/sjis/euc/utf8

	return $self;
}

sub outputError {
	$self = shift;
	$e_code = shift;
	$opt0 = shift;
	$opt1 = shift;

	my $cgi = new CGI;
	$self->outputHeader($cgi);
	printf("#FORMAT_VER=%d\n", $DomClustCommon::VER_DATA_FORMAT);
	print "<br>\n";
	print "#STATUS=error\n";
	print "<br>\n";

	if($e_code==1) {
		print "#CLUSTER_ID=$opt0\n";
		print "<br>\n";
		print "#ERROR=Invalid clusterID.\n";
		print "<br>\n";
	}
	elsif($e_code==2) {
		print "#ERROR=No ingroup.\n";
		print "<br>\n";
	}
	elsif($e_code==3) {
		print "#CLUSTER_ID=$opt0\n";
        print "<br>\n";
		print "#ERROR=Retry count over($main::DOMCLUST_RETRY_COUNT). Can not exec domclust.\n";
	}
	elsif($e_code==4) {
		print "#ERROR=Too many species are selected.(Select:$opt0, MAX:$opt1)\n";
	}
	elsif($e_code==90) {
		print "#ERROR=$opt0\n";
	}
	elsif($e_code==-99) {
		print "#CLUSTER_ID=$opt0\n";
        print "<br>\n";
		print "#ERROR=domclust execution failed.\n";
	}
	else {
		print "#CLUSTER_ID=$opt0\n";
        print "<br>\n";
		print "#ERROR=System Error. Can not exec domclust.\n";
	}
    print $cgi->end_html();
}

sub deleteResult {
	my $self = shift;
	my $id = shift;
	my $res = shift;

	print header(-type => 'text/plain');
    printf("#FORMAT_VER=%d\n", $DomClustCommon::VER_DATA_FORMAT);
	print "#CLUSTER_ID=$id\n";
	print "#STATUS=delete\n";
	if($res) {
		print "#STATUS=delete succeeded.\n";
	}
	else {
		print "#STATUS=delete failed. Is it correct ID?\n";
	}
}

sub outputError_txt {
	my $self = shift;
    my $e_code = shift;
	my $opt0 = shift;
	my $opt1 = shift;
	
	print header(-type => 'text/plain');
	printf("#FORMAT_VER=%d\n", $DomClustCommon::VER_DATA_FORMAT);
	print "#STATUS=error\n";
	if($e_code==1) {
		print "#CLUSTER_ID=$opt0\n";
        print "#STATUS2=Invalid clusterID.\n";
    }
    elsif($e_code==2) {
        print "#STATUS2=No ingroup.\n";
    }
	elsif($e_code==3) {
        print "#CLUSTER_ID=$opt0\n";
        print "#STATUS2=Retry count over($main::DOMCLUST_RETRY_COUNT). Can not exec domclust.\n";
    }
	elsif($e_code==4) {
		print "#STATUS2=Too many species are selected.(Select:$opt0, MAX:$opt1)\n";
	}
	elsif($e_code==90) {
		print "#STATUS2=$opt0\n";
	}
	elsif($e_code==-99) {
		print "#STATUS2=domclust execution failed. -deleteID=(clusterID) : delete designated clusterID.\n";
	}
	else {
		print "#STATUS2=domclust execution failed.\n";
	}
}

sub showWarnings {
	my $self = shift;
	my $db = shift;
	my $id = shift;

	my $cgi = new CGI;
    $self->outputHeader($cgi);

	my $info = $self->clusterIDtoInfo($db,$id);
	my $counter = $self->getCounter($db,$id);
	my @title_List  = $self->createHeaderList($info, 'getWarnings', $db);
	foreach my $t (@title_List) {
        print "$t\n";
        print "<br>\n";
    }

	my $warn = $self->getWarnings($db, $id);
	if($warn) {
		print "<br>\n";
		print "$warn";
		print "<br>\n";
	} else {
		print "<br>\n";
		print "no warning.<br>\n";
	}
    print $cgi->end_html();
}

sub showWarnings_txt {
	my $self = shift;
	my $db = shift;
	my $id = shift;

	print header(-type => 'text/plain');
	my $info = $self->clusterIDtoInfo($db,$id);
	my @title_List  = $self->createHeaderList($info, 'getWarnings',$db);
	foreach my $l (@title_List) {
		print "$l\n";
	}
	my $warn = $self->getWarnings($db, $id);
	if($warn) {
		print "\n$warn\n";
	} else {
		print "\nno warning.\n";
	}
}

# $B%F!<%V%k(BID$B$KBP1~$9$k$b$N$O<B9TCf$G$"$k(B
# $B%+%&%s%?!<$,(B1$B0J>e$N>l9g$O%j%H%i%$Cf$G$"$k!#(B
sub runTabID {
	my $self = shift;
	my $db = shift;
	my $id = shift;
	my $output_type = shift;

	my $cgi = new CGI;
	$self->outputHeader($cgi);

	my $info = $self->clusterIDtoInfo($db,$id);
	my $counter = $self->getCounter($db,$id);
	my @list;
	if($counter > 1) {
		@list = $self->createHeaderList($info,'retrying',$db);
	} else {
		@list = $self->createHeaderList($info,'running',$db);
	}
	foreach my $l (@list) {
        print "$l\n";
		print "<br>\n";
    }

	print $cgi->end_html();
} 

# $B%F!<%V%k(BID$B$KBP1~$9$k$b$N$O<B9TCf$G$"$k(B
# $B%+%&%s%?!<$,(B1$B0J>e$N>l9g$O%j%H%i%$Cf$G$"$k!#(B
sub runTabID_txt {
	my $self = shift;
	my $db = shift;
    my $id = shift;
    my $output_type = shift;

	print header(-type => 'text/plain');

	my $info = $self->clusterIDtoInfo($db,$id);
	my $counter = $self->getCounter($db,$id);
    my @list;
    if($counter > 1) {
		@list = $self->createHeaderList($info,'retrying',$db);
	} else {
		@list = $self->createHeaderList($info,'running',$db);
	}
    foreach my $l (@list) {
        print "$l\n";
    }
}

# clusterID$B$+$i%+%&%s%?!<$r<hF@$9$k(B
sub getCounter {
	my $self = shift;
	my $db = shift;
	my $id = shift;
	my $counter;


	my $sql = "select counter from $main::TBL_DOMINDEX where clusterID=\"$id\"";
	my $dbh = $db->execute($sql);
	if($dbh) {
		$counter = $dbh->fetch->[0];
	} else {
		print STDERR "Can't get cmd column : $sql";
        DomClustCommon::printErrMsgExit($DomClustCommon::ERRNO_DB_ACCESS, $id);
    }

	return $counter;
}

# clusterID$B$+$i(Binfo$B$r<hF@$9$k(B
sub clusterIDtoInfo {
	my $self = shift;
	my $db = shift;
    my $id = shift;

    #
	my $info = main::getHeaderInfo($db, $id);
	$info->{'clusterID'}=$id;

    #
    my $cmd = '';
    my $cdate = '';
    my $sql = "select * from $main::TBL_DOMINDEX";
    my $dbh = $db->execute($sql);
	while(my$ref = $dbh->fetchrow_hashref()) {
        if ($ref->{'clusterID'} eq $id) {
            $cmd = $ref->{'cmd'};
            $cdate = $ref->{'cdate'};
            last;
        }
	}

    if ($cmd eq '') {
		print STDERR "Can't get cmd column [$id]: $sql";
		return $info;
    }

    my @specs;
    if($cmd =~ /-SPEC=(\S+)/) {
        @specs = split/,/,$1;
    }

	my @outs;
    if($cmd =~ /-Ooutgroup=(\S+)/) {
        @outs = split/,/,$1;
    }

	my @ins;
    if(scalar(@outs) > 0) {
        foreach my $sp (@specs) {
            my $flag = 0;
            foreach my $o (@outs) {
                if($sp eq $o) {
                    $flag++;
                    last;
                }
            }
            if(!$flag) {
                push(@ins, $sp);
            }
        }
    } else {
        @ins = @specs;
    }

	$info->{'ingroup'}=\@ins;
	$info->{'outgroup'}=\@outs;
	$info->{'spec'}=\@specs;
	$info->{'cdate'}=$cdate;
	
	return $info;
}

# HTML$B$K7k2L$r=PNO$9$k(B
sub write_html {
	my $self = shift;
	my $db = shift;
	my $output_type = shift;
	my $id = shift;
	my $info = shift;
	my $mode_get_status = shift;

	my $igrp = $info->{'ingroup'};
	my $ogrp = $info->{'outgroup'};

	my $cgi = new CGI;
	$self->outputHeader($cgi);
	my @title_List  = $self->createHeaderList($info, 'finished',$db, 'html');
    if (!$mode_get_status) {
        push(@title_List, '#START_DATA');
    }
    foreach my $t (@title_List) {
        print "$t\n";
		print "<br>\n";
	}

    if ($mode_get_status) {
      	print $cgi->end_html();
        return;
    }

	print $cgi->start_table({-border => 1});
	# $B%F!<%V%k%X%C%@$r=PNO$9$k!#(B
	# $B!&(Boutgroup $B$,B8:_$9$k>l9g(B
	if(scalar(@$ogrp) > 0) {
        my($cols_ref) = [];

        push(@{$cols_ref},  'HomCluster ID',
                            'Super Cluster ID',
                            'Super Cluster Gene',
                            'Super Cluster Func(mbgd)',
                            'Super Cluster Func(cog)',
                            'Super Cluster Func(kegg)',
                            'Super Cluster Func(tigr)',
                            'Super Cluster Descr',
                            'Cluster ID',
                            'Cluster Gene',
                            'Cluster Func(mbgd)',
                            'Cluster Func(cog)',
                            'Cluster Func(kegg)',
                            'Cluster Func(tigr)',
                            'Cluster Descr',
                            );

        foreach my$sp (@{$igrp}) {
            push(@{$cols_ref}, "$sp(I)");
        }
        foreach my$sp (@{$ogrp}) {
            push(@{$cols_ref}, "$sp(I)");
            push(@{$cols_ref}, "$sp(O)");
        }

        $attr_ref = {};
        $attr_ref->{'-align'}  = 'center';
        $attr_ref->{'-valign'} = 'middle';
        print $cgi->Tr($attr_ref, th({}, $cols_ref));
		print "\n";
    }
	# $B!&(Boutgroup $B$,B8:_$7$J$$>l9g(B
    else {
        print $cgi->Tr({-align => 'center', -valign => 'middle'},
                       th({}, [ 'HomCluster ID',
                                'Cluster ID',
                                'Cluster Gene',
                                'Cluster Func(mbgd)',
                                'Cluster Func(cog)',
                                'Cluster Func(kegg)',
                                'Cluster Func(tigr)',
                                'Cluster Descr',
							   @$igrp]));
		print "\n";
    }

#---------------------------------------$B%X%C%@=*N;(B
    # $B%/%i%9%?!"%5%V%/%i%9%?Kh$K%j%9%H$r=PNO$9$k!#(B
    my $tablegene = $main::TBL_DOMRESULT . "_" . $id;
    my $tablefunc = $main::TBL_DOMFUNC . "_" . $id;
    my $sql = "select * from $tablefunc";

	my $dbh = $db->execute($sql);
    my $name_gene;
    my $name_func;

    while(my $line = $dbh->fetch()) {
        my($hcid, $cid, $sid, $phylopat, $spnum, $orfnum,
           $cgene, $cfunc, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr,
           $sgene, $sfunc, $sfuncCog, $sfuncKegg, $sfuncTigr, $sdescr, $data) = @$line;

        my(@trlist);

        my(@sporf_list) = split("\t", $data);
        foreach my$sporf (@sporf_list) {
            my(@orf_list) = split(/\s/, $sporf);
            push(@trlist, join(br, @orf_list));
        }

        # $B=PNO(B
        if(scalar(@$ogrp) > 0) {
			print $cgi->Tr({-align => 'center', -valign => 'top'},
                     td({}, [$hcid, $cid, $cgene, $cfunc, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr]),
                     td({}, [$sid, $sgene, $sfunc, $sfuncCog, $sfuncKegg, $sfuncTigr, $sdescr, @trlist]),
                     ($i == 0 && scalar(@$ogrp > 0) ? td({}, [@outgrp]) : undef));
		} else {
			print $cgi->Tr({-align => 'center', -valign => 'top'},
						   td({}, [$hcid, $cid, $cgene, $cfunc, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr, @trlist]));
		}
		print "\n";
    }
    print $cgi->end_table;
    print "\n";
	print $cgi->end_html();
}

# $B%F%-%9%H$K7k2L$r=PNO$9$k(B
sub write_text {
	my $self = shift;
	my $db = shift;
	my $output_type = shift; 
	my $id = shift;
	my $info = shift;
	my $mode_get_status = shift;

	print header(-type => 'text/plain');

	my $igrp = $info->{'ingroup'};
	my $ogrp = $info->{'outgroup'};

	my @hList = $self->createHeaderList($info,'finished',$db, 'text');
    if (!$mode_get_status) {
        push(@hList, '#START_DATA');
    }
    foreach my $l (@hList) {
        print "$l\n";
    }
    #---------------------------------------$B%X%C%@=*N;(B

    if ($mode_get_status) {
        return;
    }

    # $B%/%i%9%?!"%5%V%/%i%9%?Kh$K%j%9%H$r=PNO$9$k!#(B
    my $tablegene = $main::TBL_DOMRESULT . "_" . $id;
    my $tablefunc = $main::TBL_DOMFUNC . "_" . $id;
    my $sql = "select * from $tablefunc";

	my $dbh = $db->execute($sql);

    my $name_gene;
    my $name_func;

    while(my $line = $dbh->fetch()) {
        my($hcid, $cid, $sid, $phylopat, $spnum, $orfnum,
           $cgene, $cfunc, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr,
           $sgene, $sfunc, $sfuncCog, $sfuncKegg, $sfuncTigr, $sdescr, $data) = @$line;

		if(scalar(@$ogrp) > 0) {
			print join("\t", $hcid, $cid, $cgene, $cfunc, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr, $sid, $sgene, $sfunc, $sfuncCog, $sfuncKegg, $sfuncTigr, $sdescr);
		} else {
			print join("\t", $hcid, $cid, $cgene, $cfunc, $cfuncCog, $cfuncKegg, $cfuncTigr, $cdescr);
		}

        # ORF$BL>$N<hF@(B
        print "\t";
        print $data;
        print "\n";

    }
}

# $B%F%-%9%H$K7k2L$r=PNO$9$k(B
sub write_list {
	my $self = shift;
	my $db = shift;
	my $output_type = shift; 
	my $id = shift;
	my $info = shift;
	my $mode_get_status = shift;

	print header(-type => 'text/plain');

	my $igrp = $info->{'ingroup'};
	my $ogrp = $info->{'outgroup'};

	my @hList = $self->createHeaderList($info,'finished',$db, 'list');
    if (!$mode_get_status) {
        push(@hList, '#START_DATA');
    }
    foreach my $l (@hList) {
        print "$l\n";
    }
    #---------------------------------------$B%X%C%@=*N;(B

    if ($mode_get_status) {
        return;
    }

    #
    my($cols);
    my($sql);
    my($dbh);

    #
    my $tablefunc = $main::TBL_DOMFUNC . "_" . $id;
    $cols = join(',', 'homclustid', 'clustid', 'subclustid',
                      'cgene', 'cmbgd', 'ccog', 'ckegg', 'ctigr', 'cdescr',
                      'sgene', 'smbgd', 'scog', 'skegg', 'stigr', 'sdescr');
    $sql = "select $cols from $tablefunc";
    $dbh = $db->execute($sql);
    while(my$ref = $dbh->fetchrow_hashref()) {
        my($clustid)    = $ref->{'clustid'};
        my($subclustid) = $ref->{'subclustid'};

        $clust_func_ref->{"$clustid"}->{"$subclustid"} = $ref;
    }

    #
    my $tablescore = $main::TBL_DOMSCORE . "_" . $id;
    if ($db->exist_table($tablescore)) {
        $sql = "select * from $tablescore";
        $dbh = $db->execute($sql);
        while(my$ref = $dbh->fetchrow_hashref()) {
            my($hid) = $ref->{'homclustid'};
            my($cid) = $ref->{'clustid'};
            my($sid) = $ref->{'subclustid'};
            my($s)   = $ref->{'score'};
            my($d)   = $ref->{'dist'};

            if ($hid && !$cid && !$sid) {
                $score_ref->{'HOMCLUST'}->{"$hid"}->{'SCORE'} = $s;
                $score_ref->{'HOMCLUST'}->{"$hid"}->{'DIST'}  = $d;
            }
            elsif ($cid && !$sid) {
                $score_ref->{'CLUST'}->{"$cid"}->{'SCORE'} = $s;
                $score_ref->{'CLUST'}->{"$cid"}->{'DIST'}  = $d;
            }
            elsif ($sid) {
                $score_ref->{'SUBCLUST'}->{"$cid"}->{"$sid"}->{'SCORE'} = $s;
                $score_ref->{'SUBCLUST'}->{"$cid"}->{"$sid"}->{'DIST'}  = $d;
            }
            else {
            }
        }
    }

    #
    my $tabledom = $main::TBL_DOMCACHE . "_" . $id;
    my $sql = "select *, subclustid=0 as og from $tabledom order by homclustid, clustid, og, subclustid, sp";
	my $dbh = $db->execute($sql);

    my($prev_homclustid) =  0;
    my($prev_clustid);
    my($prev_subclustid) = -1;
    while(my$ref = $dbh->fetchrow_hashref()) {
        my($homclustid) = $ref->{'homclustid'};
        my($clustid)    = $ref->{'clustid'};
        my($subclustid) = $ref->{'subclustid'};

        if ((0 < $homclustid) && ($homclustid != $prev_homclustid)) {
            print '/' x 6 . "\n" if (0 <= $prev_homclustid);
            print "HomCluster $homclustid\n";
            my($hscore) = $score_ref->{'HOMCLUST'}->{"$homclustid"}->{'SCORE'};
            my($hdist)  = $score_ref->{'HOMCLUST'}->{"$homclustid"}->{'DIST'};
            print '#HCScore',   "\t", $hscore,     "\n" if ($hscore ne '');
            print '#HCDist',    "\t", $hdist,      "\n" if ($hdist  ne '');

            $prev_homclustid = $homclustid;
            $prev_clustid = -1;
        }

        if ($clustid != $prev_clustid) {
            print '/' x 4 . "\n" if (0 <= $prev_clustid);

            my($func_ref) = $clust_func_ref->{"$clustid"}->{"$subclustid"};
            print "Cluster $clustid\n";
            my($cscore) = $score_ref->{'CLUST'}->{"$clustid"}->{'SCORE'};
            my($cdist)  = $score_ref->{'CLUST'}->{"$clustid"}->{'DIST'};
            print '#CScore', "\t", $cscore,     "\n" if ($cscore ne '');
            print '#CDist',  "\t", $cdist,      "\n" if ($cdist  ne '');


            print '#CGene',     "\t",  $func_ref->{'cgene'},  "\n";
            print '#CFuncMbgd', "\t",  $func_ref->{'cmbgd'},  "\n";
            print '#CFuncCog',  "\t",  $func_ref->{'ccog'},   "\n";
            print '#CFuncKegg', "\t",  $func_ref->{'ckegg'},  "\n";
            print '#CFuncTigr', "\t",  $func_ref->{'ctigr'},  "\n";
            print '#CDescr',    "\t",  $func_ref->{'cdescr'}, "\n";

            $prev_clustid = $clustid;
            $prev_subclustid = -1;
        }

        if (0 < scalar(@$ogrp)) {
            if ($subclustid != $prev_subclustid) {
                print '/' x 2 . "\n" if (0 <= $prev_subclustid);
                if ($subclustid != 0) {
                    my($func_ref) = $clust_func_ref->{"$clustid"}->{"$subclustid"};
                    print "SubCluster $subclustid\n";
                    my($sscore) = $score_ref->{'SUBCLUST'}->{"$clustid"}->{"$subclustid"}->{'SCORE'};
                    my($sdist)  = $score_ref->{'SUBCLUST'}->{"$clustid"}->{"$subclustid"}->{'DIST'};
                    print '#SCScore',    "\t", $sscore,     "\n" if ($sscore ne '');
                    print '#SCDist',     "\t", $sdist,      "\n" if ($sdist  ne '');
                    print '#SCGene',     "\t", $func_ref->{'sgene'},  "\n";
                    print '#SCFuncMbgd', "\t", $func_ref->{'smbgd'},  "\n";
                    print '#SCFuncCog',  "\t", $func_ref->{'scog'},   "\n";
                    print '#SCFuncKegg', "\t", $func_ref->{'skegg'},  "\n";
                    print '#SCFuncTigr', "\t", $func_ref->{'stigr'},  "\n";
                    print '#SCDescr',    "\t", $func_ref->{'sdescr'}, "\n";
                }
                else {
                    print "OutGroup\n";
                }
                $prev_subclustid = $subclustid;
            }
        }

        print join("\t", $ref->{'spname'}, $ref->{'dom'}, $ref->{'from1'}, $ref->{'to1'}, $ref->{'outer_flag'}), "\n";

    }
    print '/' x 4;
    if ($prev_homclustid != 0) {
        print '/' x 2;
    }
    print "\n";

    return;
}

# $B%F%-%9%H$K7k2L$r=PNO$9$k(B
sub write_o11 {
	my $self = shift;
	my $db = shift;
	my $output_type = shift; 
	my $id = shift;
	my $info = shift;
	my $mode_get_status = shift;

	print header(-type => 'text/plain');

	my $igrp = $info->{'ingroup'};
	my $ogrp = $info->{'outgroup'};

	my @hList = $self->createHeaderList($info,'finished',$db, 'list');
    if (!$mode_get_status) {
        push(@hList, '#START_DATA');
    }
    foreach my $l (@hList) {
        print "$l\n";
    }
    #---------------------------------------$B%X%C%@=*N;(B

    if ($mode_get_status) {
        return;
    }

    #
    my($file_domclust_o11) = "$ENV{'RECOG_HOME'}/MBGD.tmp/tmp_dom_res_$id.o11";
    my($cmd) = "$main::CMD_cat $file_domclust_o11";
    system("$cmd");

    return;
}

# $B%X%C%@!<$N=PNO(B
sub outputHeader {
	my $self = shift;
	my $cgi = shift;

	my $charsets  = {'euc' => 'EUC-JP', 'jis' => 'ISO-2022-JP', 'sjis' => 'Shift_JIS', 'utf8' => 'UTF-8'};
    my $charset   = $charsets->{$self->{'CODE'}} ? $charsets->{$self->{'CODE'}} : undef;
    my $lang      = $charsets->{$self->{'CODE'}} ? 'ja-JP' : 'en-US';

    print $cgi->header(-charset => $charset);
	print "\n";
    print $cgi->start_html(-title=>"DomClust Test",
                            -charset=>$charset,
                            -encoding=>$charset,
						   -lang=>$lang);
	print "\n";


}

sub createHeaderList {
	my $self = shift;
	my $info = shift;
	my $status = shift;
	my $db = shift;
	my $output_format = shift;

	my @list;

    if (!exists($info->{'spec'})) {
        push(@list, sprintf("#CLUSTER_ID=%s", $info->{'clusterID'}));
        push(@list, sprintf("#STATUS=%s", 'ERROR'));
        push(@list, "#STATUS2=Can not found Cluster-ID.");
        return @list;
    }

	my $igrp = $info->{'ingroup'};
    my $ogrp = $info->{'outgroup'};
    my $sp   = $info->{'spec'};

    #
    my(@col_name_list);
    if(@$ogrp && $status eq 'finished') {
        push(@col_name_list, 'HCID');
        push(@col_name_list, 'SCID');
        push(@col_name_list, 'SCGene');
        push(@col_name_list, 'SCFuncMbgd');
        push(@col_name_list, 'SCFuncCog');
        push(@col_name_list, 'SCFuncKegg');
        push(@col_name_list, 'SCFuncTigr');
        push(@col_name_list, 'SCDescr');
        push(@col_name_list, 'CID');
        push(@col_name_list, 'CGene');
        push(@col_name_list, 'CFuncMbgd');
        push(@col_name_list, 'CFuncCog');
        push(@col_name_list, 'CFuncKegg');
        push(@col_name_list, 'CFuncTigr');
        push(@col_name_list, 'CDescr');
    }
    elsif(@$igrp && $status eq 'finished') {
        push(@col_name_list, 'HCID');
        push(@col_name_list, 'CID');
        push(@col_name_list, 'CGene');
        push(@col_name_list, 'CFuncMbgd');
        push(@col_name_list, 'CFuncCog');
        push(@col_name_list, 'CFuncKegg');
        push(@col_name_list, 'CFuncTigr');
        push(@col_name_list, 'CDescr');
	}

	my $n_fields;
    if(@$ogrp) {
        $n_fields = scalar(@$sp);
    }
    elsif(@$igrp) {
        $n_fields = scalar(@$sp);
    }
    $n_fields += scalar(@col_name_list);

	my $n_sp;
    if(@$sp) {
        $n_sp =  scalar(@$sp);
    }

	push(@list, sprintf("#FORMAT_VER=%s" , $DomClustCommon::VER_DATA_FORMAT));

    if($status eq 'finished') {
        push(@list, sprintf("#N_FIELDS=%s", $n_fields));
    }
    push(@list, sprintf("#N_SPECIES=%s", $n_sp));
	push(@list, sprintf("#SPECIES=%s", join(",",@$sp)));
    push(@list, sprintf("#INGROUP=%s", join(",", @$igrp)));

    if(@$ogrp) {
        push(@list, sprintf("#OUTGROUP=%s", join(",", @$ogrp)));
    }

    if ($output_format !~ /^list$/i) {
        my($i) = 1;
        foreach my$col_name (@col_name_list) {
            my($txt) = sprintf("#COLUMN_%02d=%s", $i, $col_name);
            push(@list, $txt);
            $i++;
        }
    }

    #
    my $cluster_id = $info->{'clusterID'};
    push(@list, sprintf("#CLUSTER_ID=%s", $cluster_id));
    push(@list, sprintf("#STATUS=%s", $status));

    if($status eq 'finished') {
        # $B$b$7%+%i%`$K(Bwarning$B$,B8:_$7$?>l9g!"(B
        if($self->getWarnings($db, $cluster_id)) {
            push(@list, "#STATUS2=warning");
		}
        push(@list, sprintf("#N_CLUSTERS=%s", $info->{'clusternum'}));

        my($http_host_ref) = RECOG::RecogCommon::get_http_host();
        push(@list, sprintf("#EXEC_SERVER=%s", $http_host_ref->{'NAME'}));
        push(@list, sprintf("#EXEC_PORT=%s",   $http_host_ref->{'PORT'}));
        push(@list, sprintf("#EXEC_DATE=%s",   $info->{'cdate'}));
#        push(@list, "#START_DATA");
    } elsif(($status eq 'running') || ($status eq 'retrying')) {
		# $B?JD=>u67$r<hF@(B
		my @prog = $self->getProgress($db, $cluster_id);
		if(@prog) {
			@list = (@list,@prog);
		}
	}

    return @list;
}

# warning$B$r<hF@$9$k(B
sub getWarnings {
	my($self) = shift;
    my($db) = shift;
    my($cid) = shift;

    if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "select warning from $main::TBL_DOMINDEX where clusterID=\'$cid\'";
        my $st = $db->execute($sql);
        if($st) {
            return $st->fetch()->[0];
        }
    }
}

sub getProgress {
	my $self = shift;
	my $db = shift;
	my $id = shift;

	@result;

	my $stdoutfile = $main::DOMCLUST_TMP_DIR . "/". $main::PREF_DOMCLUST_PROG . "_" . $id;
	if(! -e $stdoutfile) {
		return;
	}
	my $cmd = "cat $stdoutfile > /dev/null; tail -n 30 $stdoutfile";
	my $line = `$cmd`;

	# $B:G?7%9%F!<%?%9$r<hF@(B
	my $stat="reading";
	my $val =0;
	foreach my $l (split/\n/,$line) {

		if($l=~/([\w_]+)\s+(\d+)/) {
			$stat = $1;
			$val  = $2;
		} elsif($l=~/Sorting/) {
			$stat = "sorting";
		}
	}
	push(@result, sprintf("#STATUS2=%s", $stat));
	
	# $B3F%9%F!<%?%9$N?JD=>u67$r7W;;$9$k(B
	# gene$B?t$N<hF@(B
	my $sql = "select ngene from $main::TBL_DOMINDEX where clusterID=\'$id\'";
	my $st = $db->execute($sql);
	my $ngene = $st->fetch()->[0];
	my $per;
	if($stat eq 'reading') {
		# homology = Ngene^2/2000
		$per = int($val/($ngene**2/2000)*100);
		if($per > $main::PROGRESS_MAX_VALUE) {
			$per = $main::PROGRESS_MAX_VALUE;
		}
		push(@result, sprintf("#PROGRESS=%d", $per));
	}
	elsif($stat eq 'sorting') {
		# $B7P2a$rI=<($G$-$J$$$N$G2?$b$7$J$$!#(B
        push(@result, sprintf("#PROGRESS=%d", 50));
	}
	elsif($stat eq 'indexing') {
		$per = int($val/($ngene**2/2000)*100);
        if($per > $main::PROGRESS_MAX_VALUE) {
            $per = $main::PROGRESS_MAX_VALUE;
        }
        push(@result, sprintf("#PROGRESS=%d", $per));
    }
	elsif($stat eq 'clustering') {
		# gene$B$r=hM}$7$??t(B/Ngene
		$per = int ($val/$ngene * 100);
        $per = 99 if (100 <= $per);
		push(@result, sprintf("#PROGRESS=%d", $per));
    }
	elsif($stat eq 'Retrieving') {
        $per = $val;
        $per = 99 if (100 <= $per);
        push(@result, sprintf("#PROGRESS=%d", $per));
	} elsif($stat eq 'create_result_table') {
		# $B=hM}$7$?(Bcluster$B$N?t(B/$BA4(Bcluster$B?t(B
		my $sql = "select ncluster from $main::TBL_DOMINDEX where clusterID=\'$id\'";
		my $st = $db->execute($sql);
		my $nclust = $st->fetch()->[0];
		$per = int ($val/$nclust * 100);
        $per = 99 if (100 <= $per);
		push(@result, sprintf("#PROGRESS=%d", $per));
	}
	return @result;
} 

sub retryDomclust {
	my $self = shift;
	my $db = shift;
	my $id = shift;
	my $output_type = shift;

	my $cgi = new CGI;
	$self->outputHeader($cgi);

	my $info = $self->clusterIDtoInfo($db,$id);
	my @list = $self->createHeaderList($info,'retry',$db, $output_type);
	foreach my $l (@list) {
		print "$l\n";
		print "<br>\n";
	}
	
	print $cgi->end_html();
}

sub retryDomclust_txt {
	my $self = shift;
	my $db = shift;
	my $id = shift;
	my $output_type = shift;

	print header(-type => 'text/plain');

	my $info = $self->clusterIDtoInfo($db,$id);
	my @list = $self->createHeaderList($info,'retry',$db, $output_type);

	foreach my $l (@list) {
		print "$l\n";
	}
}

# ORF$B%j%9%H$NI=<(J}K!$rJQ99$9$k(B
sub transform {
    my $self   = shift;
    my $type = shift;
    my @orfs   = @_;

    if($type eq 'complete') {
        map { s/^[^:]+:// } @orfs;  # ORF$BL>@hF,$N@8J*<oL>$r=|30$9$k(B
        @orfs;
    }
    elsif($type eq 'count') {
        scalar(@orfs);
    }
#    elsif($type eq 'phylopat') {
    else {
        (scalar(@orfs) ? 1 : 0);
    }
}

sub transform_sort {
    my $self = shift;
    my $data = shift;

    my $sortlist = {};
    foreach my $d (@$data) {
        if($d =~ /^([^:]+):\S+/) {
            $sortlist->{$1}->{$d}++;
        }
        else {
            next;
        }
    }
    return $sortlist;
}

#
1;#
#
