package RECOG_PROJECTS::Schema::ProjectAnalysis;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("project_analysis");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "project_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "analysis_type",
  {
    data_type => "VARCHAR",
    default_value => "domclust",
    is_nullable => 0,
    size => 20,
  },
  "analysis_id",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 40,
  },
  "analysis_name",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 40,
  },
  "analysis_date",
  {
    data_type => "DATETIME",
    default_value => undef,
    is_nullable => 0,
    size => 19,
  },
  "member_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint(
  "project_analysis_uniq_analysis",
  ["analysis_type", "analysis_id"],
);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-25 13:54:37
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:CDlQR/uTN991oVPskVP3nA

__PACKAGE__->belongs_to (
    project => 'RECOG_PROJECTS::Schema::Project', {
        'foreign.id' => 'self.project_id'
    }
);

__PACKAGE__->belongs_to (
    analysis_user => 'RECOG_PROJECTS::Schema::Member', {
        'foreign.id' => 'self.member_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
