#!/usr/local/bin/perl -s

###############################################################################
use FileHandle;
require "MBGD_Conf.pl";

BEGIN {
    # ʣ htblast ¹Ԥ줿硢
    # 롼ե̾ˡˤʤ褦ˤ뤿
    $HTBLASTSEQ = 0;
}

###############################################################################
#
sub execFormatdb {
    my($fileDb, $opt) = @_;
    my($cmd);

    $cmd = "$main::CMD_formatdb -i $fileDb $opt";
    system("$cmd");
}

###############################################################################
#
sub makeHtblastRule {
    my($prog, $db, $opt, $fileRule) = @_;
    my($fh);

    if (! $fileRule) {
        # rule ե̾
        $fileRule = "$main::DIR_work/htblast-rule.$$-$HTBLASTSEQ";
        $HTBLASTSEQ++;
    }

    $fh = new FileHandle("> $fileRule") || die "Can not open $fileRule($!)";
    $fh->print("-p $prog -d \"$db\" $opt\n");
    $fh->close();

    return $fileRule;
}

###############################################################################
#
sub execHtblast {
    my($fileRule, $fileQry, $pipeCmd, $fileOut) = @_;
    my($blocksize);
    my($seqCount);
    my(@dbList);
    my($fh);

    # query 򥫥
    $fh = new FileHandle("$fileQry") || die "Can not open $fileQry($!)";
    $seqCount = 0;
    while(<$fh>) {
        if (/^>/) {
            $seqCount++;
        }
    }
    $fh->close();

    # htblast  blocksize ׻
    $blocksize = int($seqCount / $NUM_cpu);
    if ($blocksize <= 0) {
        $blocksize = 1;
    }
    elsif (20 < $blocks) {
        # ޤ礭ʤʤ褦ˤʥǥեȤۤʤ褦ˤ
        $blocksize = 20;
    }

    #
    $cmd = "$CMD_htblast -stdout -workdir=$DIR_work $fileQry $fileRule $blocksize";
    if ($main::BLAST_HOST) {
        $cmd = "$CMD_rsh $main::BLAST_HOST '$cmd'";
    }

    #
    if ($pipeCmd) {
        $cmd = "$cmd | $pipeCmd";
    }

    print STDERR "Exec :: $cmd\n";
    system("$cmd > $fileOut");

    return 0;
}

###############################################################################
if ($0 eq __FILE__) {
    # ޥɤȤƵư줿

    my($res);

    die "Error : DB-file" if ($ARGV[0] eq "");
    die "Error : Query-file" if ($ARGV[1] eq "");

    $res = &execHtblast($ARGV[0], $ARGV[1]);
    print $res;

    exit;
}


###############################################################################
1;#;
###############################################################################
