#!/usr/local/bin/perl -s

use Property::HomolParam;
require "MBGD_Conf.pl";
use File::Basename;
package main;
###############################################################################
#sub domclustOpt
#{
#    my($score, $pam, $missdist, $phylocut, $clustType) = @_;
#    my($opt);
#
#    if ($clustType =~ /score/i) {
#        $opt = "-o1 -S -c$score";
#    }
#    else {
#        $opt = "-o1";
#        $opt .= " -c$pam" if ($pam);
#    }
#
#    $opt .= " -m$missdist";
#
#    $opt .= " -p$phylocut" if ($phylocut !~ /^\s*$/);
#
#    return($opt);
#}
###############################################################################

###############################################################################
# Command line written in the output
###############################################################################
sub execClustOptInfo
{
    my($CMD_SELECT, $CMD_CLUST, $CMD_ADDINFO, $CMD_SORT, $species) = @_;
    my($clstCmdInfo);
    my($clstSortCmdInfo);
    my($bindir) = "$main::DIR_www/bin";
if (0) {
    if ($ENV{'MBGD_TEST'}) {
        if (! $DIR_mbgdhome_curr) {
            $DIR_mbgdhome_curr = dirname($DIR_mbgdhome);
        }
        if (-d "$DIR_mbgdhome_curr/WWW") {
            $CMD_SELECT =~ s/$DIR_mbgdhome/$DIR_mbgdhome_curr/g;
            $CMD_CLUST =~ s/$DIR_mbgdhome/$DIR_mbgdhome_curr/g;
            $CMD_ADDINFO =~ s/$DIR_mbgdhome/$DIR_mbgdhome_curr/g;
            $CMD_SORT =~ s/$DIR_mbgdhome/$DIR_mbgdhome_curr/g;
            $bindir = "$main::DIR_mbgdhome_curr/WWW/bin";
        }
    }
print STDERR "CURR: $DIR_mbgdhome_curr\n";
}

    $clstCmdInfo = '';
    $clstCmdInfo .= "$CMD_SELECT";
    if ($CMD_CLUST) {
	    $clstCmdInfo .= "| $CMD_CLUST";
	    $clstCmdInfo .= "| $bindir/clusttree2flat.pl";
	    $clstCmdInfo .= "| $bindir/convClustFile.pl -SPEC='$species'";
    }
    $clstSortCmdInfo = '';
    $clstSortCmdInfo .= "$CMD_ADDINFO" if ($CMD_ADDINFO);
    $clstSortCmdInfo .= "| $CMD_SORT"  if ($CMD_SORT);

    return($clstCmdInfo, $clstSortCmdInfo);
}

###############################################################################
# Command line acutually executed
###############################################################################
sub execClustOpt
{
    my($CMD_SELECT, $CMD_CLUST, $CMD_ADDINFO, $CMD_SORT, $species) = @_;
    my($clstCmd1);
    my($clstCmd2);
    my($clstSortCmd);

    $clstCmd1 = '';
    $clstCmd1 .= "$CMD_SELECT";
    if ($CMD_CLUST) {
    	$clstCmd1 .= "| $CMD_CLUST";
    }

    # ʳ($clstCmd1  $clstCmd2 δ)ǡ
    # 饹ʤ ORF  (1) 

    $clstCmd2 = '';
    $clstCmd2 .= "$main::DIR_www/bin/clusttree2flat.pl";
    $clstCmd2 .= "| $main::DIR_www/bin/convClustFile.pl -SPEC='$species'";
##    $clstCmd2 .= "| $main::CMD_tee -a $tmp_clustFile";  # 饹󥰷(Flat)
    $clstSortCmd = '';
    $clstSortCmd .= "$CMD_ADDINFO" if ($CMD_ADDINFO);
    $clstSortCmd .= "| $CMD_SORT"  if ($CMD_SORT);

    return($clstCmd1, $clstCmd2, $clstSortCmd);
}

###############################################################################
###
### CURRENT VERSION
sub getCmdSelect
{
    my($spec, $homparam, $otheropt, $notabout) = @_;

    my $opt = $homparam->getOption_select();
    my $tabout = " -tabout" if (! $notabout);  ### output taball.domclust before homology data
    my $opt_dir_bldp = sprintf("-DIR=%s/bldp", $main::DIR_database);
    my $optUserGenome = '';
    if ($ENV{'MBGD_UID'}) {
        my($uid) = $ENV{'MBGD_UID'};
        if (MbgdUserGenomeCommon::isContainUserGenome($uid) &&
            MbgdUserGenomeCommon::isReadyUserGenome($uid)) {
            my($dirUgDb) = MbgdUserGenomeCommon::getDirUserGenomeDatabase($uid);
            $opt_dir_bldp = sprintf("-DIR=%s/bldp", $dirUgDb);
            if (! $notabout) {
                $tabout = sprintf(" -tabout=%s/taball", $dirUgDb);
            }
            my($dbname) = MbgdUserGenomeCommon::getDbname($uid);
            $optUserGenome .= " -dbname=$dbname";
        }
    }

    my $cmd = "$main::CMD_select $opt_dir_bldp $opt $otheropt $tabout";
    $cmd .= " $optUserGenome " if ($optUserGenome);
    $cmd =~ s/  */ /g;
    return($cmd);
}
sub getCmdClust
{
    my($homparam, $tabfile, $userOpt, $uInfo) = @_;

    my $opt = $homparam->getOption_domclust($uInfo);
    my $cmd = "$main::CMD_domclust stdin $tabfile $opt $userOpt";
    $cmd =~ s/  */ /g;

    return($cmd);
}

###############################################################################
#
sub parseDomClustOptions {
    my($cmd) = @_;
    my(@cmds)= split(/\s*\|\s*/, $cmd);
    foreach $cm (@cmds) {
        ($cmdname, $options) = split(/\s+/, $cm, 2);
        if ($cmdname =~ /select/) {
            $options =~ s/-SPEC=\S+//g;
            $options =~ s/\-tabout=*\S*//;
            $options =~ s/\-dbname=\S+//;
            $options =~ s/\-DIR=\S+//;
            $select_opt = $options;
        } elsif ($cmdname =~ /domclust/) {
            $options =~ s/stdin//;
            $domclust_opt = $options;
        }
    }
    ($select_opt, $domclust_opt);
}

###############################################################################
1;#
###############################################################################
