# ǡ١꡼̤Фʪ̾ѴԤ
# 

package libMBGDOrgConv;
###############################################################################
# Private Data Definition
###############################################################################

# ʪά->̾Τбơ֥
#
%OrgAbbrevToStd = (
##############################################################################
# άΤ̾Τбơ֥ΰ
##############################################################################
		   'hin',    'Haemophilus influenzae',
		   'mja',    'Methanococcus jannaschii',
		   'mge',    'Mycoplasma genitalium',
#		   'cyano',  'Synechocystis sp.',
		   'syn',    'Synechocystis sp.',
#		   'yeast',  'Saccharomyces cerevisiae',
		   'sce',    'Saccharomyces cerevisiae',
		   'eco',    'Escherichia coli',
		   'mpn',    'Mycoplasma pneumoniae',
		   'hpy',    'Helicobacter pylori',
		   'mth',    'Methanobacterium thermoautotrophicum',
		   'bsu',    'Bacillus subtilis',
		   'afu',    'Archaeoglobus fulgidus',
		   'bbu',    'Borrelia burgdorferi',
		   'aae',    'Aquifex aeolicus',
##############################################################################
		   '',       ''
		   );
##############################################################################
# λ
##############################################################################


#
# ʪ̾->άΤбơ֥
#
%OrgStdToAbbrev = ();
foreach $key (keys %OrgAbbrevToStd)
{
    $OrgStdToAbbrev{$OrgAbbrevToStd{$key}} = $key;
}
undef($key);

##############################################################################

# ʪάΤꤷб̾Τ
# input : ʪά
# return: ʪ̾
sub 'Get_OrgStdByAbbrev
{
    my($Abbrev) = @_;
    $OrgAbbrevToStd{$Abbrev};
}

# ʪ̾ΤꤷбάΤ
# input : ʪ̾
# return: ʪά
sub 'Get_OrgAbbrevByStd
{
    my($Std) = @_;
    $OrgStdToAbbrev{$Std};
}

# ꤵ줿ƥʪ̾Τ򤹤٤άΤѴ
# input : ʪ̾Τޤƥ
# return: Ѵƥ
sub 'Conv_OrgStdToAbbrev
{
    my($Text) = @_;
    my($key, $cnt);

    $cnt = 0;
    foreach $key (keys %OrgStdToAbbrev)
    {
	next if($key eq "");
	print "s/$key/$OrgStdToAbbrev{$key}/g\n" if($'DEBUG);
	$cnt = $Text =~ s/$key/$OrgStdToAbbrev{$key}/g;
##	last if($cnt > 0);
    }

    $Text;
}

# ꤵ줿ƥʪάΤ򤹤٤̾ΤѴ
# input : ʪ̾Τޤƥ
# return: Ѵƥ
sub 'Conv_OrgAbbrevToStd
{
#    my($Text, $KeyPrefix, $KeySurfix) = @_;
    my($Text) = @_;
    my($key);

    $cnt = 0;
    foreach $key (keys %OrgAbbrevToStd)
    {
	next if($key eq "");
#	print "s/${KeyPrefix}${key}$KeySurfix/${KeyPresix}$OrgAbbrevToStd{$key}$KeySurfix/g\n" if($'DEBUG);
#	$Text =~ s/${KeyPrefix}${key}$KeySurfix/${KeyPresix}$OrgAbbrevToStd{$key}$KeySurfix/g;
	print "s/$key/$OrgAbbrevToStd{$key}/g\n" if($'DEBUG);
	$Text =~ s/\b$key\b/$OrgAbbrevToStd{$key}/g;
    }

    ##########################################################################
    # ORF̾ʸʸѴ
##    $Text =~ s/:\S+/&upperCase($&)/ge;
    ##########################################################################

   $Text;
}

# IDάΤ̾ΤѴ
# input : ʪάΡIDάΤޤƥ
# return: Ѵƥ
sub 'Conv_SeqAbbrevToStd
{
    my($Org, $Text) = @_;
    my($prefix);
#    if($Org eq 'cyano')
    if($Org eq 'syn')
    {
#	$prefix =  'cya';
	$Text   =~ s/\bCHR\b/cya_main/g;
    }
    elsif($Org eq 'mja')
    {
	$Text =~ s/\bCHR\b/mja_main/g;
	$Text =~ s/\bECL\b/mja_ecl/g;
	$Text =~ s/\bECS\b/mja_ecs/g;
    }
#    elsif($Org eq 'yeast')
    elsif($Org eq 'sce')
    {
	$Text =~ s/\bI\b/yeast_1/g;
	$Text =~ s/\bII\b/yeast_2/g;
	$Text =~ s/\bIII\b/yeast_3/g;
	$Text =~ s/\bIV\b/yeast_4/g;
	$Text =~ s/\bV\b/yeast_5/g;
	$Text =~ s/\bVI\b/yeast_6/g;
	$Text =~ s/\bVII\b/yeast_7/g;
	$Text =~ s/\bVIII\b/yeast_8/g;
	$Text =~ s/\bIX\b/yeast_9/g;
	$Text =~ s/\bX\b/yeast_10/g;
	$Text =~ s/\bXI\b/yeast_11/g;
	$Text =~ s/\bXII\b/yeast_12/g;
	$Text =~ s/\bXIII\b/yeast_13/g;
	$Text =~ s/\bXIV\b/yeast_14/g;
	$Text =~ s/\bXV\b/yeast_15/g;
	$Text =~ s/\bXVI\b/yeast_16/g;
    }
    else
    {
	$prefix =  $Org;
	$Text   =~ s/\bCHR\b/${prefix}_main/g;
    }

    $Text;
}

# ID̾ΤάΤѴ
# input : ʪάΡID̾Τޤƥ
# return: Ѵƥ
sub 'Conv_SeqStdToAbbrev
{
    my($Org, $Text) = @_;

    if($Org eq 'mja')
    {
	$Text =~ s/\bmja_main\b/CHR/g;
	$Text =~ s/\bmja_ecl\b/ECL/g;
	$Text =~ s/\bmja_ecs\b/ECS/g;
    }
#    elsif($Org eq 'cyano')
    elsif($Org eq 'syn')
    {
	$Text =~ s/\bcya_main\b/CHR/g;
    }
#    elsif($Org eq 'yeast')
    elsif($Org eq 'sce')
    {
	$Text =~ s/\byeast_1\b/I/g;
	$Text =~ s/\byeast_2\b/II/g;
    	$Text =~ s/\byeast_3\b/III/g;
	$Text =~ s/\byeast_4\b/IV/g;
	$Text =~ s/\byeast_5\b/V/g;
	$Text =~ s/\byeast_6\b/VI/g;
	$Text =~ s/\byeast_7\b/VII/g;
	$Text =~ s/\byeast_8\b/VIII/g;
	$Text =~ s/\byeast_9\b/IX/g;
	$Text =~ s/\byeast_10\b/X/g;
	$Text =~ s/\byeast_11\b/XI/g;
	$Text =~ s/\byeast_12\b/XII/g;
	$Text =~ s/\byeast_13\b/XIII/g;
	$Text =~ s/\byeast_14\b/XIV/g;
	$Text =~ s/\byeast_15\b/XV/g;
	$Text =~ s/\byeast_16\b/XVI/g;
    }
    else
    {
	$Text =~ s/\b${Org}_main\b/CHR/g;
    }

    $Text;
}

# ʸʸʸѴ
# input : Ѵоʸ
# return: Ѵʸ
sub upperCase
{
    my($str) = @_;

    $str =~ tr/a-z/A-Z/;
    $str;
}

# ʸʸ龮ʸѴ
# input : Ѵоʸ
# return: Ѵʸ
sub lowerCase
{
    my($str) = @_;

    $str =~ tr/A-Z/a-z/;
    $str;
}

##############################################################################
1;
##############################################################################
