#!/usr/local/bin/perl -s
use strict;
use FileHandle;
package main;

###############################################################################
#
sub print_seq {
	my($seq, $LINELEN) = @_;
	my($i);
	my($len) = length($seq);
	$LINELEN = 60 if (! $LINELEN);

	for ($i = 0; $i < $len; $i+=$LINELEN) {
		print substr($seq, $i, $LINELEN);
		print "\n";
	}
}

###############################################################################
#
sub reverse {
	my($seq) = @_;
	my($revseq);
	$revseq = reverse($seq);
	$revseq =~ tr/ATGCRYMKSWHBVDN/TACGYRKMSWDVBHN/;
	$revseq =~ tr/atgcrymkswhbvdn/tacgyrkmswdvbhn/;
	$revseq;
}

###############################################################################
#
sub readFastaSequence {
    my($filename) = @_;
    my($info);
    my($id);
    my($seq);
    local(*FH);

    open(FH, "$filename") || die("Can not open $filename($!)");

    $info = {};
    $seq = '';
    while(<FH>) {
        if (/^>\s*(\S+)/) {
            if ($seq ne '') {
                $info->{"$id"} = $seq;
            }
            $id = $1;
            $seq = $_;
        }
        else {
            $seq .= $_;
        }
    }
    if ($seq ne '') {
        $info->{"$id"} = $seq;
    }

    close(FH);

    return $info;
}

###############################################################################
#
sub compactionFasta {
    my($fileDbSrc) = shift;
    my($fileDbDst) = shift;
    my($fileSeqName) = shift;
    my($line);

    #
    my($fh) = new FileHandle("$fileSeqName") || die("Can not open $fileSeqName($!)");
    my($fhSrc) = new FileHandle("$fileDbSrc") || die("Can not open $fileDbSrc($!)");
    my($fhDst) = new FileHandle(">$fileDbDst.$$") || die("Can not open $fileDbDst.$$($!)");

    #
    my($hashSeqName) = {};
    while($line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        $hashSeqName->{"$line"} = 1;
    }
    $fh->close();

    #
    my($doOutput) = 0;
    while($line = $fhSrc->getline()) {
        if ($line =~ /^>\s*(\S+)/) {
            my($name) = $1;
            $doOutput = 0;
            if ($hashSeqName->{"$name"} != 0) {
                $doOutput = 1;
            }
        }

        next if (! $doOutput);

        $fhDst->print($line);
    }
    $fhSrc->close();
    $fhDst->close();

    #
    unlink("$fileDbDst") if (-e "$fileDbDst");
    rename("$fileDbDst.$$", "$fileDbDst");

    return;
}

###############################################################################
1;
###############################################################################
