#!/usr/local/bin/perl -s

###############################################################################
# for update
###############################################################################
require "MBGD_Conf.pl";

package main;

use File::Basename;
use File::Path;
use DirHandle;
use File::stat;

sub Message {
	my(@messages) = @_;
	foreach $m (@messages) {
		print STDERR "$m\n";
	}
}

# $time should be an output of 'time' or the one like "10d"
sub cmprFileDate1 {
	my($file1, $time) = @_;
	my(%unitsize) = ('s'=>1, 'm'=>60, 'h'=>3600, 'd'=>3600*24 );
	
	if (! -e $file1) {
		return -1;
	}
	$st1 = stat($file1);
	if(! $time) {
		$time = time;
	} elsif($time =~ /^([\+\-])*(\d+)([dhms])$/) {
		$sign = $1; $amount = $2; $unit = $3;
		$sign = '-' if (! $sign);
		if ($unit eq 's') {
			$unitsize  = 1;
		} if ($unit eq 'm') {
		}
		$time  = eval "time $sign $amount * $unitsize{$unit}";
	}
	return $st1->mtime <=> $time;
}
sub cmprFileDate {
	my($file1, $file2) = @_;
	if (! -e $file1) {
		return -1;
	} elsif (! -e $file2) {
		return 1;
	}
	$st1 = stat($file1);
	$st2 = stat($file2);
	return $st1->mtime <=> $st2->mtime;
}

sub copyFiles {
	my($file1, $file2, $opt) = @_;
	my($status);
	if (-d "$file1") {
		if (! -d "$file2") {
			system("$CMD_mkdir -p $file2");
		}
		my $dh = new DirHandle $file1 || die "Can't open $fle1\n";
		while (my $f = $dh->read()) {
			next if ($f =~ /^\./);
			$status += &copyFiles("$file1/$f", "$file2/$f", $opt);
		}
	} elsif (ref($file1) eq 'ARRAY') {
		if (! -d "$file2") {
			system("$CMD_mkdir -p $file2");
		}
		foreach my $f (@{$file1}) {
			$status += &copyFiles($f, $file2, $opt);
		}
	} elsif (-l $file1) {
		my($fname) = basename($file1);
		my $linkfile = readlink $file1;
		if (! -f $file2) {
			print("ln -s $file1 $file2\n") if ($opt->{verbose});
			if (! -d dirname($file2)) {
				mkpath(dirname($file2));
			}
			symlink $linkfile, $file2;
			$status = 1;
		}
	} elsif (-f $file1) {
		my($fname) = basename($file1);
		my($Command);
		if ($opt->{link}) {
			$Command = "$CMD_ln";
		} elsif ($opt->{rename}) {
			$Command = "$CMD_mv";
		} else {
			$Command = "$CMD_cp -p";
		}
		if (-d "$file2") {
			if ($opt->{force} ||
				    &cmprFileDate($file1, "$file2/$fname")>0) {
				print("$Command $file1 $file2\n") if ($opt->{verbose});
				unlink("$file2/$fname") if (-f "$file2/$fname");
				system("$Command $file1 $file2");
				$status = 1;
			}
		} else {
			if ($opt->{force} || &cmprFileDate($file1, "$file2")>0) {
				if (! -d dirname($file2)) {
					mkpath(dirname($file2));
				}
				print("$Command $file1 $file2\n") if ($opt->{verbose});
				unlink("$file2") if (-f "$file2");
				system("$Command $file1 $file2");
				$status = 1;
			}
		}
	}
	return $status;
}

sub CopyTableFiles {
	my($tabName, $srcDir, $dstDir) = @_;
	my($cmd);
	my(@copyFiles) = <$srcDir/$tabName*>;
	my($copycnt);

	print STDERR "Copy $tabName :: $srcDir --> $dstDir\n";
	foreach $f (@copyFiles) {
#print STDERR ">$f<\n";
		my $fname = basename($f);
		if (! -f "$dstDir/$fname" || &cmprFileDate("$dstDir/$fname", "$srcDir/$fname")<0) {
			system("cp -p $f $dstDir");
			$copycnt++;
		}
	}
	return if (! $copycnt);

	print STDERR "Refresh MySQL\n";
	$cmd = "$CMD_mysqladmin refresh";
	system("$cmd");
}

###############################################################################
# ɸ२顼Ϥ˽ϤΤ $logfile ˤϤ
sub openLogfile {
    my($file) = @_;

    mkpath("$DIR_log", 0, 0750);

    # STDERR 
    open(BAKERR, ">&STDERR");

    if ($main::nolog) {
        return;
    }

    if (! $file) {
        $file = "$DIR_log/" . basename($0, (".pl")) . ".log";
    }

    # STDERR ˽ϤΤե˽  ⤦ STDERR ˽
    open(STDERR, "| $CMD_tee -a $file 1>&2") || die("Can not open $file($!)");

    print STDERR "### Logging started: ", scalar(localtime()), " :: ", $file, "\n";
}

sub closeLogfile {
    close(STDERR);
    open(STDERR, ">&BAKERR");
}

###############################################################################
1;#
###############################################################################
