#!/usr/local/bin/perl -s

###############################################################################
#
sub readGenBankFaa {
    my(@fileList) = @_;
    my($info);
    my($filename);
    my($gi, $seq);
    local(*FH);

    $info = {};
    $gi = '';
    $seq = '';
    foreach $filename (@fileList) {
        open(FH, "$filename") || die("Can not open $filename($!)");
        while(<FH>) {
            chomp();

            if (/^>/) {
                if ($seq ne '') {
                    $info->{"$gi"} = $seq;
                    $seq = '';
                }

                ($gi) = (/^>gi\|(\d+)\|/);
                if ($gi == 0) {
                    print STDERR "WARNING :: can not found GI [$_]\n";
                }
            }
            else {
                $seq .= $_;
            }
        }
        if ($seq ne '') {
            $info->{"$gi"} = $seq;
        }
        close(FH);
    }

    return $info;
}


###############################################################################
1;#
###############################################################################
