#!/usr/bin/perl
use strict;
use MBGD::DB;
use RECOG;
use RECOG::DomClustCommon;
use RECOG::ExecDomclust;
use RECOG::Cache::mysql;
#
# $BL$<B9T$N(Bdomclust$B$N%3%^%s%I$KBP$7$F!"?7$?$K(BID$B$rH/9T$7%F!<%V%k$r:n@.$9$k(B
# $B:F<B9T$N(Bdomclust$B$N%3%^%s%I$KBP$7$F!"%F!<%V%k$r:F<B9T%9%F!<%?%9$KJQ99$9$k(B
# $B:o=|%*%W%7%g%s$KBP$7$F$O2?$b$7$J$$(B
#
# $B0z?t!!(B$cmd$B!!(Bdomclust$B<B9T%3%^%s%I(B
#
# $BLa$jCM!!$J$7(B
# 
sub createRecogIdTab {
	my ($refOpt) = shift;
	my $db = new MBGD::DB($main::DOMCLUST_DB);
	my $cachemy = new RECOG::Cache::mysql;

	if(!$refOpt) {
		return;
	}

	# $B0z?t$+$i(Bdomclust$B5/F0%3%^%s%I$r@8@.$9$k(B
	my $cmd = &createCmdline($refOpt);

	# $BI,?\%*%W%7%g%s$G$"$k(B-ingroup$B$,L5$$>l9g!"%W%m%0%i%`$r=*N;$9$k(B
	if(! $cmd =~ /-ingroup=\S/) {
		die "Invalid option. Use \'-ingroup\' option.";
	}

	# $B%F!<%V%k$,B8:_$7$J$$>l9g$O:n@.$9$k(B
	$cachemy->createIndexTable($db);
	
	# $BF1$8%3%^%s%I$,L5$$$+$r3NG'(B
	my $res = $cachemy->isSameID_fr_cmd($db,$cmd);
	my $id="";

	if($res) {
		# $BB8:_$7$?>l9g!"%F!<%V%k$N>uBV$r%A%'%C%/$9$k!#(B
		$id = $res->[0];
		my $status = $res->[1];
		if($status == -1) {
			# $B<B9T:Q$_!#(B
		} elsif($status < -1) {
			# $B<B9T%(%i!<(B
			# $B%j%H%i%$%+%&%s%HFb$N>l9g!":F<B9T%9%F!<%?%9$XJQ99$7!"%j%H%i%$%+%&%s%H$r%"%C%W$9$k(B
			if(&canRetry($db, $id)) {
				&uploadRetryStatus($db, $id);
			}
		}
		else {
			# $B<B9TCf(B
			# $BK\Ev$K<B9TCf$+$I$&$+$rD4::$9$k(B
			if(! isAlive($status) || $status==0 || $status==1) {
				# $B%9%F!<%?%9$OB8:_$9$k$,!"<B:]$N=hM}$O9T$o$l$F$$$J$$(B
				# $B%j%H%i%$%+%&%s%HFb$N>l9g!":F<B9T%9%F!<%?%9$KJQ99$9$k!J%W%m%;%9(BID$B$r:F@_Dj$9$k!K(B
				if(&canRetry($db, $id)) {
					&uploadRetryStatus($db, $id);
				}
			}
		}
	} else {
		# $B%F!<%V%k$r:n@.$7!"(BClusterID$B$rH/9T$9$k!#<B9T%9%F!<%?%9$r%;%C%H$9$k(B
		$id = &createUID();
		my $c = 0;
		while(defined(getStatus_fr_id($db, $id))) {
			$id = &createUID();
			$c++;
			if($c > 3) {
				die "Can not made clusterID.";
			}
		}
		&insertStartStatus($db, $id, $cmd);
	}
	print STDERR "clsuterID::$id\n";
}

#
# uniq$B$J(BID$B$r@8@.$9$k(B
#
# $B0z?t!!$J$7(B
#
# $BLa$jCM!!%/%i%9%?!<(BID
#
sub createUID {
	return sprintf("%d_%05d", time, $$);
}

if($0 eq __FILE__) {
	
	if(!@ARGV) {
		exit;
	}

	# DB$B$KEPO?$5$l$F$$$J$$$b$N$N$_!"(BID$B$rH/9T$9$k(B
    my($refOpt) = parseCommandOption(join(" ", @ARGV));
	&createRecogIdTab($refOpt);

}

###
1;#
###
