#!/usr/bin/perl -s
use strict;
use MBGD::DB;


###############################################################################
#
sub printUsage {
    print STDERR "$0 -DBNAME=dbname -TABID=tabid \n";
    print STDERR "    -DBNAME\n";
    print STDERR "      dbname : (e.g.: mbgd_tmp)\n";
    print STDERR "    -TABID\n";
    print STDERR "      tabid  : Cluster table ID.\n";

    return;
}

###############################################################################
#
sub create_clustxref_table {
    my($db) = shift;
    my($tabid) = shift;
    my($sql);

    #
    my($tabname) = "clustxref_$tabid";

    #
    $sql = "drop table if exists $tabname";
    $db->execute($sql);

    #
    $sql = "create table if not exists $tabname ("
         . "clustid      int(11) not null, "
         . "xref_db      varchar(24) not null,"
         . "xref_id      varchar(24) not null,"
         . "n_xref       int(11) default 0,"
         . "total_xref   int(11) default 0,"
         . "primary key (clustid, xref_db, xref_id)"
         . ")"
         . "";
    print STDERR "SQL :: $sql\n" if ($main::DEBUG);
    $db->execute($sql);

    return;
}

###############################################################################
#
sub load_clustxref_data {
    my($db) = shift;
    my($tabid) = shift;
    my($filename) = shift;
    my($sql);

    #
    $sql = "load data local infile '$filename' "
         . "into table clustxref_$tabid "
         . "fields terminated by '\\t' "
         . "";
    print STDERR "SQL :: $sql\n" if ($main::DEBUG);
    $db->execute($sql);

    return;
}

###############################################################################
#
sub count_xref {
    my($db) = shift;
    my($tabid) = shift;
    my($count_xref_ref) = {};

    #
    my($tabname) = "cluster_$tabid c, $main::DBNAME_FUNC.gene_category f";
my($tabname) = "cluster_domclust_cache_$tabid c, $main::DBNAME_FUNC.gene_category f";
    my($sql) = "select clustid, dbname, count(distinct(c.spname)) as n, orig_id from $tabname "
             . "where c.sp=f.sp and c.name=f.name and f.orig_id is not null "
             . "group by clustid, dbname, orig_id "
             . "order by c.clustid, f.dbname,orig_id";
    my($sth) = $db->execute($sql);
    while (my$ref = $sth->fetchrow_hashref()) {
        my($clustid) = $ref->{'clustid'};
        my($dbname)  = $ref->{'dbname'};
        my($n)       = $ref->{'n'};
        my($orig_id) = $ref->{'orig_id'};
        $count_xref_ref->{"$clustid"}->{"$dbname"}->{"$orig_id"} = $n;
    }

    return $count_xref_ref;
}

###############################################################################
#
sub total_xref {
    my($db) = shift;
    my($tabid) = shift;
    my($total_xref_ref) = {};

    my($sql) = "select cmd from $main::DBNAME.cluster_tables_idx where clusterID='$tabid'";
    my($sth) = $db->execute($sql);
    my($ref) = $sth->fetchrow_hashref();
    my($spec_list) = ($ref->{'cmd'} =~ /-SPEC=(\S+)/);

    #
    my($where_sp) = '';
    foreach my$sp (split(/\,/, $spec_list)) {
        $where_sp .= "," if ($where_sp ne '');
        $where_sp .= "'$sp'";
    }

    #
    my($sql) = "select dbname, orig_id, count(distinct(concat(sp,':',name))) as total "
             . "from $main::DBNAME_FUNC.gene_category "
             . "where orig_id is not null and sp in ($where_sp) "
             . "group by dbname, orig_id";
    my($sth) = $db->execute($sql);
    while (my$ref = $sth->fetchrow_hashref()) {
        my($dbname) = $ref->{'dbname'};
        my($orig_id) = $ref->{'orig_id'};
        $total_xref_ref->{"$dbname"}->{"$orig_id"} = $ref->{'total'};
    }

    return $total_xref_ref;
}

###############################################################################
#
sub create_clustxref {
    my($db) = shift;
    my($tabid) = shift;
    my($clust_xref) = {};

    #
    my($tabname) = "cluster_$tabid";
    my($tabname) = "cluster_domclust_cache_$tabid";
    if (! $db->exist_table($tabname)) {
        print STDERR "DBG :: not found $tabname\n";
        return;
    }

    #
    my($count_xref_ref) = count_xref($db, $tabid);
    my($total_xref_ref) = total_xref($db, $tabid);

    #
    my($filename) = "$ENV{'MBGD_HOME'}/work/tmp_clustxref.$$";
    my($fh) = FileHandle->new(">$filename") || die("Can not open $filename($!)");
    foreach my$clust_id (keys(%{$count_xref_ref})) {
        my($clust_id_ref) = $count_xref_ref->{"$clust_id"};
        foreach my$xrefdb (keys(%{$clust_id_ref})) {
            my($xrefdb_ref) = $clust_id_ref->{"$xrefdb"};
            foreach my$orig_id (keys(%{$xrefdb_ref})) {
                my($count_xref) = $xrefdb_ref->{"$orig_id"};
                my($total_xref) = $total_xref_ref->{"$xrefdb"}->{"$orig_id"};
                $fh->print(join("\t", $clust_id,
                                 $xrefdb,
                                 $orig_id,
                                 $count_xref,
                                 $total_xref,
                                ), "\n");
            }
        }
    }
    $fh->close();

    #
    load_clustxref_data($db, $tabid, $filename);
    unlink("$filename");

    return;
}


###############################################################################
if ($0 eq __FILE__) {
    my($dbname);
    my($tabid);
    my(@xrefdb_list);

    #
    if (! defined($main::DBNAME)) {
        printUsage();
        exit(-1);
    }
    $dbname = $main::DBNAME;

    #
    if (! defined($main::TABID)) {
        printUsage();
        exit(-1);
    }
    $tabid = $main::TABID;

    #
    my($db) = MBGD::DB->new($dbname);
    create_clustxref_table($db, $tabid);
    create_clustxref($db, $tabid);

    exit(0);
}

###############################################################################
1;#
###############################################################################
