#!/usr/bin/perl -s
use strict;
use Getopt::Long;
use FileHandle;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -TABID=table_id [-DBNAME=db_name] file_domclust_tree\n";

    return;
}

###############################################################################
#
sub get_table_name {
    my($table_id) = shift;

    my($table_name) = 'clustdump_' . $table_id;

    return $table_name;
}

###############################################################################
#
sub create_table {
    my($db) = shift;
    my($table_id) = shift;
    my($sql);

    #
    my($table_name) = get_table_name($table_id);

    #
    $sql = 'drop table if exists ' . $table_name;
    $db->execute($sql);

    #
    $sql = q{CREATE TABLE } . $table_name . q{(}
         . q{line_no int(11)     NOT NULL auto_increment,}
         . q{dump    mediumtext,}
         . q{PRIMARY KEY  (line_no)}
         . q{) auto_increment=1 };
    $db->execute($sql);

    return;
}

###############################################################################
#
sub store_domclust_dump {
    my($db) = shift;
    my($table_id) = shift;
    my($filename) = shift;

    #
    create_table($db, $table_id);

    #
    my($table_name) = get_table_name($table_id);

    my($sql) = "load data local infile '$filename' into table $table_name "
             . "lines terminated by '\\n' "
             . "(dump)";
    $db->execute($sql);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($db_name) = $main::DBNAME_MBGD;
    if (defined($main::DBNAME)) {
        $db_name = $main::DBNAME;
    }
    if (!defined($main::TABID)) {
        printUsage();
        exit(0);
    }

    my($db) = MBGD::DB->new($db_name);
    foreach my$file (@ARGV) {
        store_domclust_dump($db, $main::TABID, $file);
        last;
    }
}

1;#
