#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -dbname=DBNAME -tabid=TABID\n";
}

###############################################################################
#
sub printDomClustRes {
    my($db) = shift;
    my($tabID) = shift;

    #
    my($opt);
    my($res);

    #
    my($tab) = "cluster_$tabID"; # cluster_domclust_cache_
	$opt = {};
    $opt->{'where'} = "";
    $opt->{'order'} = "clustid, subclustid, sp, name";
    $res = $db->select_fetch($tab, $opt);

    #
    my($clustId);
    my($subClustId);
    my($outGroup);
    my($prevClustId) = -1;
    my($prevSubClustId);
    foreach my$ref (@{$res->{'INFO'}}) {
        if ($prevClustId != $ref->{'clustid'}) {
            if ($outGroup ne '') {
                print "\n";
                print $outGroup;
            }
            print "\n" if ($ref->{'clustid'} != 1);
            print "Cluster ", $ref->{'clustid'};
            print "\n";
            print "HomCluster ", $ref->{'homclustid'};
            print "\n";
            $prevSubClustId = -1;
            $outGroup = "OutGroup\n";
        }
        if ($ref->{'subclustid'} == 0) {
            my($spname) = $ref->{'spname'};
            $spname .= "($ref->{'dom'})" if ($ref->{'dom'} != 0);
            $outGroup .= join(" ", $spname, $ref->{'from1'}, $ref->{'to1'}) . "\n";
        }
        else {
            if ($prevSubClustId != $ref->{'subclustid'}) {
                print "\n" if ($ref->{'subclustid'} >= 2);
                print "SubCluster ", $ref->{'subclustid'};
                print "\n";
            }
            my($spname) = $ref->{'spname'};
            $spname .= "($ref->{'dom'})" if ($ref->{'dom'} != 0);
            print join(" ", $spname, $ref->{'from1'}, $ref->{'to1'}) . "\n";
        }

        $prevClustId    = $ref->{'clustid'};
        $prevSubClustId = $ref->{'subclustid'};
    }
    if ($outGroup ne '') {
        print "\n";
        print $outGroup;
    }

    return;
}


###############################################################################
if ($0 eq __FILE__) {

    if (!$main::dbname || !$main::tabid) {
        printUsage();
        exit(0);
    }

    my($db) = new MBGD::DB($main::dbname);
    printDomClustRes($db, $main::tabid);
}

###############################################################################
1;#
###############################################################################
