#!/usr/bin/perl -s
use strict;
use IO::Dir;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;
require "MBGD_Conf.pl";

###############################################################################
#
sub print_usage {

    print STDERR "usage :: $0 [ -DBNAME=dbname_recog ] -PROJECT_ID=project_id  file\n";

    return;
}

###############################################################################
#
sub clear_base_cluster {
    my($dir) = shift;

    my($dh) = IO::Dir->new("$dir") || return;
    while (my$file=$dh->read()) {
        next if (($file =~ /^\d+$/) && ($file =~ /^\d+\_\d+$/));

        unlink("$dir/$file");
    }

    return;
}

###############################################################################
#
sub dbInsert_base_cluster {
    my($db) = shift;
    my($dir) = shift;
    my($project_id) = shift;
    my($file) = shift;

    #
    my($tab_spec);
    my($tab_cmd);
    my($tab_id);
    my($tab_cdate);
    my($fhr) = IO::File->new("$file");
    while (my$line=$fhr->getline()) {
        if ($line =~ /^\#START_DATA$/i) {
            last;
        }
        elsif ($line =~ /^\#spec\s+(.+)$/i) {
            $tab_spec = $1;
        }
        elsif ($line =~ /^\#cmd\s+(.+)$/i) {
            $tab_cmd = $1;
        }
        elsif ($line =~ /^\#(?:tabid|clusterID)\s+(.+)$/i) {
            $tab_id = $1;
        }
        elsif ($line =~ /^\#cdate\s+(.+)$/i) {
            $tab_cdate = $1;
        }
    }
    my($n_gene) = 0;
    my($n_cluster) = 0;

    #
    my($file_tabid) = "$dir/$tab_id";
    my($fhw) = IO::File->new("$file_tabid", 'w') || die("Can not open $file_tabid($!)");
    while (my$line=$fhr->getline()) {
        $fhw->print($line);

        if ($line =~ /^Cluster\s+\d+$/) {
            $n_cluster++;
        }
    }
    $fhw->close();
    $fhr->close();

    #
    my($file_tabidx) = "$file.tabidx";
    my($fhw) = IO::File->new("$file_tabidx", 'w');
    $fhw->print(join("\t", $tab_id, -1, $tab_cmd, $tab_spec, 0, $n_gene, $n_cluster, '', $tab_cdate), "\n");
    $fhw->close();

    my($tabname) = 'base_cluster_index';
    if (!$db->exist_table($tabname)) {
        my($sql) = "create table if not exists $tabname ("
                 . "clusterID varchar(50) NOT NULL,"
                 . "status    int(11) NOT NULL,"
                 . "cmd       mediumtext NOT NULL,"
                 . "name      mediumtext,"
                 . "counter   int(11) NOT NULL,"
                 . "ngene     int(30) NOT NULL,"
                 . "ncluster  int(30) DEFAULT NULL,"
                 . "warning   mediumtext,"
                 . "cdate     timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,"
                 . "PRIMARY KEY (clusterID)"
                 . ")";
        $db->execute($sql);
    }
    my($sql) = "load data local infile '$file_tabidx' REPLACE into table $tabname ";
    $db->execute($sql);

    #
    my($file_proj_dom) = "$ENV{'MBGD_HOME'}/work/proj_dom_$$";
    my($tabname) = 'project_domclust';
    my($name)      = $tab_id;
    my($descr)     = 'base_cluster';
    my($view_opts) = '';
    my($fhw) = IO::File->new("$file_proj_dom", 'w');
    $fhw->print(join("\t", $project_id, $tab_id, $name, $descr, ''), "\n");
    $fhw->close();
    my($sql) = "load data local infile '$file_proj_dom' REPLACE into table $tabname ";
    $db->execute($sql);
    unlink($file_proj_dom);

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    my(@file_list) = @ARGV;
    if ($main::h || $main::help) {
        print_usage();
        exit(0);
    }

    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($dir) = sprintf("%s/MBGD.tmp/base_cluster", $ENV{'RECOG_HOME'});
    if ($main::DIR) {
        $dir = $main::DIR;
    }

    my($project_id) = $main::PROJECT_ID;

    #
    clear_base_cluster($dir) if ($main::CLEAR);
    foreach my$file (@file_list) {
        dbInsert_base_cluster($db, $dir, $project_id, $file);
    }
}

###############################################################################
1;#
###############################################################################
