#!/usr/bin/perl -s
use strict;
use IO::File;
use RecogProjectCommon;

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 [-c] passwordfile realm username password\n";
    exit(0);
}

###############################################################################
if ($0 eq __FILE__) {
    my($passwordfile) = shift(@ARGV) || print_usage();
    my($realm)        = shift(@ARGV) || print_usage();
    my($username)     = shift(@ARGV) || print_usage();
    my($passwd)       = shift(@ARGV) || print_usage();

    if ($main::c) {
        IO::File->new(">$passwordfile") || die("Can not open $passwordfile($!)");
    }
    RecogProjectCommon::add_htdigest($passwordfile,
                                     $username,
                                     $realm,
                                     $passwd);
}

###############################################################################
1;#
###############################################################################
