#!/usr/bin/perl -s
use strict;
use MBGD::DB;
#use DBI;
require "MBGD_Conf.pl";

die "Usage: $0 [-SPEC=splist -SCORE=# -PAM=# -EVAL=# -IDENT=#] genename\n" if (! @ARGV);

###############################################################################
#
sub select_homolog_list {
    my($db) = shift;
    my($genename) = shift;
    my($order) = shift;

    $main::ADDLEN = 1 if ($main::ORIGOUT);
    #
    my($sp, $name) = split(/:/, $genename);
    my($sql) = "select chksum from prot_chksum where sp=? and name=?";
    my($sth) = $db->prepare($sql);
    $sth->execute($sp, $name);
    my($chksum) = $sth->fetchrow_array();

    my($tables) = " $main::DBNAME_ACCUM.homology h, prot_chksum c";

    my($wopt) = '1';
    if ($main::SPEC) {
        my(@splist) = split(/,/, $main::SPEC);
        $wopt .= " and c.sp in('" . join("','", @splist) . "')" ;
    }
    if ($main::PAM) {
        $wopt .= sprintf(" and h.pam <= %d", $main::PAM);
    }
    if ($main::EVAL) {
        $wopt .= sprintf(" and h.eval <= %f", $main::EVAL);
    }
    if ($main::SCORE) {
        $wopt .= sprintf(" and h.score >= %d", $main::SCORE);
    }
    if ($main::IDENT) {
        $wopt .= sprintf(" and h.ident >= %f", $main::IDENT);
    }

    #
    my($addfld) = '';
    my($q_aalen);
    if ($main::ADDLEN) {
    	my($sth) = $db->prepare("select aalen from gene where sp='$sp' and name='$name'");
	$sth->execute;
	my($res) = $sth->fetchrow_hashref();
	$q_aalen = $res->{aalen};
    }
    if ($main::ADDLEN) {
        $addfld  = ", g.aalen";
        $tables .= ", gene g";
        $wopt   .= " and c.sp=g.sp and c.name=g.name ";
    }

    #
    my(@Results);
    my(%Find);
    my($fields) = "c.sp,c.name,h.from1,h.to1,h.from2,h.to2,h.ident,h.eval,h.pam,h.score $addfld";
    my($sql) = "select $fields from $tables where h.name1=? and h.name2=c.chksum and $wopt";
    my($sth) = $db->prepare($sql);
    $sth->execute($chksum);
    while (my$res = $sth->fetchrow_hashref()) {
        push(@Results, $res);
#        # for duplication check
        $Find{"$res->{sp}:$res->{name}"} = 1;
    }

    #
    my($fields) = "c.sp,c.name,h.from2 from1, h.to2 to1, h.from1 from2, h.to1 to2, h.ident,h.eval,h.pam,h.score $addfld";
    my($sql) = "select $fields from $tables where h.name2=? and h.name1=c.chksum and $wopt";
    print STDERR "DBG :: SQL :: $sql\n" if ($mian::DEBUG);
    my($sth) = $db->prepare($sql);
    $sth->execute($chksum);
    while (my$res = $sth->fetchrow_hashref()) {
        ## duplication check
        next if ($Find{"$res->{sp}:$res->{name}"});
        push(@Results, $res);
    }

    #
    if ($order eq 'score') {
        @Results = sort {$b->{score}<=>$a->{score}} @Results;
    }
    elsif ($order eq 'pam') {
        @Results = sort {$a->{pam}<=>$b->{pam}} @Results;
    }
    foreach my$res ( @Results ) {
##print STDERR "N>$genename, $q_aalen, $res->{from1},$res->{to1}; $res->{sp}:$res->{name}, $res->{aalen}, $res->{from2},$res->{to2}\n";
	my($cov) = &coverage($res->{from1},$res->{to1},$res->{from2},$res->{to2}, $q_aalen, $res->{aalen});
        if ($main::ORIGOUT) {
            print join(" ", $genename, "$res->{sp}:$res->{name}",
                       $res->{from1}, $res->{to1}, $res->{from2}, $res->{to2},
                       $res->{ident}, $res->{eval}, $res->{pam}, $res->{score}, $cov), "\n";
        }
        else {
            print join(" ", $genename, "$res->{sp}:$res->{name}",
                       $res->{from1}, $res->{to1}, $res->{from2}, $res->{to2},
                       $res->{pam}, $res->{score}), "\n";
        }
    }

    return;
}
sub coverage {
	my($from1,$to1,$from2,$to2,$len1,$len2) = @_;
	my($cov1) = ($to1 - $from1 + 1) * 100 / $len1;
	my($cov2) = ($to2 - $from2 + 1) * 100 / $len2;
	my($coverage) = sprintf("%.1f", ($cov1>$cov2) ? $cov1 : $cov2);
	return $coverage;
}

###############################################################################
if ($0 eq __FILE__) {
    my($genename) = $ARGV[0];

    my($order) = 'score';
    if (defined $main::ORDER) {
        $order = $main::ORDER;
    }

    my($dbname) = $main::DBNAME_MBGD;
    if (defined $main::DBNAME) {
        $dbname = $main::DBNAME;
    }

    my($db) = MBGD::DB->new($dbname);
    select_homolog_list($db, $genename, $order);
}

1;#
