#!/usr/bin/perl -s
use strict;
use MBGD::DB;
use MBGD::FunctionCategory;

###############################################################################
#
$main::CACHE_gene = {};
sub get_gene_info {
    my($spec) = shift;
    my($name) = shift;
    my(%fcdb_hash) = @_;

    if (!exists($main::CACHE_gene->{"$spec"})) {
        $main::CACHE_gene->{"$spec"} = {};
        my($dbname) = $main::DBNAME_MBGD;
        my($db) = MBGD::DB->new($dbname);
        my($sql) = "select * from gene where sp='$spec'";
        my($sth) = $db->execute($sql);
        while (my$ref=$sth->fetchrow_hashref()) {
            my($nm) = $ref->{'name'};
            $main::CACHE_gene->{"$spec"}->{"$nm"} = $ref;
        }
    }

    my($ref) = $main::CACHE_gene->{"$spec"}->{"$name"};
    if (!exists($ref->{'func'})) {
        my(@key_list) = keys(%fcdb_hash);
        foreach my$key (@key_list) {
            $ref->{'func'}->{"$key"}->{'90'} = 0;

            my($fcdb) = $fcdb_hash{"$key"};
            my($refFuncList) = $fcdb->getFunctionListBySporf("$spec:$name");
            my(@lev_list);
            foreach my$refFunc (@{$refFuncList}) {
                my($lev) = $refFunc->{'LEVEL'};
                next if (!$lev);
                push(@lev_list, $lev);
            }
            my($n) = scalar(@lev_list);
            foreach my$lev (@lev_list) {
                $ref->{'func'}->{"$key"}->{"$lev"} = 1 / $n;
            }
        }
    }

    return $ref;
}

###############################################################################
#
sub upd_cluster_func {
    my($dbname) = shift;
    my($tabid) = shift;

    my($n_warn) = 0;
    my($n_same) = 0;
    my(@funcdb_list) = ('mbgd', 'cog', 'kegg', 'tigr');
    my(%fcdb_hash);
    my($dir) = "$ENV{'MBGD_HOME'}/database/function";
    my($orig) = 1;
    foreach my$d (@funcdb_list) {
        $fcdb_hash{"$d"} = MBGD::FunctionCategory->new($d, $dir, $orig);
    }

    #
    my($db) = MBGD::DB->new($dbname);
    my($tab) = "cluster_domclust_cache_$tabid";
    my($sql) = "select * from $tab order by clustid, subclustid";
    my($sth) = $db->execute($sql);
    my($cluster_ref) = {};
    while (my$ref=$sth->fetchrow_hashref()) {
        my($cid)    = $ref->{'clustid'};
        my($scid)   = $ref->{'subclustid'};
        my($spname) = $ref->{'spname'};

        if (!exists($cluster_ref->{"$cid"}->{"$scid"})) {
            $cluster_ref->{"$cid"}->{"$scid"} = [];
        }
        push(@{$cluster_ref->{"$cid"}->{"$scid"}}, $spname);
    }

    my($tab) = "cluster_func_clust2sql_$tabid";
    my($sql) = "select * from $tab order by clustid, subclustid";
    my($sth) = $db->execute($sql);
    my($db_clustfunc_ref) = {};
    while (my$ref=$sth->fetchrow_hashref()) {
        my($cid)  = $ref->{'clustid'};
        my($scid) = $ref->{'subclustid'};
        foreach my$funcdb (@funcdb_list) {
            foreach my$k ('c', 's') {
                my($key) = $k . $funcdb;
                $db_clustfunc_ref->{"$cid"}->{"$scid"}->{"$key"} = $ref->{"$key"};
            }
        }
    }

    #
    my($prev_cid);
    my($prev_scid);
    my($clustfunc_ref);
    my(@cid_list) = keys(%{$cluster_ref});
    foreach my$cid (sort {$a <=> $b} @cid_list) {
        my($clustfunc_ref) = {};

        my(@scid_list) = keys(%{$cluster_ref->{"$cid"}});
        foreach my$scid (sort {$a <=> $b} @scid_list) {

            # update subcluster function
            my($subclustfunc_ref) = {};
            my(@spname_list) = @{$cluster_ref->{"$cid"}->{"$scid"}};
            foreach my$spname (@spname_list) {
                my($spec, $name) = split(/\:/, $spname);
                my($gene_info) = get_gene_info($spec, $name, %fcdb_hash);
                my(@key_list) = @funcdb_list;
                foreach my$key (@key_list) {
                    my(@lev_list) = keys(%{$gene_info->{'func'}->{"$key"}});
                    foreach my$lev (@lev_list) {
                        $clustfunc_ref->{"$key"}->{'90'} = 0;
                        $subclustfunc_ref->{"$key"}->{'90'} = 0;

                        my($v) = $gene_info->{'func'}->{"$key"}->{"$lev"};
                        next if (!$v);

                        $clustfunc_ref->{"$key"}->{"$lev"} += $v;
                        $subclustfunc_ref->{"$key"}->{"$lev"} += $v;
                    }
                }
            }

            #
            my(@key_list) = keys(%{$subclustfunc_ref});
            foreach my$key (@key_list) {
                my($func_ref) = sub {
                    $subclustfunc_ref->{"$key"}->{"$b"} <=> $subclustfunc_ref->{"$key"}->{"$a"};
                };
                my(@v_list) = sort $func_ref keys(%{$subclustfunc_ref->{"$key"}});
                my($v) = $v_list[0];

                my($tab) = 'cluster_func_clust2sql_' . $tabid;
                my($sql) = "update $tab set s$key=$v where clustid=? and subclustid=?";
                my($sth) = $db->prepare($sql);
                $sth->execute($cid, $scid);
            }
        }


        # update cluster function
        my(@key_list) = keys(%{$clustfunc_ref});
        foreach my$key (@key_list) {
            my($func_ref) = sub {
                $clustfunc_ref->{"$key"}->{"$b"} <=> $clustfunc_ref->{"$key"}->{"$a"};
            };
            my(@v_list) = sort $func_ref keys(%{$clustfunc_ref->{"$key"}});
            my($v) = $v_list[0];

            my($tab) = 'cluster_func_clust2sql_' . $tabid;
            my($sql) = "update $tab set s$key=$v where clustid=?";
            my($sth) = $db->prepare($sql);
            $sth->execute($cid);
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME
    }

    #
    foreach my$tabid (@ARGV) {
        upd_cluster_func($dbname, $tabid);
    }
}

1;#
