#!/usr/bin/perl -s

use MBGD;
use MBGD::WWW;

#use CGI;
require "emergency.pl";

$WWW = MBGD::WWW->new;

$Qstring = $WWW->cgiGetQueryString;
%Args = $WWW->cgiGetArgs;
if ($Args{spec}) {
	$entname = "$Args{spec}:$Args{name}";
} elsif ($Args{name}) {
	$entname = "$Args{name}";
} elsif ($Args{protid} || $Args{gi}) {
	my($db) = MBGD::DB->new;
	my($g);
	if ($Args{protid}) {
		if ($Args{protid} !~ /\.\d+/) {
			## no version 
			$query = "protid like '$Args{protid}.%'";
		} else {
			$query = "protid='$Args{protid}'";
		}

		$g = MBGD::Gene->find($db, $query);
		if (! $g) {
			my($opt);
			$opt = {'tablename' => 'gene'};
			$g = MBGD::Gene->find($db, $query, $opt);
		}
	} else {
		$g = MBGD::Gene->find($db, "gi=$Args{gi}");
		if (! $g) {
			my($opt);
			$opt = {'tablename' => 'gene'};
			$g = MBGD::Gene->find($db, "gi=$Args{gi}", $opt);
		}
	}
	if ($g) {
		$entname = $g->{sp} . ":" . $g->{name};
	}
	$Qstring = "name=$entname";
}

print "Content-Type:text/html\n\n";

print "<HTML>\n";
print "<HEAD>\n";
print "<TITLE>MBGD: Gene Information [$entname]</TITLE>\n";
print "</HEAD>\n";

$g = MBGD::Gene->get($entname);
if (! $g) {
	my($opt);
	$opt = {'tablename' => 'gene'};
	$g = MBGD::Gene->get($entname, $opt);
}
if (! $entname || ! $g) {
	print "<BODY>\n";
	print "$entname: " if ($entname);
	print "entry not found\n";
	print "</BODY>\n";
	$WWW->end_html;
	exit;
}

#print "</FRAMESET>\n";

print "<FRAMESET ROWS=\"60%,40%\">\n";
print "<FRAME NAME=\"info\" SRC=\"RECOG_gene_info.pl?$Qstring\">\n";
print "<FRAME NAME=\"appendix\" SRC=\"RECOG_region_map_html.pl?$Qstring\">\n";
print "</FRAMESET>\n";

$WWW->end_html;
#print "</HTML>\n";

exit(0);

###############################################################################
1;#
###############################################################################
