#!/usr/bin/perl -s

################################################################################
# ϰϤΥ󥹾Ϥ

use GD;
use MBGD;
use MBGD::WWW;
require "MBGD_common.pl";
require "libMBGDImgMap.pl";
require "libMBGDaxes.pl";
require "emergency.pl";

BEGIN{
print STDERR "START ", (times)[0], "\n";
}

#
$libMBGDImgMap::cgi_gene_info = 'RECOG_gene_info_frame.pl';

# Хѿ
#$Path_htbin = "$MBGD_PATH_HTBIN";

#
$WWW = MBGD::WWW->new;
$uInfo = $WWW->uInfo;

$db = MBGD::DB->new($ENV{'MYSQL_DB'});

print "Content-Type:text/plain\n\n" if( $TEST );
$DefaultWidth = 20000;

##if( defined( $ENV{'REQUEST_METHOD'} )) {
##    my($cgi) = CGI->new();
    my $cgi = $WWW->cgi;

    $Organism  = $cgi->param('spec');      # Organism Name
    $chrid     = $cgi->param('chrid');     # Chromosome No.
    $contigid  = $cgi->param('contigid');  # Contig No.
    $Map       = $cgi->param('map');       # Original map type(whole,region)
    $Length    = $cgi->param('length');    # Chromosome length
    $Width     = $cgi->param('width');     # Width of drawing region (bp)
    $PositionX = $cgi->param('position.x'); # Clicked position X
    $PositionY = $cgi->param('position.y'); # Clicked position Y
    $Zoom      = $cgi->param('zoom');       # Magnification
    $GeneName  = $cgi->param('genename');   # Gene to be centered in the region
    $FindGene  = $cgi->param('findgene');   # Gene name to be searched
    $Point     = $cgi->param('point');      # Center point of prev. page
    $Type      = $cgi->param('type');       # Chromosome shape (linear/circular)
    $NumLines  = $cgi->param('lines');      # Number of lines
    $MapScale  = $cgi->param('mapscale');  # Scale of the map image
    $NumLines = 1 if ($NumLines <= 0);
    $NumLines = 20 if ($NumLines > 20);

    $FindGene = $GeneName if ($GeneName);
    $Width = $DefaultWidth if (! $Width);
    $RegWidth = $DefaultWidth if (! $RegWidth);
    $Zoom = 1 if (! $Zoom);
    if ($FindGene && ! $PositionX) {
	$opt = {};
	my($infoGene) = MBGD::Gene->get($db, ["$Organism:$FindGene"], $opt);
	if (! $infoGene) {
	        ($infoGene) = MBGD::Gene->get($db,
			["$Organism:$FindGene"], {keys=>"sp:gene"});
	}
	if (! $infoGene) {
		&NotFound();
		exit;
	}
	$chrid = $infoGene->{chrid};
	$contigid = $infoGene->{contigid};

	$From     = $infoGene->{'from1'};
	$To       = $infoGene->{'to1'};
	$GeneName = $infoGene->{'name'};

	$Point    = int(( $From + $To + 1 ) / 2 );
	$RegStart = $Point - int( $RegWidth / 2 );
	$RegEnd   = $RegStart + $RegWidth;

    } elsif( $Map eq "whole" ) {
        if ($Organism =~ /sce|spo|ecu|cel/) {
		### Eukaryotic Linear Genome
            ($chrid,  $Point, $Length) = &get_pos_in_linear($PositionX,
                                      $PositionY,
                                      $Organism);
            $RegStart = $Point - int($RegWidth / 2 + 1);
            $check .= "$Seq_num/$Point/$Length/";
        } elsif ($Type =~ /linear/i) {
		### Prokaryotic Linear Genome
##            $Point = &get_pos_in_whole( $PositionX, $PositionY, $Length, $MapScale );
            $Point = &get_pos_in_whole_linear($PositionX, $PositionY, $Length, $MapScale);
            $RegStart = $Point - int( $RegWidth / 2 );
            if($RegStart < 1) {
                $RegStart = 1;
                $Point    = $RegStart + int($RegWidth / 2);
            } elsif($RegStart > $Length - $RegWidth) {
                $RegStart = $Length - $RegWidth;
                $Point    = $Length - int($RegWidth / 2);
            }
	} else {
		###  Circular Genome
            $Point    = &get_pos_in_whole( $PositionX, $PositionY, $Length, $MapScale );
            $RegStart = $Point - int( $RegWidth / 2 );
        }
    } elsif( $Map eq "region" ) {
        $RegStart = $Point - int( $RegWidth / 2 );
    } else {
        die "Illegal parameter : $Map\n";
    }
#}
#else {
#    $Organism = shift( @ARGV );         # Organism Name
#    $Sequence = shift( @ARGV );         # Sequence Name
#    $RegStart = shift( @ARGV );         # ꡼γϰ
#    $RegWidth = shift( @ARGV );         # ꡼Ĺ(bp)
#    $Path_htbin = "";
#}

$opt = {};
($infoGenome) = MBGD::Genome->get($db, ["$Organism"], $opt);
$stdOrganism  = $infoGenome->{'orgname'};
$strain  = $infoGenome->{'strain'};

if ($chrid) {
	($infoChr)    = MBGD::Chromosome->fetch($db, ["$chrid"], $opt);
} else {
print STDERR "contig==>$contigid\n";
	($infoChr)    = MBGD::Contig->fetch($db, ["$contigid"], $opt);
}
$stdSequence  = $infoChr->{'name'};
if ($infoChr->length()) {
	$Length = $infoChr->length();
}

$Zoom =~ s/^\s*x\s*//;
eval "\$RegWidth = \$Width /( $Zoom )";

if ($Length < $RegWidth) {
    ($PositionX, $PositionY) = (@MBGD_WHOLE_IMG_SIZE);
    $PositionX /= 2;
    $RegWidth= $Length;
}

# HTMLʸϤ
print "Content-Type:text/html\n\n";

print <<"EOD";
<HTML>
<HEAD>
<TITLE> Chromosome Region Map </TITLE>
</HEAD>
<BODY bgcolor="#f0fff0">
<CENTER> <H1> Chromosome Region Map </H1> </CENTER>
<CENTER> <H2><I> $stdOrganism </I> $strain $stdSequence </H2> </CENTER>
EOD

# ꡼γϰ֡λ֡󥿡֤
#
if($Type eq 'linear') {
    if($RegStart < 1) {
	$RegStart = 1;
	$Point    = int($RegWidth / 2);
    } elsif($RegStart > $Length - $RegWidth) {
	$RegStart = $Length - $RegWidth;
	$Point    = $Length - int($RegWidth / 2);
    }
}

$RegEnd = $RegStart + $RegWidth;
if( $RegEnd <= 0 ) {
    $RegStart += $Length + 1;
    $RegEnd   += $Length + 1;
    $Point    += $Length + 1;
} elsif ( $RegStart >= $Length ) {
    $RegStart -= $Length;
    $RegEnd   -= $Length;
    $Point    -= $Length;
}
if ($NumLines > 1) {
	$Point -= int(($NumLines-1) / 2) * $RegWidth;
}


# call create_clickable_map

if ($NumLines > 1) {
	$step = 1;
} else {
	$step = 0.8
}

$nextL =  $Point - $RegWidth * $step;
$nextR =  $Point + $RegWidth * $step;


print "<CENTER>\n";
for ($i = 0; $i < $NumLines; $i++) {

	$ImageMap = &create_clickable_map($Organism, $chrid, $contigid, $Point, $RegWidth);

	print <<"EOD";
<MAP NAME="REGION_MAP_$i">
$ImageMap
</MAP>
<IMG SRC="RECOG_region_image.pl?spec=$Organism&chrid=$chrid&contigid=$contigid&pos=$Point&width=$RegWidth&dir=0&name=$GeneName&mode=normal" USEMAP="#REGION_MAP_$i" BORDER=0>
EOD
	$Point += $RegWidth;
}
print "</CENTER>\n";

print <<"EOD";
<P>
<CENTER>
<A HREF="RECOG_region_html.pl?spec=$Organism&chrid=$chrid&contigid=$contigid&map=region&length=$Length&width=${RegWidth}&point=${nextL}&zoom=x1&type=$Type&lines=$NumLines"><IMG SRC=/image/blue_prev.gif></A>
<A HREF="RECOG_region_html.pl?spec=$Organism&chrid=$chrid&contigid=$contigid&map=region&length=$Length&width=${RegWidth}&point=${nextR}&zoom=x1&type=$Type&lines=$NumLines"><IMG SRC=/image/blue_next.gif></A>

<FORM METHOD POST ACTION="RECOG_region_html.pl">
<INPUT TYPE=hidden NAME=spec     VALUE=$Organism>
<INPUT TYPE=hidden NAME=chrid    VALUE=$chrid>
<INPUT TYPE=hidden NAME=map      VALUE=region>
<INPUT TYPE=hidden NAME=length   VALUE=$Length>
<INPUT TYPE=hidden NAME=point    VALUE=$Point>
<INPUT TYPE=hidden NAME=width    VALUE=$RegWidth>
<INPUT TYPE=hidden NAME=genename VALUE=$GeneName>
<INPUT TYPE=hidden NAME=type     VALUE=$Type>
</CENTER>
<P>
 Change Scale
<SELECT NAME="zoom">
<OPTION          VALUE="0.01"> x1/100
<OPTION          VALUE="0.1" > x1/10
<OPTION          VALUE="0.2" > x1/5
<OPTION SELECTED VALUE="0.5" > x1/2
<OPTION          VALUE="1"   > x1
<OPTION          VALUE="2"   > x2
<OPTION          VALUE="5"   > x5
<OPTION          VALUE="10"  > x10
<OPTION          VALUE="100" > x100
</SELECT>

Display Lines:<INPUT NAME="lines" VALUE="$NumLines" SIZE=3>
<INPUT TYPE="submit" VALUE="Exec">
</FORM>
<P>
<!-- HR -->
<!--- $check,$RegStart, $RegEnd, $stdSequence --->
EOD

print <<"EOD";
</BODY>
</HTML>
EOD
print STDERR "DONE ", (times)[0], "\n";

exit;

##################################################################################
## see perllib/libMBGDImgMap.pl
####
###sub get_pos_in_whole {
###    local( $pos_x, $pos_y, $width ) = @_;
###    local( $center_x, $center_y, $radius_min, $radius_max ) =
###         ( @MBGD_WHOLE_IMG_CENTER,
###           $MBGD_WHOLE_IMG_INNER_R, $MBGD_WHOLE_IMG_OUTER_R );
###    local( $radius, $diff_x, $diff_y, $angle );
###
###    if( $center_y == $pos_y ) {
###        $radius  = $pos_x - $center_x;
###        if( $radius > 0 ) {
###            $pos = int( $width / 4 );
###        }
###        else {
###            $pos = int( $width * 3 / 4 );
###            $radius *= -1;
###        }
###    }
###    else {
###        $diff_x = $center_y - $pos_y;
###        $diff_y = $pos_x - $center_x;
###        $radius = sqrt( $diff_x ** 2 + $diff_y ** 2 );
###
###        if( $diff_y >= 0 ) {
###            #  = atan2( 1, 1 ) * 4
###            $pos = int(atan2($diff_y, $diff_x) * $width / (atan2(1, 1) * 8));
###        }
###        else {
###            #  = atan2( 1, 1 ) * 4
###            $pos = int((atan2($diff_y, $diff_x)+(atan2(1, 1)*8))*$width/(atan2(1, 1)*8));
###        }
###    }
###
###    # å줿ΰ(١ܤ)֤
###    return $pos;
###}
###
##################################################################################
####
###sub get_pos_in_whole_linear {
###    local($pos_x, $pos_y, $width) = @_;
###    local($center_x, $center_y, $radius_min, $radius_max) =
###         (@MBGD_WHOLE_IMG_CENTER,
###          $MBGD_WHOLE_IMG_INNER_R, $MBGD_WHOLE_IMG_OUTER_R);
###    local($radius, $diff_x, $diff_y, $angle);
###
###    if($center_y == $pos_y) {
###        $radius  = $pos_x - $center_x;
###        if($radius > 0) {
###            $pos = int($width / 4);
###            $angle = atan2(1, 1) / 2;      #  / 2
###        }
###        else {
###            $pos = int($width * 3 / 4);
###            $radius *= -1;
###            $angle = atan2(1, 1) * 3 / 4;  #  * 3 / 4
###        }
###    }
###    else {
###        $diff_x = $center_y - $pos_y;
###        $diff_y = $pos_x - $center_x;
###        $radius = sqrt($diff_x ** 2 + $diff_y ** 2);
###
###        if($diff_y >= 0) {
###            #  = atan2(1, 1) * 4
###            $pos = int(atan2($diff_y, $diff_x) * $width / (atan2(1, 1) * 8));
###            $angle = atan2($diff_y, $diff_x);
###        }
###        else {
###            #  = atan2(1, 1 ) * 4
###            $pos = int((atan2($diff_y, $diff_x)+(atan2(1, 1)*8))*$width/(atan2(1, 1)*8));
###            $angle = atan2($diff_y, $diff_x) + atan2(1, 1) * 8;
###        }
###    }
###
###    # å줿ΰ(١ܤ)֤
###    $pos = $width * $angle * 360 / ($MBGD_WHOLE_IMG_LINEAR_ARC * atan2(1, 1) * 8);
###}
###
##################################################################################
####
###sub get_pos_in_region {
###    local( $pos_x, $pos_y, $from, $to ) = @_;
###    local( $img_width, $img_height ) = @MBGD_REGION_IMG_SIZE;
###    local( $click_point );
###
###    $click_point = ( $to - $from + 1) * $pos_x /( $img_width ) + $from;
###
###    int( $click_point );
###}
###
##################################################################################
#### ľΥΥˤݥ
#### input : XɸYɸɽΰ(bp)
#### return: name(bp)
###sub get_pos_in_linear {
###    my($pos_x, $pos_y, $width, $org) = @_;
###    my($seqNo);
###    my($chrid);
###    my($seqLen);
###
###    if($pos_y <= 70) {
###        $seqNo = 1;
###    }
###    else {
###        $seqNo = int(($pos_y - 40) / 30) + 1;
###    }
###
###    my($opt) = {};
###    $opt->{'keys'} = "sp:seqno";
###    $opt->{'with_length'} = 1;
###    my($infoChr) = MBGD::Chromosome->get($db, ["$org:$seqNo"], $opt);
###    $chrid = $infoChr->{'id'};
###    $seqLen = $infoChr->{'length'};
###    if($pos_x <= 150) {
###        $pos = 1;
###    }
###    else {
###        $seqEnd = int(($seqLen / $width) * (600 - 150)) + 150;
###        if($pos_x > $seqEnd) {
###            $pos = $seqLen;
###        }
###        else {
###            $pos = (($pos_x - 150) / (600 - 150)) * $width;
###        }
###    }
###
###    # å줿ΰ(١ܤ)֤
###    return($chrid, $pos, $seqLen);
###}
###
###############################################################################

sub NotFound {
print "Content-Type:text/html\n\n";

print <<"EOD";
<HTML>
<HEAD>
<TITLE> Gene Not Found </TITLE>
</HEAD>
<BODY>
<H2>The requested gene is not found.</H2>
<!--
You can also try
<A href=/htbin/advancedSearch.pl>Advanced Search form</A>
or <A href=/htbin/GeneNameList>Gene Name List</A> page
to retrieve genes.
-->
</BODY>
EOD
}
