#!/usr/bin/perl -s
###############################################################################
# Drawing a sequence region map of the specified gene
###############################################################################

use CGI;
use GD;
use MBGD;
use MBGD::FuncCat;
use MBGD::ClustTab::DB;
use MBGD::WWW;
use MBGD::WWW::SeqRegMap;
use RECOG::RecogCommon;
require "MBGD_common.pl";
require "libMBGDImg.pl";
require "libMBGDaxes.pl";
##require "libMBGDUserInfo.pl";
require "emergency.pl";

# MBGD::WWW::SeqRegMap $BFbIt$G;HMQ$7$F$$$kJQ?t$r(B RECOG $BMQ$KJQ99(B
$MBGD::WWW::SeqRegMap::MODE = 'RECOG';

#
if( defined( $ENV{'QUERY_STRING'} )) {
    my($cgi) = CGI->new();

    $Organism   = $cgi->param("spec");
    $chrid      = $cgi->param("chrid");
    $GeneName   = $cgi->param("name");
    $displayMode = $cgi->param("displayMode");
    $display    = $cgi->param("display");
    $tabid      = $cgi->param('tabid');
    $clustid      = $cgi->param('clustid');
} else {
    die "Parameter Error !!\n" if( scalar( @ARGV ) < 4 );
    ( $Organism, $Sequence, $RegCenter, $RegWidth,
      $Reverse, $GeneName, @GeneColor ) = @ARGV;
}
$WWW = MBGD::WWW->new;

$uInfo = $WWW->uInfo;
if ($displayMode =~ /Homology|Motif/) {
	$seqregMap = MBGD::WWW::SeqRegMap->new($GeneName, tabid=>$tabid);
} elsif ($displayMode =~ /MultAlign/) {
	$seqregMap = MBGD::WWW::SeqRegMap->new('', tabid=>$tabid, clustid=>$clustid, uInfo=>$uInfo, ImageWidth=>1200);
}

if ($displayMode eq 'Homology') {
	$seqregMap->drawAllHomology();
} elsif ($displayMode eq 'Motif') {
	$seqregMap->drawAllMotif();
} elsif ($displayMode eq 'MultAlign') {
	$seqregMap->drawAllMultAlign();
} elsif ($display) {
	$seqregMap->drawAll($display);
}
#foreach $d (split(/,/, $display)) {
#	if ($d eq 'scale') {
#		$seqregMap->drawScale();
#	} elsif ($d eq 'domain') {
#		$seqregMap->drawDomain($tabid);
#	} elsif ($d eq 'motif') {
#		$seqregMap->drawDomainMotifs();
#	} elsif ($d eq 'homology') {
#		$seqregMap->drawHomology();
#	}
#}
$seqregMap->drawImage(with_header=>1);
exit;

