#!/usr/bin/perl -s
use strict;
use CGI;
use IO::Dir;
use IO::File;
use MBGD::DB;
use MBGD::Taxonomy;
use GenePropAxes;
use UserScriptParams;

###############################################################################
#
sub print_html_spec {
    my($key) = shift;
    my($eg) = shift;

    my($db) = MBGD::DB->new();
    my($tax_ref) = MBGD::Taxonomy->new();
    my(@spec_list) = $tax_ref->get_all_spec();
    print qq{<select name="$key" multiple>\n};
    foreach my$spec (@spec_list) {
        my($genome_ref) = MBGD::Genome->get($db, [$spec]);
        my($name) = $genome_ref->{'orgname'};
        my($strain) = $genome_ref->{'strain'};
        if ($strain) {
            $name .= "($strain)";
        }
        print qq{<option value="$spec">[$spec] $name</option>\n};
    }
    print qq{</select><br>\n};

    return;
}

###############################################################################
#
sub print_html_select {
    my($key) = shift;
    my($eg) = shift;
    my($default) = shift;

    my(@val_list) = split(/\|/, $eg);
    print qq{$key :: <select name="$key">\n};
    foreach my$val (@val_list) {
        my($sta_select) = '';
        $val =~ s#[\r\n]*$##;
        if ($val eq $default) {
            $sta_select = 'selected';
        }
        print qq{<option value="$val" $sta_select>$val</option>\n};
    }
    print qq{</select><br>\n};

    return;
}

###############################################################################
#
sub print_html_text {
    my($key) = shift;
    my($eg) = shift;
    my($default) = shift;

    print qq{$key [$eg] :: <input type="text" title="$eg" name="$key" value="$default"><br>\n};

    return;
}

###############################################################################
#
sub get_segments_win {
    my($form_opts) = shift;

    #
    my($type) = $form_opts->{'type'};

    #
    my($seg_list_ref) = [];
    my($dir) = "$ENV{'RECOG_HOME'}/WWW/bin/segments.d/";
    do "$dir/$type";

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>
<h1>Get segments :: $type</h1>
<form name="" method="post" action="get_segments.cgi">
<input type="hidden" name="type" value="$type">
EOB

    #
    my($param_ref) = setup_params();
    my(@key_list) = $param_ref->get_key_list();
    foreach my$key (@key_list) {
        my($eg) = $param_ref->get_example($key);
        my($default) = $param_ref->get_default($key);
        if ($key =~ /^spec$/i) {
            print_html_spec($key, $eg, $default);
        }
        elsif ($eg =~ /\|/) {
            print_html_select($key, $eg, $default);
        }
        else {
            print_html_text($key, $eg, $default);
        }
    }

    print <<EOB;
<input type="submit" name="btn_submit" value="Exec">
</form>
</body>
</heml>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($form_opts) = {};

    my($cgi) = CGI->new();
    my(@key_list) = ('type');
    foreach my$key (@key_list) {
        $form_opts->{"$key"} = $cgi->param($key);
    }

    get_segments_win($form_opts);
}

###############################################################################
1;#
###############################################################################
