#!/usr/bin/perl -s
use strict;
use CGI;
use IO::Dir;
use IO::File;
use GenePropAxes;

###############################################################################
#
sub print_alignment_text {
    my($aligninf_ref) = shift;

    print "Content-type: text/plain\n";
    print "\n";

    print '#', join("\t", 'Type', 'Param(s)'), "\n";

    my(@type_list) = keys(%{$aligninf_ref});
    foreach my$type (@type_list) {
        my($params) = $aligninf_ref->{"$type"}->{'PARAMS'};
        $params =~ s#([^0-9a-z\_])#sprintf("%%%02x", ord($1))#egi;
        print join("\t", $type, $params), "\n";
    }

    return;
}

###############################################################################
#
sub print_alignment_html {
    my($aligninf_ref) = shift;

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>
<body>
<h1>Alignment type list.</h1>
<table border>
<tr><th>Type</th><th>Param(s)</th>
</tr>
EOB

    my(@type_list) = sort(keys(%{$aligninf_ref}));
    foreach my$type (@type_list) {
        my($param_ref) = $aligninf_ref->{"$type"}->{'PARAM_REF'};
        print "<tr><td><a href=\"get_alignment_win.cgi?type=$type\">$type</a></td>\n";
        print "    <td><pre>";
        if (defined($param_ref)) {
            print $param_ref->string_options();
        }
        else {
            print "Can not get param-info.\n";
        }
        print "        </pre></td>\n";
        print "</tr>\n";
    }

    print <<EOB;
</table>
</body>
</html>
EOB

    return;
}

###############################################################################
#
sub list_alignment {
    my($form_opts) = shift;

    my($aligninf_ref) = {};
    my($dir) = "$ENV{'RECOG_HOME'}/WWW/bin/align.d";
    my($dh) = IO::Dir->new($dir);
    if ($dir) {
        foreach my$file ($dh->read()) {
            next if ($file =~ /^\./);
#            next if ($file =~ /\.sample$/);
            next if (! -f "$dir/$file");
            next if (! -x "$dir/$file");

            #
            do "$dir/$file";
            my($ent) = {};
            $ent->{'NAME'} = $file;
            if (defined(&setup_params)) {
                $ent->{'PARAM_REF'} = setup_params();
                undef(&setup_params);
            }

            $aligninf_ref->{"$file"} = $ent;
        }
    }

    if ($form_opts->{'mode'} =~ /^text$/i) {
        print_alignment_text($aligninf_ref);
    }
    else {
        print_alignment_html($aligninf_ref);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($form_opts) = {};

    my(@key_list) = ('mode');
    my($cgi) = CGI->new();
    foreach my$key (@key_list) {
        $form_opts->{"$key"} = $cgi->param($key);
    }

    list_alignment($form_opts);
}

###############################################################################
1;#
###############################################################################
