#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub list_core_res {
    my($id_cluster) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    my($tab) = 'core_tables_idx';
    my($opt) = {};
    if ($id_cluster) {
        $opt->{'where'} = "clust_tab_id ='$id_cluster'";
    }
    $opt->{'order'} = 'cdate';
    my($refRes) = eval { $db->select_fetch($tab, $opt); };

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "<script>\n";
    print "function deleteCore(id, no_conf) {\n";
    print "  if (typeof no_conf === 'undefined' || no_conf == 0) {\n";
    print "     var sta\n";
    print "     if (id == '#ALL#') {\n";
    print "         sta = confirm('Delete all core data? ');\n";
    print "     } else {\n";
    print "         sta = confirm('Delete this core? :' + id );\n";
    print "     }\n";
    print "     if (!sta) {\n";
    print "       return;\n";
    print "     }\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_del_core.id_core.value = id;\n";
    print "  doc.frm_del_core.action = '/htbin/RECOG/delete_core.cgi';\n";
    print "  doc.frm_del_core.submit();\n";
    print "}\n";

    print "function deleteCoreAll() {\n";
    print "  for (var i = 0; i < arguments.length; i++) {\n";
    print "    deleteCore(arguments[i], 1);\n";
    print "  }\n";
    print "}\n";

    print "function killCore(id) {\n";
    print "  var sta = confirm('Kill this process?');\n";
    print "  if (!sta) {\n";
    print "    return;\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_del_core.id_core.value = id;\n";
    print "  doc.frm_del_core.action = '/htbin/RECOG/kill_core.cgi';\n";
    print "  doc.frm_del_core.submit();\n";
    print "}\n";

    print "</script>\n";
    print "</head>\n";

    print "<body>\n";
    if ($refRes->{'ROWS'} == 0) {
        print "<h1>No core result</h1>\n";
    }
    else {
        print "<h1>Core result(s)</h1>\n";
        print "<form name=\"frm_del_core\" method=\"post\" action=\"/htbin/RECOG/delete_core.cgi\">\n";
        print "<input type=\"hidden\" name=\"id_core\" value=\"\">\n";
        print "<input type=\"button\" value=\"Clear All Results\" onclick=\"deleteCore('#ALL#');\">\n";
        print "<table border>\n";
        print "<tr><th></th>\n";
        print "    <th nowrap>Core ID</th>\n";
        print "    <th nowrap>Status</th>\n";
        print "    <th nowrap>Date</th>\n";
        print "    <th nowrap>Parameter(s)</th>\n";
        print "</tr>\n";

	my(@del_list);

        foreach my$ref (@{$refRes->{'INFO'}}) {
            #
            my($id_core) = $ref->{'core_tab_id'};

            #
            my($core_ymd, $core_hms) = split(/\s/, $ref->{'cdate'});
            my($core_date) = $core_ymd . '<br>' . $core_hms;

            #
            my($status) = 'finished';
            if ($ref->{'status'} == 0) {
		push(@del_list, $id_core);
                $status = 'error';
            }
            elsif (0 < $ref->{'status'}) {
		if ( my $stat = kill(0, $ref->{'status'}) ) {
                	$status = 'running';
		} else {
			push(@del_list, $id_core);
                	$status = 'stopped';
		}
            }

            #
            my($cmd) = $ref->{'cmd'};

            my(%opt_core1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
            my($opt_core1) = '';
            foreach my$k (sort keys(%opt_core1)) {
                next if ($k =~ /\-DIR_WORK/);
                next if ($k =~ /\-alignout/);
                next if ($k =~ /\-clustout/);
                next if ($k =~ /\-clusttab/);
                next if ($k =~ /\-core_clustout/);
                next if ($k =~ /\-corealigner/);
                next if ($k =~ /\-datapath/);
                next if ($k =~ /\-linkout/);
                next if ($k =~ /\-pairout/);

                my($v) = $opt_core1{"$k"};
                $opt_core1 .= "$k=$v<br>\n";
            }

            my(%opt_core2) = ($cmd =~ /(\-[A-Z]+)([\d\.]+)/gi);
            my($opt_core2) = '';
            foreach my$k (sort keys(%opt_core2)) {
                my($v) = $opt_core2{"$k"};
                $opt_core2 .= " , " if ($opt_core2 ne '');
                $opt_core2 .= "$k$v\n";
            }

            my($opt_core) = $opt_core1 . $opt_core2;

            print "<tr><td>";
            if ($status =~ /^running/i) {
                print "<input type=\"button\" value=\"Kill\" onclick=\"killCore('$id_core');\">\n";
	    } else {
                print "<input type=\"button\" value=\"Del\" onclick=\"deleteCore('$id_core');\">\n";
            }
            print "    </td>\n";
            print "    <td nowrap>$id_core</td>\n";
            print "    <td nowrap>$status</td>\n";
            print "    <td align=\"center\" nowrap>$core_date</td>\n";
            print "    <td nowrap>$opt_core</td>\n";
            print "\n";
            print "</tr>\n";
        }
        print "</table>\n";
	if (@del_list) {
		my($del_list) = join(",", @del_list);
		print "Delete All Errors: $del_list\n";
		print "<input type=\"button\" value=\"Delete\" onclick=\"deleteCore('$del_list');\">\n";
	}
        print "</form>\n";
    }
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($id_cluster) = $cgi->param('id_cluster');

    list_core_res($id_cluster);
}

###############################################################################
1;#
###############################################################################
