#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG;
use RECOG::Cache::mysql;
require 'MBGD_Conf.pl';

###############################################################################
#
sub list_taxmap_res {
    my($id_cluster) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    my($tab) = "$main::TBL_DOMINDEX clusttab, $main::TBL_TAXMAPINDEX clustmap";
    my($opt) = {};
    $opt->{'where'} = "clusttab.clusterID=clustmap.clustid";
    if ($id_cluster) {
        $opt->{'where'} .= " and clustmap.clustid ='$id_cluster'";
    }
    $opt->{'order'} = 'dumpid, cdate, udate, mapspec, mapspecid';
    my($refRes) = eval { $db->select_fetch($tab, $opt); };

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "<script>\n";
    print "function deleteTaxmap(id) {\n";
    print "  var sta = confirm('Delete this taxmap?');\n";
    print "  if (!sta) {\n";
    print "    return;\n";
    print "  }\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_del_taxmap.taxmap_id.value = id;\n";
    print "  doc.frm_del_taxmap.action = '/htbin/RECOG/delete_taxmap.cgi';\n";
    print "  doc.frm_del_taxmap.submit();\n";
    print "}\n";
    print "</script>\n";
    print "</head>\n";

    print "<body>\n";
    if ($refRes->{'ROWS'} == 0) {
        print "<h1>No taxmap</h1>\n";
    }
    else {
        print "<h1>Taxmap(s)</h1>\n";
        print "<form name=\"frm_del_taxmap\" method=\"post\" action=\"/htbin/RECOG/delete_taxmap.cgi\">\n";
        print "<input type=\"hidden\" name=\"taxmap_id\" value=\"\">\n";
        print "<table border>\n";
        print "<tr><th></th>\n";
        print "    <th nowrap>Cluster ID<br>(mapid)</th>\n";
        print "    <th nowrap>Date</th>\n";
        print "    <th nowrap>Maping species</th>\n";
        print "    <th nowrap>record(s)</th>\n";
        print "    <th nowrap>Clustering parameter(s)</th>\n";
        print "</tr>\n";

        foreach my$ref (@{$refRes->{'INFO'}}) {
            #
            my($dumpid) = $ref->{'dumpid'};

            #
            my($taxmap_ymd, $taxmap_hms) = split(/\s/, $ref->{'udate'});
            my($taxmap_date) = $taxmap_ymd . '<br>' . $taxmap_hms;

            #
            my($cmd) = $ref->{'cmd'};

            $cmd = RECOG::Cache::mysql->getCmdForDump($cmd);
            my(%opt_clust1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
            my($opt_clust1) = '';
            foreach my$k (sort keys(%opt_clust1)) {
                my($v) = $opt_clust1{"$k"};
                $opt_clust1 .= "$k=$v<br>\n";
            }

            #
            my($mapspec)   = $ref->{'mapspec'};
            my($mapspecid) = $ref->{'mapspecid'};
            if (!$mapspecid) {
                next;
            }
            my($tab) = "cluster_taxmap_" . $mapspecid;
            my($sql) = "select count(*) as n from $tab";
            my($sth) = $db->execute($sql);
            my($n_ref) = $sth->fetchrow_hashref();
            my($n_rec) = $n_ref->{'n'};

            print qq{    <td align="center"><input type="button" name="btn_del_taxmap" value="Del" onclick="deleteTaxmap('$mapspecid');"></td>\n};
            print qq{    <td align="center" nowrap>$dumpid<br>($mapspecid)</td>\n};
            print qq{    <td align="center" nowrap>$taxmap_date</td>\n};
            print qq{    <td align="center" nowrap>$mapspec</td>\n};
            print qq{    <td align="right"  nowrap>$n_rec</td>\n};
            print qq{    <td align="left"   nowrap>$opt_clust1</td>\n};

            print "\n";
            print "</tr>\n";
        }
        print "</table>\n";
        print "</form>\n";
    }
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($id_cluster) = $cgi->param('id_cluster');

    list_taxmap_res($id_cluster);
}

###############################################################################
1;#
###############################################################################
